/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.state;

import com.conquestrefabricated.client.gui.PickerScreen;
import com.conquestrefabricated.client.gui.render.Render;
import com.conquestrefabricated.core.item.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_332;

public class BlockStateScreen
extends PickerScreen<class_2680> {
    private final Collection<class_2769<?>> properties;

    public BlockStateScreen(class_1799 stack, class_2680 state, List<class_2680> states, Collection<class_2769<?>> properties) {
        super("State Selector", stack, state, states);
        this.properties = properties;
    }

    @Override
    public boolean match(class_2680 a, class_2680 b) {
        for (class_2769<?> property : this.properties) {
            if (a.method_11654(property).equals(b.method_11654(property))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getSize() {
        return 5;
    }

    @Override
    public int getYOffset() {
        return -30;
    }

    @Override
    public int getWidth(class_2680 option) {
        return 1;
    }

    @Override
    public int getHeight(class_2680 option) {
        return 1;
    }

    @Override
    public String getDisplayName(class_2680 option) {
        StringBuilder sb = new StringBuilder();
        for (class_2769<?> property : this.properties) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(property.method_11899()).append('=').append(option.method_11654(property));
        }
        return sb.toString();
    }

    @Override
    public void render(class_2680 option, class_332 matrixStack, int x, int y, int width, int height, float scale) {
        matrixStack.method_51448().method_22903();
        matrixStack.method_51448().method_46416((float)x + (float)width / 2.0f, (float)y + (float)height / 2.0f, 0.0f);
        matrixStack.method_51448().method_22905(scale, scale, 1.0f);
        Render.drawBlockModel(matrixStack.method_51448(), option, -8, -8, 1.0f);
        matrixStack.method_51448().method_22909();
    }

    @Override
    public class_1799 createItemStack(class_1799 original, class_2680 value) {
        class_1799 stack = ItemUtils.fromState(value, this.properties);
        stack.method_7939(original.method_7947());
        return stack;
    }

    public static Optional<BlockStateScreen> of(class_1799 stack, class_2680 state, Predicate<class_2769<?>> filter) {
        HashMap<class_2769, Comparable> defaults = new HashMap<class_2769, Comparable>();
        HashSet properties = new HashSet();
        for (class_2769 property : state.method_28501()) {
            if (filter.test(property)) {
                Comparable defValue = state.method_11654(property);
                defaults.put(property, defValue);
                continue;
            }
            properties.add(property);
        }
        ArrayList<class_2680> states = new ArrayList<class_2680>();
        for (class_2680 candidate : state.method_26204().method_9595().method_11662()) {
            boolean valid = true;
            for (Map.Entry e : candidate.method_11656().entrySet()) {
                Object defValue = defaults.get(e.getKey());
                if (defValue == null || defValue.equals(e.getValue())) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            states.add(candidate);
        }
        if (states.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new BlockStateScreen(stack, state, states, properties));
    }
}

