/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_811;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;

public class ModelRender {
    private static final int[] lightmap = new int[]{0xF000F0, 0xF000F0, 0xF000F0, 0xF000F0};
    private static final Matrix4f flipX = new Matrix4f().scale(-1.0f, 1.0f, 1.0f);
    private static final Matrix3f flipXNormal = new Matrix3f((Matrix4fc)flipX);

    public static void renderModel(class_4587 poseStack, class_1087 model, int x, int y, int color) {
        ModelRender.renderModel(poseStack, class_811.field_4317, model, x, y, color);
    }

    public static void renderModel(class_4587 poseStack, class_811 transform, class_1087 model, int x, int y, int color) {
        boolean flag;
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        posestack.method_46416((float)x, (float)y, 100.0f);
        posestack.method_46416(8.0f, 8.0f, 0.0f);
        posestack.method_22905(1.0f, -1.0f, 1.0f);
        posestack.method_22905(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixstack = new class_4587();
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        model = ModelRender.handleCameraTransforms(matrixstack, model, transform, false);
        boolean bl = flag = !model.method_24304();
        if (flag) {
            class_308.method_24210();
        }
        ModelRender.renderModel(matrixstack, class_1921.method_23581(), buffer, model, color);
        buffer.method_22993();
        RenderSystem.enableDepthTest();
        if (flag) {
            class_308.method_24211();
        }
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderModel(class_4587 poseStack, class_2680 state, class_1087 model, int x, int y, int color) {
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.method_22903();
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_46416((float)x, (float)y, 100.0f);
        posestack.method_46416(8.0f, 8.0f, 0.0f);
        posestack.method_22905(1.0f, -1.0f, 1.0f);
        posestack.method_22905(16.0f, 16.0f, 16.0f);
        class_4587 matrix = new class_4587();
        matrix.method_22903();
        matrix.method_22904(-0.75, 0.0, 0.0);
        float f = (float)java.lang.Math.toRadians(30.0);
        float g = (float)java.lang.Math.toRadians(0.0);
        float i = Math.sin((float)(0.5f * f));
        float j = Math.cos((float)(0.5f * f));
        float k = Math.sin((float)(0.5f * g));
        float l = Math.cos((float)(0.5f * g));
        float m = Math.sin((float)(0.5f * g));
        float n = Math.cos((float)(0.5f * g));
        matrix.method_22907(new Quaternionf(30.0f, 30.0f, 0.0f, j * l * n - i * k * m));
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        class_310.method_1551().method_1541().method_3353(state, matrix, (class_4597)buffer, 0xF000F0, class_4608.field_21444);
        matrix.method_22909();
        buffer.method_22993();
        RenderSystem.enableDepthTest();
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderModel(class_4587 matrix, class_1921 rendertype, class_4597.class_4598 buffer, class_1087 model, int color) {
        matrix.method_22903();
        matrix.method_22904(-0.5, -0.5, -0.5);
        class_4588 builder = ModelRender.getBuffer((class_4597)buffer, rendertype, true, false);
        ModelRender.renderModel(model, matrix, builder, color);
        matrix.method_22909();
    }

    private static void renderModel(class_1087 modelIn, class_4587 matrix, class_4588 buffer, int color) {
        class_5819 random = class_5819.method_43047();
        long i = 42L;
        for (class_2350 direction : class_2350.values()) {
            random.method_43052(42L);
            ModelRender.renderQuads(matrix, buffer, modelIn.method_4707(null, direction, random), color);
        }
        random.method_43052(42L);
        ModelRender.renderQuads(matrix, buffer, modelIn.method_4707(null, null, random), color);
    }

    private static void renderQuads(class_4587 matrix, class_4588 buffer, List<class_777> quads, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_4587.class_4665 entry = matrix.method_23760();
        for (class_777 bakedquad : quads) {
            ModelRender.render(buffer, bakedquad, entry, r, g, b, 1.0f);
        }
    }

    private static void render(class_4588 bufferIn, class_777 quadIn, class_4587.class_4665 entry, float red, float green, float blue, float alpha) {
        int[] aint = quadIn.method_3357();
        class_2382 vec3i = quadIn.method_3358().method_10163();
        Vector3f vector3f = new Vector3f((float)vec3i.method_10263(), (float)vec3i.method_10264(), (float)vec3i.method_10260());
        Matrix4f matrix4f = entry.method_23761();
        vector3f.mul((Matrix3fc)entry.method_23762());
        int i = 8;
        int j = aint.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(class_290.field_1590.method_1362());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                intbuffer.clear();
                intbuffer.put(aint, k * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                int l = java.lang.Math.min(k, lightmap.length - 1);
                int light = ModelRender.applyBakedLighting(lightmap[l], bytebuffer);
                float u = bytebuffer.getFloat(16);
                float v = bytebuffer.getFloat(20);
                Vector4f vector4f = new Vector4f(f, f1, f2, 1.0f);
                vector4f.mul((Matrix4fc)matrix4f);
                ModelRender.applyBakedNormals(vector3f, bytebuffer, entry.method_23762());
                bufferIn.method_23919(vector4f.x, vector4f.y, vector4f.z, red, green, blue, alpha, u, v, class_4608.field_21444, light, vector3f.x, vector3f.y, vector3f.z);
            }
        }
    }

    private static int applyBakedLighting(int lightmapCoord, ByteBuffer data) {
        int bl = class_765.method_24186((int)lightmapCoord);
        int sl = class_765.method_24187((int)lightmapCoord);
        int offset = 24;
        int blBaked = Short.toUnsignedInt(data.getShort(offset)) >> 4;
        int slBaked = Short.toUnsignedInt(data.getShort(offset + 2)) >> 4;
        bl = java.lang.Math.max(bl, blBaked);
        sl = java.lang.Math.max(sl, slBaked);
        return class_765.method_23687((int)bl, (int)sl);
    }

    private static void applyBakedNormals(Vector3f generated, ByteBuffer data, Matrix3f normalTransform) {
        byte nx = data.get(28);
        byte ny = data.get(29);
        byte nz = data.get(30);
        if (nx != 0 || ny != 0 || nz != 0) {
            generated.set((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
            generated.mul((Matrix3fc)normalTransform);
        }
    }

    public static class_4588 getBuffer(class_4597 buffer, class_1921 type, boolean isItemIn, boolean dummy) {
        return buffer.getBuffer(type);
    }

    public static class_1087 handleCameraTransforms(class_4587 poseStack, class_1087 model, class_811 cameraTransformType, boolean leftHandHackery) {
        class_4587 stack = new class_4587();
        model.method_4709().method_3503(cameraTransformType).method_23075(true, stack);
        if (!stack.method_22911()) {
            Matrix4f tMat = stack.method_23760().method_23761();
            Matrix3f nMat = stack.method_23760().method_23762();
            if (leftHandHackery) {
                flipX.mul((Matrix4fc)tMat);
                tMat.mul((Matrix4fc)flipX);
                flipXNormal.mul((Matrix3fc)nMat);
                nMat.mul((Matrix3fc)flipXNormal);
            }
            poseStack.method_23760().method_23761().mul((Matrix4fc)tMat);
            poseStack.method_23760().method_23762().mul((Matrix3fc)nMat);
        }
        return model;
    }
}

