/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.palette.component;

import java.awt.Color;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class ColorPicker
extends class_4185 {
    private static final int pickerWidth = 128;
    private static final int pickerHeight = 32;
    private static final int sliderWidth = 128;
    private static final int sliderHeight = 10;
    private static final int padding = 1;
    private static final int titleHeight = 10;
    private static final int lineColor = -1711276033;
    private static final float hueOffset = 0.68f;
    private float hue = 0.0f;
    private float saturation = 0.5f;
    private float brightness = 1.0f;
    private boolean dirty = true;
    private final String title;
    private final Consumer<Integer> consumer;
    private final class_1043 picker = new class_1043(new class_1011(128, 32, false));
    private final class_1043 slider = new class_1043(new class_1011(128, 10, false));
    private final class_2960 PICKER_ID;
    private final class_2960 SLIDER_ID;

    public ColorPicker(String title, int initial, Consumer<Integer> consumer) {
        super(0, 0, 128, 53, (class_2561)class_2561.method_43471((String)""), button -> {}, supplier -> null);
        this.title = title;
        this.consumer = consumer;
        float[] hsb = new Color(initial).getColorComponents(new float[3]);
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
        this.PICKER_ID = class_310.method_1551().method_1531().method_4617("picker", this.picker);
        this.SLIDER_ID = class_310.method_1551().method_1531().method_4617("slider", this.slider);
    }

    public void method_25394(class_332 drawContext, int mx, int my, float ticks) {
        if (this.dirty) {
            this.renderImage();
        }
        int top = this.method_46427();
        int left = this.method_46426();
        drawContext.method_25303(class_310.method_1551().field_1772, "TEST", top, left, 0xFFFFFF);
        this.picker.method_23207();
        drawContext.method_25293(this.PICKER_ID, left, top += 10, 128, 32, 0.0f, 0.0f, 128, 32, 128, 32);
        this.slider.method_23207();
        drawContext.method_25293(this.SLIDER_ID, left, top += 33, 128, 10, 0.0f, 0.0f, 128, 10, 128, 10);
    }

    public boolean method_25403(double x1, double y1, int button, double x2, double y2) {
        if (this.interact(x2, y2)) {
            return true;
        }
        return super.method_25403(x1, y1, button, x2, y2);
    }

    public boolean method_25402(double mx, double my, int button) {
        if (this.interact(mx, my - 10.0)) {
            return super.method_25402(mx, my, button);
        }
        return false;
    }

    public void dispose() {
        this.picker.close();
        this.slider.close();
    }

    private boolean interact(double mx, double my) {
        boolean color = this.click(mx, my, this.method_46426(), this.method_46427(), this.picker, (x, y) -> {
            this.hue = x.floatValue();
            this.saturation = y.floatValue();
            this.consumer.accept(ColorPicker.getRGB(this.hue, this.saturation, this.brightness));
            this.dirty = true;
        });
        if (color) {
            return true;
        }
        return this.click(mx, my, this.method_46426(), this.method_46427() + 32 + 1, this.slider, (x1, y1) -> {
            this.brightness = x1.floatValue();
            this.consumer.accept(ColorPicker.getRGB(this.hue, this.saturation, this.brightness));
            this.dirty = true;
        });
    }

    private boolean click(double mx, double my, int left, int top, class_1043 texture, BiConsumer<Float, Float> consumer) {
        class_1011 image = texture.method_4525();
        if (image == null) {
            return false;
        }
        if (mx >= (double)left && mx < (double)(left + image.method_4307()) && my >= (double)top && my < (double)(top + image.method_4323())) {
            float dx = (int)mx - left;
            float dy = (int)my - top;
            float x = dx / (float)image.method_4307();
            float y = dy / (float)image.method_4323();
            consumer.accept(Float.valueOf(x), Float.valueOf(y));
            return true;
        }
        return false;
    }

    private void renderImage() {
        this.renderColor();
        this.renderBrightness();
        this.picker.method_4524();
        this.slider.method_4524();
    }

    private void renderColor() {
        class_1011 picker = this.picker.method_4525();
        if (picker == null) {
            return;
        }
        int crosshairX = (int)((float)picker.method_4307() * this.hue);
        int crosshairY = (int)((float)picker.method_4323() * this.saturation);
        float displayBrightness = 0.5f + 0.5f * this.brightness;
        for (int y = 0; y < picker.method_4323(); ++y) {
            float sat = (float)y / 32.0f;
            for (int x = 0; x < picker.method_4307(); ++x) {
                float hue = (float)x / 128.0f;
                int rgb = Color.HSBtoRGB(hue, sat, displayBrightness);
                picker.method_4305(x, y, rgb);
                if (x != crosshairX && y != crosshairY) continue;
            }
        }
    }

    private void renderBrightness() {
        class_1011 slider = this.slider.method_4525();
        if (slider == null) {
            return;
        }
        int slidebarX = (int)((float)slider.method_4307() * this.brightness);
        for (int x = 0; x < slider.method_4307(); ++x) {
            float brightness = (float)x / (float)slider.method_4307();
            for (int y = 0; y < slider.method_4323(); ++y) {
                int rgb = Color.HSBtoRGB(this.hue, this.saturation, brightness);
                slider.method_4305(x, y, rgb);
                if (x != slidebarX) continue;
            }
        }
    }

    private static int getRGB(float hue, float saturation, float brightness) {
        Color rgb = Color.getHSBColor(hue, saturation, brightness);
        return rgb.getRGB();
    }
}

