/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.palette;

import com.conquestrefabricated.client.gui.AbstractContainer;
import com.conquestrefabricated.client.gui.Hotbar;
import com.conquestrefabricated.client.gui.palette.component.PaletteSettings;
import com.conquestrefabricated.client.gui.palette.component.PaletteSlot;
import com.conquestrefabricated.client.gui.palette.component.Style;
import com.conquestrefabricated.client.gui.palette.shape.Bounds;
import com.conquestrefabricated.client.gui.palette.shape.FloatMath;
import com.conquestrefabricated.client.gui.palette.shape.Point;
import com.conquestrefabricated.client.gui.palette.shape.Polygon;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_465;
import net.minecraft.class_7699;
import org.jetbrains.annotations.Nullable;

public class PaletteContainer
extends AbstractContainer {
    public static final class_3917<PaletteContainer> TYPE = new class_3917(PaletteContainer::new, class_7699.method_45397());
    private static final class_2960 BACKGROUND = new class_2960("conquest:textures/gui/picker/slot.png");
    public static final int RADIUS = 65;
    private static final int EDGES = 6;
    private static final int PADDING = 40;
    private static final int ANGLE_OFFSET = -90;
    private final int radialCount;
    private final Style centerStyle;
    private final Style radialStyle;
    private final Style draggedStyle;
    private final class_1263 paletteInventory;
    private final Hotbar hotbar;

    private PaletteContainer(int id, class_1263 inventory) {
        super(TYPE, id);
        this.radialCount = 0;
        this.hotbar = new Hotbar(inventory);
        this.paletteInventory = inventory;
        this.centerStyle = Style.center(BACKGROUND);
        this.draggedStyle = Style.center(BACKGROUND);
        this.radialStyle = Style.radial(0, BACKGROUND);
    }

    public PaletteContainer(class_1263 inventory, class_1263 palette) {
        super(TYPE, 0);
        this.radialCount = palette.method_5439() - 1;
        this.hotbar = new Hotbar(inventory);
        this.paletteInventory = palette;
        this.centerStyle = Style.center(BACKGROUND);
        this.draggedStyle = Style.center(BACKGROUND);
        this.radialStyle = Style.radial(this.radialCount, BACKGROUND);
    }

    public void updateStyle(PaletteSettings settings) {
        this.draggedStyle.highlightScale = settings.highlightScale;
        this.draggedStyle.highlightColor = settings.highlightColor;
        this.draggedStyle.highlightColor = settings.selectedColor;
        this.radialStyle.highlightScale = settings.highlightScale;
        this.radialStyle.highlightColor = settings.highlightColor;
        this.radialStyle.hoveredColor = settings.hoveredColor;
        this.centerStyle.highlightScale = settings.highlightScale;
        this.centerStyle.highlightColor = settings.highlightColor;
        this.centerStyle.hoveredColor = settings.hoveredColor;
    }

    public Style getDraggedStyle() {
        return this.draggedStyle;
    }

    public void init(class_465<?> screen) {
        int centerX = 109;
        int centerY = 109;
        this.field_7761.clear();
        this.method_7621(new PaletteSlot(this.paletteInventory, this.centerStyle, Bounds.NONE, 0, centerX, centerY));
        Polygon polygon = new Polygon(6, 65, 40, 40);
        polygon.init(centerX, centerY);
        float spacing = 360.0f / (float)this.radialCount;
        float halfSpacing = spacing / 2.0f;
        for (int slotIndex = 1; slotIndex < this.paletteInventory.method_5439(); ++slotIndex) {
            int posIndex = slotIndex - 1;
            float angle = FloatMath.clampAngle((float)posIndex * spacing + -90.0f);
            Point pos = polygon.getPosition(angle);
            Bounds bounds = polygon.getBounds(angle, halfSpacing);
            this.method_7621(new PaletteSlot(this.paletteInventory, this.radialStyle, bounds, slotIndex, pos.x, pos.y));
            if (slotIndex < this.paletteInventory.method_5439()) continue;
            throw new UnsupportedOperationException();
        }
        int screenBottom = screen.field_22790 - screen.field_2800;
        int top = screenBottom - this.hotbar.getHeight();
        this.hotbar.addTo(this, centerX, top);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1735 slot;
        if (index >= this.field_7761.size() - 9 && index < this.field_7761.size() && (slot = (class_1735)this.field_7761.get(index)) != null && slot.method_7681()) {
            slot.method_48931(class_1799.field_8037);
        }
        return class_1799.field_8037;
    }

    public boolean method_7615(class_1735 slot) {
        return slot.field_7871 != this.paletteInventory;
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        return slot.field_7871 != this.paletteInventory;
    }

    public boolean method_7597(class_1657 player) {
        return player.method_7337();
    }

    public Hotbar getHotbar() {
        return this.hotbar;
    }

    public class_1263 getPaletteInventory() {
        return this.paletteInventory;
    }

    public void visitHotbar(Consumer<class_1735> consumer) {
        for (int i = this.field_7761.size() - 9; i < this.field_7761.size(); ++i) {
            consumer.accept(this.method_7611(i));
        }
    }

    public void visitCenter(Consumer<PaletteSlot> consumer) {
        PaletteSlot slot = (PaletteSlot)this.method_7611(0);
        consumer.accept(slot);
    }

    public void visitRadius(int mouseX, int mouseY, BiConsumer<PaletteSlot, Float> consumer) {
        class_1735 closest = this.getClosestSlot(mouseX, mouseY, false);
        if (closest == null) {
            return;
        }
        int index = closest.field_7874 - 1;
        this.visitRadialSlot(index, 0, consumer);
        int i = 1;
        for (int visited = 0; visited < this.radialCount && visited + 1 < this.radialCount; visited += 2) {
            this.visitRadialSlot(index - i, i, consumer);
            if (visited + 2 >= this.radialCount) break;
            this.visitRadialSlot(index + i, i, consumer);
            ++i;
        }
    }

    private void visitRadialSlot(int index, int relativeIndex, BiConsumer<PaletteSlot, Float> consumer) {
        int slotIndex = this.wrapSlotIndex(index);
        float depth = this.getRelativeDepth(relativeIndex);
        PaletteSlot slot = (PaletteSlot)this.method_7611(slotIndex + 1);
        consumer.accept(slot, Float.valueOf(depth));
    }

    private int wrapSlotIndex(int index) {
        if (index < 0) {
            return this.radialCount + index;
        }
        if (index >= this.radialCount) {
            return index - this.radialCount;
        }
        return index;
    }

    private float getRelativeDepth(float i) {
        if (i == 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Nullable
    public class_1735 getClosestSlot(int mouseX, int mouseY, boolean all) {
        class_1735 nearest = null;
        int dist2 = Integer.MAX_VALUE;
        for (class_1735 slot : this.field_7761) {
            if (!all && (slot.method_34266() == 0 || slot.field_7871 != this.paletteInventory)) continue;
            int dx = slot.field_7873 + 8 - mouseX;
            int dy = slot.field_7872 + 8 - mouseY;
            int d2 = dx * dx + dy * dy;
            if (nearest != null && d2 >= dist2) continue;
            nearest = slot;
            dist2 = d2;
        }
        return nearest;
    }
}

