/*
 * Decompiled with CFR 0.152.
 */
package com.conquestrefabricated.client.gui.dependency;

import com.conquestrefabricated.client.gui.dependency.Dependency;
import com.conquestrefabricated.client.gui.dependency.DependencyType;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DependencyList {
    private final List<Dependency> dependencies;

    public DependencyList(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public List<Dependency> getMissingDependencies() {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (Dependency dependency : this.dependencies) {
            if (dependency.getType().isAvailable(dependency)) continue;
            result.add(dependency);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DependencyList load() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(DependencyList.class.getResourceAsStream("/dependencies.json")));){
            JsonElement element = new JsonParser().parse((Reader)reader);
            if (!element.isJsonArray()) return new DependencyList(Collections.emptyList());
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            for (JsonElement e : element.getAsJsonArray()) {
                if (!e.isJsonObject()) continue;
                JsonObject root = e.getAsJsonObject();
                DependencyType type = DependencyType.of(root.get("type").getAsString());
                String id = root.get("id").getAsString();
                String name = root.get("name").getAsString();
                String url = root.get("url").getAsString();
                dependencies.add(new Dependency(type, id, name, url));
            }
            DependencyList dependencyList = new DependencyList(dependencies);
            return dependencyList;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new DependencyList(Collections.emptyList());
    }
}

