/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.data.recipes;

import com.conquest.hearthfire.data.recipes.RecipeBookCategory;
import com.conquest.hearthfire.data.recipes.RecipeUtils;
import com.conquest.hearthfire.world.item.crafting.ModRecipeSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2444;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WoodworkingRecipeBuilder
implements class_5797 {
    private final RecipeBookCategory category;
    private final class_1792 result;
    private class_1856 ingredient;
    private class_1856 supplement;
    private class_1856 dye = class_1856.field_9017;
    private int ingredientCount;
    private int supplementCount;
    private int dyeCount;
    private final int resultCount;
    private final class_161.class_162 advancement = class_161.class_162.method_51698();
    @Nullable
    private String group;
    private final class_1865<?> type;
    private boolean ingredientSet = false;
    private boolean supplementSet = false;

    public WoodworkingRecipeBuilder(RecipeBookCategory recipeCategory, class_1865<?> recipeSerializer, class_1935 itemLike, int resultCount) {
        this.category = recipeCategory;
        this.type = recipeSerializer;
        this.result = itemLike.method_8389();
        this.resultCount = resultCount;
    }

    public static WoodworkingRecipeBuilder woodworking(RecipeBookCategory recipeCategory, class_1935 itemLike, int resultCount) {
        return new WoodworkingRecipeBuilder(recipeCategory, ModRecipeSerializer.WOODWORKING, itemLike, resultCount);
    }

    public WoodworkingRecipeBuilder ingredient(class_6862<class_1792> tagKey) {
        return this.ingredient(class_1856.method_8106(tagKey), 1);
    }

    public WoodworkingRecipeBuilder ingredient(class_6862<class_1792> tagKey, int i) {
        return this.ingredient(class_1856.method_8106(tagKey), i);
    }

    public WoodworkingRecipeBuilder ingredient(class_1935 itemLike) {
        return this.ingredient(class_1856.method_8091((class_1935[])new class_1935[]{itemLike}), 1);
    }

    public WoodworkingRecipeBuilder ingredient(class_1935 itemLike, int i) {
        return this.ingredient(class_1856.method_8091((class_1935[])new class_1935[]{itemLike}), i);
    }

    public WoodworkingRecipeBuilder ingredient(class_1856 ingredient) {
        return this.ingredient(ingredient, 1);
    }

    public WoodworkingRecipeBuilder ingredient(class_1856 ingredient, int i) {
        this.ingredient = ingredient;
        this.ingredientCount = i;
        this.ingredientSet = true;
        return this;
    }

    public WoodworkingRecipeBuilder supplement(class_6862<class_1792> tagKey) {
        return this.supplement(class_1856.method_8106(tagKey), 1);
    }

    public WoodworkingRecipeBuilder supplement(class_6862<class_1792> tagKey, int i) {
        return this.supplement(class_1856.method_8106(tagKey), i);
    }

    public WoodworkingRecipeBuilder supplement(class_1935 itemLike) {
        return this.supplement(class_1856.method_8091((class_1935[])new class_1935[]{itemLike}), 1);
    }

    public WoodworkingRecipeBuilder supplement(class_1935 itemLike, int i) {
        return this.supplement(class_1856.method_8091((class_1935[])new class_1935[]{itemLike}), i);
    }

    public WoodworkingRecipeBuilder supplement(class_1856 ingredient) {
        return this.supplement(ingredient, 1);
    }

    public WoodworkingRecipeBuilder supplement(class_1856 ingredient, int i) {
        this.supplement = ingredient;
        this.supplementCount = i;
        this.supplementSet = true;
        return this;
    }

    public WoodworkingRecipeBuilder dye(@Nullable class_1935 itemLike, int count) {
        if (itemLike != null) {
            this.dye = class_1856.method_8091((class_1935[])new class_1935[]{itemLike});
            this.dyeCount = count;
        }
        return this;
    }

    public WoodworkingRecipeBuilder unlockedBy(String string, class_184 criterionTriggerInstance) {
        this.advancement.method_709(string, criterionTriggerInstance);
        return this;
    }

    public WoodworkingRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public class_1792 method_36441() {
        return this.result;
    }

    public void saveWithNamespace(Consumer<class_2444> consumer, class_2960 resourceLocation) {
        class_2960 resourceLocation2 = RecipeUtils.appendToResourceLocation(resourceLocation);
        this.ensureValid(resourceLocation2);
        this.ensureRequiredFields();
        this.advancement.method_708(field_39377).method_709("has_the_recipe", (class_184)class_2119.method_27847((class_2960)resourceLocation2)).method_703(class_170.class_171.method_753((class_2960)resourceLocation2)).method_704(class_193.field_1257);
        consumer.accept(new Result(resourceLocation2.method_45138("carpentry/"), this.type, this.group == null ? "" : this.group, this.ingredient, this.ingredientCount, this.supplement, this.supplementCount, this.dye, this.dyeCount, this.result, this.resultCount, this.advancement, resourceLocation2.method_45138("recipes/" + this.category.getFolderName() + "/")));
    }

    public void method_17972(Consumer<class_2444> consumer, class_2960 resourceLocation) {
        this.saveWithNamespace(consumer, resourceLocation);
    }

    private void ensureValid(class_2960 resourceLocation) {
        if (this.advancement.method_710().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    private void ensureRequiredFields() {
        if (!this.ingredientSet || !this.supplementSet) {
            throw new IllegalStateException("Woodworking recipe must have an 'ingredient' and 'supplement' fields.");
        }
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final String group;
        private final class_1856 ingredient;
        private final int ingredientCount;
        private final class_1856 supplement;
        private final int supplementCount;
        private final class_1856 dye;
        private final int dyeCount;
        private final class_1792 result;
        private final int resultCount;
        private final class_161.class_162 advancement;
        private final class_2960 advancementId;
        private final class_1865<?> type;

        public Result(class_2960 resourceLocation, class_1865<?> recipeSerializer, String group, class_1856 ingredient, int ingredientCount, class_1856 supplement, int supplementCount, class_1856 dye, int dyeCount, class_1792 item, int resultCount, class_161.class_162 builder, class_2960 advancementId) {
            this.id = resourceLocation;
            this.type = recipeSerializer;
            this.group = group;
            this.ingredient = ingredient;
            this.ingredientCount = ingredientCount;
            this.supplement = supplement;
            this.supplementCount = supplementCount;
            this.dye = dye;
            this.dyeCount = dyeCount;
            this.result = item;
            this.resultCount = resultCount;
            this.advancement = builder;
            this.advancementId = advancementId;
        }

        public void method_10416(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            JsonObject ingredientJson = this.ingredient.method_8089().getAsJsonObject();
            ingredientJson.addProperty("count", (Number)this.ingredientCount);
            jsonObject.add("ingredient", (JsonElement)ingredientJson);
            JsonObject supplementJson = this.supplement.method_8089().getAsJsonObject();
            supplementJson.addProperty("count", (Number)this.supplementCount);
            jsonObject.add("supplement", (JsonElement)supplementJson);
            if (this.dye != null && !this.dye.method_8103()) {
                JsonObject dyeJson = this.dye.method_8089().getAsJsonObject();
                dyeJson.addProperty("count", (Number)this.dyeCount);
                jsonObject.add("dye", (JsonElement)dyeJson);
            }
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", class_7923.field_41178.method_10221((Object)this.result).toString());
            resultJson.addProperty("count", (Number)this.resultCount);
            jsonObject.add("result", (JsonElement)resultJson);
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return this.type;
        }

        @Nullable
        public JsonObject method_10415() {
            return this.advancement.method_698();
        }

        @Nullable
        public class_2960 method_10418() {
            return this.advancementId;
        }
    }
}

