/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.data.models.model;

import com.conquest.hearthfire.data.models.model.ModelLocationUtil;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

public class PrefixedModelTemplate {
    private final Optional<class_2960> model;
    private final Set<class_4945> requiredSlots;
    private final Optional<String> prefix;

    public PrefixedModelTemplate(Optional<class_2960> optional, Optional<String> optional2, class_4945 ... textureSlots) {
        this.model = optional;
        this.prefix = optional2;
        this.requiredSlots = ImmutableSet.copyOf((Object[])textureSlots);
    }

    public class_2960 create(class_2248 block, class_4944 textureMapping, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer) {
        return this.create(ModelLocationUtil.getModelLocationWithPrefix(block, this.prefix.orElse("")), textureMapping, biConsumer);
    }

    public class_2960 create(class_2960 resourceLocation, class_4944 textureMapping, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer) {
        return this.create(resourceLocation, textureMapping, biConsumer, this::createBaseTemplate);
    }

    public class_2960 create(class_2960 resourceLocation, class_4944 textureMapping, BiConsumer<class_2960, Supplier<JsonElement>> biConsumer, JsonFactory jsonFactory) {
        Map<class_4945, class_2960> map = this.createMap(textureMapping);
        biConsumer.accept(resourceLocation, () -> jsonFactory.create(resourceLocation, map));
        return resourceLocation;
    }

    public JsonObject createBaseTemplate(class_2960 resourceLocation2, Map<class_4945, class_2960> map) {
        JsonObject jsonObject = new JsonObject();
        this.model.ifPresent(resourceLocation -> jsonObject.addProperty("parent", resourceLocation.toString()));
        if (!map.isEmpty()) {
            JsonObject jsonObject2 = new JsonObject();
            map.forEach((textureSlot, resourceLocation) -> jsonObject2.addProperty(textureSlot.method_25912(), resourceLocation.toString()));
            jsonObject.add("textures", (JsonElement)jsonObject2);
        }
        return jsonObject;
    }

    public final Map<class_4945, class_2960> createMap(class_4944 textureMapping) {
        return (Map)Streams.concat((Stream[])new Stream[]{this.requiredSlots.stream(), textureMapping.method_25861()}).collect(ImmutableMap.toImmutableMap(Function.identity(), arg_0 -> ((class_4944)textureMapping).method_25867(arg_0)));
    }

    public static interface JsonFactory {
        public JsonObject create(class_2960 var1, Map<class_4945, class_2960> var2);
    }
}

