/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.hearthfire.data.models;

import com.conquest.hearthfire.data.models.BlockStateProvider;
import com.conquest.hearthfire.data.models.model.ModelLocationUtil;
import com.conquest.hearthfire.data.models.model.ModelTemplates;
import com.conquest.hearthfire.data.models.model.TextureMappings;
import com.conquest.hearthfire.data.models.model.TextureSlots;
import com.conquest.hearthfire.data.models.model.TexturedModel;
import com.conquest.hearthfire.world.level.block.ModBlocks;
import com.conquest.hearthfire.world.level.block.state.properties.ModBlockStateProperties;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockModelProvider {
    public static void createSimpleBlockWithFlatItem(class_4910 generator, class_2248 block, String string) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation)));
        generator.method_25556(block, string);
    }

    public static void createSimpleFlatItemModel(class_4910 generator, class_2248 block, String string) {
        class_1792 item = block.method_8389();
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25895((class_2960)TextureMappings.getSimpleBlockTextureGroup(block, string)), generator.field_22831);
    }

    public static void createSimpleFlatItemModel(class_4910 generator, class_2248 block, String parent, String path, String suffix) {
        class_1792 item = block.method_8389();
        class_4943.field_22938.method_25852(class_4941.method_25840((class_1792)item), class_4944.method_25895((class_2960)TextureMappings.getBlockTextureGroup(block, parent, path, suffix)), generator.field_22831);
    }

    public static void createCrossBlock(class_4910 generator, class_2248 block) {
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, TextureMappings.getSimpleBlockTextureGroup(block, "hanging_food"));
        class_2960 resourceLocation = ModelTemplates.TEMPLATE_CROSS_BLOCK.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)resourceLocation));
        BlockModelProvider.createSimpleFlatItemModel(generator, block, "hanging_food");
    }

    public static void createDoubleCrossBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_7923.field_41175.method_10221((Object)block);
        String path = resourceLocation.method_12832();
        class_2960 top = TextureMappings.getBlockTextureGroup(block, "hanging_food", path, "top");
        class_2960 bottom = TextureMappings.getBlockTextureGroup(block, "hanging_food", path, "bottom");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23014, bottom);
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_DOUBLE_CROSS_BLOCK.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)resourceLocation1));
        BlockModelProvider.createSimpleFlatItemModel(generator, block, "hanging_food", path, "bottom");
    }

    public static void createNonTemplateModelBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)resourceLocation));
    }

    public static void createNonTemplateModelBlockWithoutItem(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)resourceLocation));
        generator.method_25540(block);
    }

    public static void createAirLikeBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = ModelLocationUtil.decorateBlockModelLocation("empty_block");
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)resourceLocation));
        generator.method_25540(block);
    }

    public static void createTwoVariantBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_alt");
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])new class_4935[]{class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2)}));
        generator.method_25540(block);
    }

    public static void createHorizontalDirectionalBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation)).method_25775(class_4910.method_25599()));
        generator.method_25623(block, resourceLocation);
    }

    private static void createFurniture(class_4910 generator, class_2248 block, class_2960 single, class_2960 bottom, class_2960 middle, class_2960 top) {
        generator.field_22830.accept(BlockStateProvider.createCabinet(block, single, bottom, middle, top));
        generator.method_25623(block, single);
    }

    public static void createFurniture(class_4910 generator, class_2248 block, class_2960 resourceLocation) {
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation)).method_25775(class_4910.method_25599()));
        generator.method_25623(block, resourceLocation);
    }

    public static void createSimpleFurniture(class_4910 generator, class_2248 block, class_2960 resourceLocation) {
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)resourceLocation));
        generator.method_25623(block, resourceLocation);
    }

    public static void createCabinet(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960[] textures = TextureMappings.getRusticFurnitureTextures(block, resourceLocation);
        class_4944[] textureMappings = TextureMappings.createRusticFurnitureTextureMappings(textures);
        class_2960[] resourceLocations = TexturedModel.createCabinetModels(generator, block, textureMappings);
        BlockModelProvider.createFurniture(generator, block, resourceLocations[0], resourceLocations[1], resourceLocations[2], resourceLocations[3]);
    }

    public static void createCabinet(class_4910 generator, class_2248 block) {
        class_2960 bottom = class_4941.method_25843((class_2248)block, (String)"_bottom");
        class_2960 middle = class_4941.method_25843((class_2248)block, (String)"_middle");
        class_2960 top = class_4941.method_25843((class_2248)block, (String)"_top");
        generator.field_22830.accept(BlockStateProvider.createCabinet(block, top, bottom, middle, top));
        generator.method_25623(block, top);
    }

    public static void createCloset(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960[] textures = TextureMappings.getRusticFurnitureTextures(block, resourceLocation);
        class_4944[] textureMappings = TextureMappings.createRusticFurnitureTextureMappings(textures);
        class_2960[] resourceLocations = TexturedModel.createClosetModels(generator, block, textureMappings);
        BlockModelProvider.createFurniture(generator, block, resourceLocations[0], resourceLocations[1], resourceLocations[2], resourceLocations[3]);
    }

    public static void createCupboard(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960[] textures = TextureMappings.getRusticFurnitureTextures(block, resourceLocation);
        class_4944[] textureMappings = TextureMappings.createRusticFurnitureTextureMappings(textures);
        class_2960[] resourceLocations = TexturedModel.createCupboardModels(generator, block, textureMappings);
        BlockModelProvider.createFurniture(generator, block, resourceLocations[0], resourceLocations[1], resourceLocations[2], resourceLocations[3]);
    }

    public static void createBookcase(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960[] textures = TextureMappings.getRusticFurnitureTextures(block, resourceLocation);
        class_4944[] textureMappings = TextureMappings.createRusticFurnitureTextureMappings(textures);
        class_2960[] resourceLocations = TexturedModel.createBookcaseModels(generator, block, textureMappings);
        BlockModelProvider.createFurniture(generator, block, resourceLocations[0], resourceLocations[1], resourceLocations[2], resourceLocations[3]);
    }

    public static void createDresser(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960[] textures = TextureMappings.getRusticFurnitureTextures(block, resourceLocation);
        class_4944[] textureMappings = TextureMappings.createRusticFurnitureTextureMappings(textures);
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_DRESSER.method_25846(block, textureMappings[16], generator.field_22831);
        BlockModelProvider.createFurniture(generator, block, resourceLocation1);
    }

    public static void createDrawer(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960[] textures = TextureMappings.getRusticFurnitureTextures(block, resourceLocation);
        class_4944[] textureMappings = TextureMappings.createRusticFurnitureTextureMappings(textures);
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_DRAWER.method_25846(block, textureMappings[17], generator.field_22831);
        BlockModelProvider.createFurniture(generator, block, resourceLocation1);
    }

    public static void createEndTable(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960[] textures = TextureMappings.getRusticFurnitureTextures(block, resourceLocation);
        class_4944[] textureMappings = TextureMappings.createRusticFurnitureTextureMappings(textures);
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_END_TABLE.method_25846(block, textureMappings[18], generator.field_22831);
        BlockModelProvider.createFurniture(generator, block, resourceLocation1);
    }

    public static void createSideTable(class_4910 generator, class_2248 block, String resourceLocation) {
        class_2960[] textures = TextureMappings.getRusticFurnitureTextures(block, resourceLocation);
        class_4944[] textureMappings = TextureMappings.createRusticFurnitureTextureMappings(textures);
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_SIDE_TABLE.method_25846(block, textureMappings[19], generator.field_22831);
        BlockModelProvider.createSimpleFurniture(generator, block, resourceLocation1);
    }

    public static void createWardrobe(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_7923.field_41175.method_10221((Object)block);
        String path = resourceLocation.method_12832();
        class_2960 top = TextureMappings.getBlockTexture(block, path, "top");
        class_2960 bottom = TextureMappings.getBlockTexture(block, path, "bottom");
        class_2960 side1 = TextureMappings.getBlockTexture(block, path, "lower_side");
        class_2960 side2 = TextureMappings.getBlockTexture(block, path, "upper_side");
        class_2960 front1 = TextureMappings.getBlockTexture(block, path, "lower_left");
        class_2960 front2 = TextureMappings.getBlockTexture(block, path, "upper_left");
        class_2960 front3 = TextureMappings.getBlockTexture(block, path, "lower_right");
        class_2960 front4 = TextureMappings.getBlockTexture(block, path, "upper_right");
        class_2960 back1 = TextureMappings.getBlockTexture(block, path, "lower_back");
        class_2960 back2 = TextureMappings.getBlockTexture(block, path, "upper_back");
        class_4944 textureMapping1 = TextureMappings.topBottomSideFrontBack(top, bottom, side1, front1, back1);
        class_4944 textureMapping2 = TextureMappings.topBottomSideFrontBack(top, bottom, side1, front3, back1);
        class_4944 textureMapping3 = TextureMappings.topSideFrontBack(top, side2, front2, back2);
        class_4944 textureMapping4 = TextureMappings.topSideFrontBack(top, side2, front4, back2);
        class_4944 textureMapping5 = TextureMappings.topBottomSidesFrontsBacks(top, bottom, side1, side2, front1, front2, back1, back2);
        class_2960 lowerLeft = ModelTemplates.TEMPLATE_WARDROBE_LOWER_LEFT.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 lowerRight = ModelTemplates.TEMPLATE_WARDROBE_LOWER_RIGHT.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 upperLeft = ModelTemplates.TEMPLATE_WARDROBE_UPPER_LEFT.method_25846(block, textureMapping3, generator.field_22831);
        class_2960 upperRight = ModelTemplates.TEMPLATE_WARDROBE_UPPER_RIGHT.method_25846(block, textureMapping4, generator.field_22831);
        class_2960 inventory = ModelTemplates.TEMPLATE_WARDROBE_INVENTORY.method_25846(block, textureMapping5, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createWardrobe(block, lowerLeft, upperLeft, lowerRight, upperRight));
        generator.method_25623(block, inventory);
    }

    private static void createTallChair(class_4910 generator, class_2248 block, class_2960 lower, class_2960 upper, class_2960 inventory) {
        generator.field_22830.accept(BlockStateProvider.createTallChair(block, lower, upper));
        generator.method_25623(block, inventory);
    }

    public static void createGothicArmChair(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_7923.field_41175.method_10221((Object)block);
        String path = resourceLocation.method_12832();
        String parent = "gothic_arm_chair";
        class_2960 top = TextureMappings.getBlockTextureGroup(block, parent, path, "top");
        class_2960 bottom = TextureMappings.getBlockTextureGroup(block, parent, path, "bottom");
        class_2960 side = TextureMappings.getBlockTextureGroup(block, parent, path, "side");
        class_2960 front = TextureMappings.getBlockTextureGroup(block, parent, path, "front");
        class_2960 back = TextureMappings.getBlockTextureGroup(block, parent, path, "back");
        class_4944 textureMapping1 = TextureMappings.topBottomSideFront(top, bottom, side, front);
        class_4944 textureMapping2 = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_4944 textureMapping3 = TextureMappings.topBottomSideFrontBack(top, bottom, side, front, back);
        class_2960 lower = ModelTemplates.TEMPLATE_ARM_CHAIR_LOWER.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 upper = ModelTemplates.TEMPLATE_ARM_CHAIR_UPPER.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 inventory = ModelTemplates.TEMPLATE_ARM_CHAIR_INVENTORY.method_25846(block, textureMapping3, generator.field_22831);
        BlockModelProvider.createTallChair(generator, block, lower, upper, inventory);
    }

    public static void createRusticSideChair(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_7923.field_41175.method_10221((Object)block);
        String path = resourceLocation.method_12832();
        String parent = "rustic_side_chair";
        class_2960 top = TextureMappings.getBlockTextureGroup(block, parent, path, "top");
        class_2960 bottom = TextureMappings.getBlockTextureGroup(block, parent, path, "bottom");
        class_2960 side = TextureMappings.getBlockTextureGroup(block, parent, path, "side");
        class_2960 front = TextureMappings.getBlockTextureGroup(block, parent, path, "front");
        class_4944 textureMapping1 = TextureMappings.topBottomSideFront(top, bottom, side, front);
        class_4944 textureMapping2 = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front);
        class_4944 textureMapping3 = TextureMappings.topBottomSideFront(top, bottom, side, front);
        class_2960 lower = ModelTemplates.TEMPLATE_SIDE_CHAIR_LOWER.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 upper = ModelTemplates.TEMPLATE_SIDE_CHAIR_UPPER.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 inventory = ModelTemplates.TEMPLATE_SIDE_CHAIR_INVENTORY.method_25846(block, textureMapping3, generator.field_22831);
        BlockModelProvider.createTallChair(generator, block, lower, upper, inventory);
    }

    public static void createRusticThroneChair(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_7923.field_41175.method_10221((Object)block);
        String path = resourceLocation.method_12832();
        String parent = "rustic_throne_chair";
        class_2960 top = TextureMappings.getBlockTextureGroup(block, parent, path, "top");
        class_2960 bottom = TextureMappings.getBlockTextureGroup(block, parent, path, "bottom");
        class_2960 side = TextureMappings.getBlockTextureGroup(block, parent, path, "side");
        class_2960 front = TextureMappings.getBlockTextureGroup(block, parent, path, "front");
        class_2960 back = TextureMappings.getBlockTextureGroup(block, parent, path, "back");
        class_4944 textureMapping1 = TextureMappings.topBottomSideFrontBack(top, bottom, side, front, back);
        class_4944 textureMapping2 = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23016, front).method_25868(class_4945.field_23017, back);
        class_4944 textureMapping3 = TextureMappings.topBottomSideFrontBack(top, bottom, side, front, back);
        class_2960 lower = ModelTemplates.TEMPLATE_THRONE_CHAIR_LOWER.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 upper = ModelTemplates.TEMPLATE_THRONE_CHAIR_UPPER.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 inventory = ModelTemplates.TEMPLATE_THRONE_CHAIR_INVENTORY.method_25846(block, textureMapping3, generator.field_22831);
        BlockModelProvider.createTallChair(generator, block, lower, upper, inventory);
    }

    public static void createFancyChair(class_4910 generator, class_2248 block) {
        class_2960 lower = class_4941.method_25843((class_2248)block, (String)"_lower");
        class_2960 upper = class_4941.method_25843((class_2248)block, (String)"_upper");
        class_2960 inventory = class_4941.method_25843((class_2248)block, (String)"_inventory");
        BlockModelProvider.createTallChair(generator, block, lower, upper, inventory);
    }

    public static void createSofa(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_7923.field_41175.method_10221((Object)block);
        String path = resourceLocation.method_12832();
        String prefix = "rustic_sofa";
        class_2960 top1 = TextureMappings.getBlockTextureGroup(block, path, prefix, "top1");
        class_2960 top2 = TextureMappings.getBlockTextureGroup(block, path, prefix, "top2");
        class_2960 bottom = TextureMappings.getBlockTextureGroup(block, path, prefix, "bottom");
        class_2960 side1 = TextureMappings.getBlockTextureGroup(block, path, prefix, "side1");
        class_2960 side2 = TextureMappings.getBlockTextureGroup(block, path, prefix, "side2");
        class_2960 front = TextureMappings.getBlockTextureGroup(block, path, prefix, "front");
        class_2960 back = TextureMappings.getBlockTextureGroup(block, path, prefix, "back");
        class_4944 textureMapping1 = TextureMappings.topBottomSideFrontBack(top1, bottom, side1, front, back);
        class_4944 textureMapping2 = TextureMappings.sofa(top1, top2, bottom, side1, side2, front, back);
        class_4944 textureMapping3 = TextureMappings.sofa(top2, bottom, side1, side2, front, back);
        class_4944 textureMapping4 = TextureMappings.sofa(top1, top2, bottom, side1, side2, front, back);
        class_2960 single = ModelTemplates.TEMPLATE_SOFA.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 left = ModelTemplates.TEMPLATE_SOFA_LEFT.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 middle = ModelTemplates.TEMPLATE_SOFA_MIDDLE.method_25846(block, textureMapping3, generator.field_22831);
        class_2960 right = ModelTemplates.TEMPLATE_SOFA_RIGHT.method_25846(block, textureMapping4, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createSofa(block, single, left, middle, right));
        generator.method_25623(block, single);
    }

    public static void createDaybed(class_4910 generator, class_2248 block) {
        class_2960 top1 = TextureMappings.getBlockTexture(block, "_middle");
        class_2960 top2 = TextureMappings.getBlockTexture(block, "_left");
        class_2960 top3 = TextureMappings.getBlockTexture(block, "_right");
        class_2960 bottom = TextureMappings.getBlockTexture(block, "_bottom");
        class_2960 side = TextureMappings.getBlockTexture(block, "_side");
        class_2960 back = TextureMappings.getBlockTexture(block, "_back");
        class_2960 legs = TextureMappings.getBlockTexture(block, "_legs");
        class_2960 pillow = TextureMappings.getBlockTexture(block, "_pillow");
        class_4944 textureMapping1 = TextureMappings.daybed(top1, bottom, side, back, legs);
        class_4944 textureMapping2 = TextureMappings.daybed(top2, bottom, side, back, legs, pillow);
        class_4944 textureMapping3 = TextureMappings.daybed(top1, bottom, side, back, legs);
        class_4944 textureMapping4 = TextureMappings.daybed(top3, bottom, side, back, legs, pillow);
        class_2960 single = ModelTemplates.TEMPLATE_DAYBED.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 left = ModelTemplates.TEMPLATE_DAYBED_LEFT.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 middle = ModelTemplates.TEMPLATE_DAYBED_MIDDLE.method_25846(block, textureMapping3, generator.field_22831);
        class_2960 right = ModelTemplates.TEMPLATE_DAYBED_RIGHT.method_25846(block, textureMapping4, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createSofa(block, single, left, middle, right));
        generator.method_25623(block, single);
    }

    public static void createBench(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_7923.field_41175.method_10221((Object)block);
        String path = resourceLocation.method_12832();
        String prefix = "rustic_bench";
        class_2960 top = TextureMappings.getBlockTextureGroup(block, path, prefix, "top");
        class_2960 side = TextureMappings.getBlockTextureGroup(block, path, prefix, "side");
        class_2960 front1 = TextureMappings.getBlockTextureGroup(block, path, prefix, "front1");
        class_2960 front2 = TextureMappings.getBlockTextureGroup(block, path, prefix, "front2");
        class_2960 back = TextureMappings.getBlockTextureGroup(block, path, prefix, "back");
        class_4944 textureMapping1 = new class_4944().method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23017, back);
        class_4944 textureMapping2 = TextureMappings.topSideFrontBack(top, side, front1, back);
        class_4944 textureMapping3 = TextureMappings.topSideFrontBack(top, side, front2, back);
        class_4944 textureMapping4 = TextureMappings.topSideFrontBack(top, side, front1, back);
        class_2960 single = ModelTemplates.TEMPLATE_RUSTIC_BENCH.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 left = ModelTemplates.TEMPLATE_RUSTIC_BENCH_LEFT.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 middle = ModelTemplates.TEMPLATE_RUSTIC_BENCH_MIDDLE.method_25846(block, textureMapping3, generator.field_22831);
        class_2960 right = ModelTemplates.TEMPLATE_RUSTIC_BENCH_RIGHT.method_25846(block, textureMapping4, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createSofa(block, single, left, middle, right));
        generator.method_25623(block, single);
    }

    public static void createHorizontalConnectingBlock(class_4910 generator, class_2248 block) {
        class_2960 single = class_4941.method_25842((class_2248)block);
        class_2960 left = class_4941.method_25843((class_2248)block, (String)"_left");
        class_2960 middle = class_4941.method_25843((class_2248)block, (String)"_middle");
        class_2960 right = class_4941.method_25843((class_2248)block, (String)"_right");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createHorizontalConnectingDispatch(single, left, middle, right)));
        generator.method_25623(block, single);
    }

    public static void createCarpentryToolRack(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"1");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"2");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"3");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createVariantModelDispatch(resourceLocation1, resourceLocation2, resourceLocation3)));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createTrestle(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = ModelLocationUtil.getModelLocationWithPrefix(block, "tilted_");
        generator.field_22830.accept(BlockStateProvider.createTrestle(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createTimbers(class_4910 generator, class_2248 block) {
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, TextureMappings.getSimpleBlockTextureGroup(block, "timbers"));
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_TIMBERS_ONE_STACK.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.TEMPLATE_TIMBERS_TWO_STACKS.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation3 = ModelTemplates.TEMPLATE_TIMBERS_THREE_STACKS.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation4 = ModelTemplates.TEMPLATE_TIMBERS_FOUR_STACKS.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation5 = ModelTemplates.TEMPLATE_TIMBERS_FIVE_STACKS.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createFiveStackModelDispatch(resourceLocation1, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5)));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createLogBench(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_end");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_middle");
        class_2960 inventory = class_4941.method_25843((class_2248)block, (String)"_inventory");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createHorizontalConnectingDispatch(resourceLocation1, resourceLocation1, resourceLocation2, resourceLocation1)));
        generator.method_25623(block, inventory);
    }

    public static void createTopBottomAttachedBlock(class_4910 generator, class_2248 block) {
        class_2960 bottom = class_4941.method_25843((class_2248)block, (String)"_bottom");
        class_2960 top = class_4941.method_25843((class_2248)block, (String)"_top");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createAttachTypeModelDispatch(bottom, top)));
        generator.method_25623(block, top);
    }

    public static void createFiveWayDirectionalBlock(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation)).method_25775(BlockStateProvider.createFiveWayDirectionalDispatch()));
        generator.method_25623(block, resourceLocation);
    }

    public static void createWheel(class_4910 generator, class_2248 block, class_2248 parent) {
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"1");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"2");
        class_2960 resourceLocation3 = class_4941.method_25842((class_2248)parent);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createBooleanModelDispatch(ModBlockStateProperties.TOGGLE, resourceLocation1, resourceLocation2)));
        generator.method_25623(block, resourceLocation3);
    }

    public static void createKeg(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_horizontal");
        generator.field_22830.accept(BlockStateProvider.createKeg(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createBarrel(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = ModelLocationUtil.getModelLocationWithPrefix(block, "empty_");
        class_2960 resourceLocation2 = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(BlockStateProvider.createBarrel(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation2);
    }

    public static void createBarrel(class_4910 generator) {
        class_2248 block = ModBlocks.BROKEN_BARREL;
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_down");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_up");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"_horizontal");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createFacingDispatch(resourceLocation1, resourceLocation2, resourceLocation3)));
        generator.method_25623(block, resourceLocation2);
    }

    public static void createTallBarrel(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_lower");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_upper");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"_inventory");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHalfModelDispatch(resourceLocation1, resourceLocation2)));
        generator.method_25623(block, resourceLocation3);
    }

    public static void createSmallBarrel(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_one_barrel");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_two_barrels");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"_three_barrels");
        class_2960 resourceLocation4 = class_4941.method_25843((class_2248)block, (String)"_four_barrels");
        class_2960 resourceLocation5 = class_4941.method_25843((class_2248)block, (String)"_four_barrels_alt");
        generator.field_22830.accept(BlockStateProvider.createBarrel(block, resourceLocation1, resourceLocation2, resourceLocation3, resourceLocation4, resourceLocation5));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createButterChurn(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_inventory");
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1)).method_25775(class_4910.method_25599()));
        generator.method_25623(block, resourceLocation2);
    }

    public static void createEmptyCrate(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = ModelLocationUtil.getModelLocationWithPrefix(block, "double_");
        generator.field_22830.accept(BlockStateProvider.createCrate(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createCrate(class_4910 generator, class_2248 block) {
        class_2960 path = class_7923.field_41175.method_10221((Object)block);
        String parent = "wooden_crate";
        class_2960 top = path.method_45134(string -> "block/" + parent + "/" + path.method_12832());
        class_2960 bottom = TextureMappings.getBlockTextureGroup(block, parent, parent, "bottom");
        class_2960 side = TextureMappings.getBlockTextureGroup(block, parent, parent, "side");
        class_2960 front = TextureMappings.getBlockTextureGroup(block, parent, parent, "front");
        class_4944 textureMapping1 = TextureMappings.topBottomSideFront(top, bottom, side, front);
        class_4944 textureMapping2 = TextureMappings.topBottomSideFront(top, bottom, side, front);
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_WOODEN_CRATE.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.TEMPLATE_WOODEN_CRATE_DOUBLE.create(block, textureMapping2, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createCrate(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createEmptyLargeCrate(class_4910 generator) {
        class_2248 block = ModBlocks.EMPTY_LARGE_CRATE;
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])BlockStateProvider.createRotatedVariants(block)));
        generator.method_25623(block, class_4941.method_25842((class_2248)block));
    }

    public static void createLargeCrate(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_4941.method_25842((class_2248)block);
        generator.field_22830.accept(class_4925.method_25771((class_2248)block, (class_4935[])class_4910.method_25584((class_2960)resourceLocation)));
        generator.method_25623(block, resourceLocation);
    }

    public static void createBurlapSack(class_4910 generator) {
        class_2248 block = ModBlocks.BURLAP_SACK;
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_one_sack");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_horizontal_one_sack");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"_two_sacks");
        class_2960 resourceLocation4 = class_4941.method_25843((class_2248)block, (String)"_horizontal_two_sacks");
        generator.field_22830.accept(BlockStateProvider.createBurlapSack(block, resourceLocation1, resourceLocation2, resourceLocation3, resourceLocation4));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createBurlapSack(class_4910 generator, class_2248 block) {
        class_2960 path = class_7923.field_41175.method_10221((Object)block);
        String parent = "burlap_sack";
        class_2960 top = path.method_45134(string -> "block/" + parent + "/" + path.method_12832());
        class_2960 bottom = TextureMappings.getBlockTextureGroup(block, parent, parent, "bottom");
        class_2960 side = TextureMappings.getBlockTextureGroup(block, parent, parent, "side");
        class_4944 textureMapping = TextureMappings.topBottomSide(top, bottom, side);
        class_2960 resourceLocation = ModelTemplates.TEMPLATE_BURLAP_SACK.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation)).method_25775(class_4910.method_25599()));
        generator.method_25623(block, resourceLocation);
    }

    public static void createBasket(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = ModelTemplates.TEMPLATE_WICKER_BASKET.method_25846(block, TextureMappings.basket(block, ModBlocks.WICKER_BASKET), generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)resourceLocation));
        generator.method_25623(block, resourceLocation);
    }

    public static void createWashboard(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25842((class_2248)block);
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_toggle");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775(BlockStateProvider.createBooleanModelDispatch(ModBlockStateProperties.TOGGLE, resourceLocation2, resourceLocation1)));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createBookPile(class_4910 generator) {
        class_2248 block = ModBlocks.PILE_OF_BOOKS;
        class_4926 propertyDispatch = class_4926.method_25783((class_2769)ModBlockStateProperties.STACK_8).method_25795(integer -> class_4935.method_25824().method_25828(class_4936.field_22887, (Object)class_4941.method_25843((class_2248)block, (String)("_" + integer))));
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(class_4910.method_25599()).method_25775(propertyDispatch));
        generator.method_25623(block, class_4941.method_25843((class_2248)block, (String)"_1"));
    }

    public static void createHangingRug(class_4910 generator, class_2248 block) {
        String path = class_7923.field_41175.method_10221((Object)block).method_12832();
        String parent = "hanging_rug";
        class_2960 resourceLocation1 = TextureMappings.getBlockTextureGroup(block, parent, path, "lower");
        class_2960 resourceLocation2 = TextureMappings.getBlockTextureGroup(block, parent, path, "upper");
        class_2960 resourceLocation3 = TextureMappings.getBlockTextureGroup(block, parent, path, "edge");
        class_2960 resourceLocation4 = class_7923.field_41175.method_10221((Object)ModBlocks.TREADLE_LOOM).method_45134(string -> "block/" + string + "/treadle_loom_base");
        class_4944 textureMapping1 = new class_4944().method_25868(class_4945.field_23011, resourceLocation1).method_25868(class_4945.field_23032, resourceLocation3);
        class_4944 textureMapping2 = new class_4944().method_25868(class_4945.field_23011, resourceLocation2).method_25868(TextureSlots.RACK, resourceLocation4);
        class_2960 lower = ModelTemplates.TEMPLATE_HANGING_RUG_LOWER.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 lowerLeft = ModelTemplates.TEMPLATE_HANGING_RUG_LOWER_LEFT.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 lowerMiddle = ModelTemplates.TEMPLATE_HANGING_RUG_LOWER_MIDDLE.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 lowerRight = ModelTemplates.TEMPLATE_HANGING_RUG_LOWER_RIGHT.method_25846(block, textureMapping1, generator.field_22831);
        class_2960 upper = ModelTemplates.TEMPLATE_HANGING_RUG_UPPER.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 upperLeft = ModelTemplates.TEMPLATE_HANGING_RUG_UPPER_LEFT.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 upperMiddle = ModelTemplates.TEMPLATE_HANGING_RUG_UPPER_MIDDLE.method_25846(block, textureMapping2, generator.field_22831);
        class_2960 upperRight = ModelTemplates.TEMPLATE_HANGING_RUG_UPPER_RIGHT.method_25846(block, textureMapping2, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHangingRug(block, lower, lowerLeft, lowerMiddle, lowerRight, upper, upperLeft, upperMiddle, upperRight));
        generator.method_25623(block, upper);
    }

    public static void createStoneBench(class_4910 generator, class_2248 block) {
        class_2960 side = TextureMappings.getBlockTexture(block, "_side");
        class_2960 top = TextureMappings.getBlockTexture(block, "_top");
        class_2960 edge = TextureMappings.getBlockTexture(block, "_edge");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23015, top).method_25868(class_4945.field_23032, edge);
        class_2960 single = ModelTemplates.TEMPLATE_STONE_BENCH_SINGLE.method_25846(block, textureMapping, generator.field_22831);
        class_2960 left = ModelTemplates.TEMPLATE_STONE_BENCH_LEFT.method_25846(block, textureMapping, generator.field_22831);
        class_2960 middle = ModelTemplates.TEMPLATE_STONE_BENCH_MIDDLE.method_25846(block, textureMapping, generator.field_22831);
        class_2960 right = ModelTemplates.TEMPLATE_STONE_BENCH_RIGHT.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createSofa(block, single, left, middle, right));
        generator.method_25623(block, single);
    }

    public static void createSlateBench(class_4910 generator, class_2248 block) {
        class_2960 side = TextureMappings.getBlockTexture(block, "_side");
        class_2960 top = TextureMappings.getBlockTexture(block, "_top");
        class_2960 edge = TextureMappings.getBlockTexture(block, "_corner");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23018, side).method_25868(class_4945.field_23013, top).method_25868(class_4945.field_23032, edge);
        class_2960 base = ModelTemplates.TEMPLATE_SLATE_BENCH.method_25846(block, textureMapping, generator.field_22831);
        class_2960 corner = ModelTemplates.TEMPLATE_SLATE_BENCH_CORNER.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createSlateBench(block, base, corner));
        generator.method_25623(block, base);
    }

    public static void createWallShelf(class_4910 generator) {
        class_2248 block = ModBlocks.OLD_WOOD_WALL_SHELF;
        class_2960 lower = class_4941.method_25842((class_2248)block);
        class_2960 lowerLeft = class_4941.method_25843((class_2248)block, (String)"_left");
        class_2960 lowerMiddle = class_4941.method_25843((class_2248)block, (String)"_middle");
        class_2960 lowerRight = class_4941.method_25843((class_2248)block, (String)"_right");
        class_2960 upper = class_4941.method_25843((class_2248)block, (String)"_top");
        class_2960 upperLeft = class_4941.method_25843((class_2248)block, (String)"_top_left");
        class_2960 upperMiddle = class_4941.method_25843((class_2248)block, (String)"_top_middle");
        class_2960 upperRight = class_4941.method_25843((class_2248)block, (String)"_top_right");
        generator.field_22830.accept(BlockStateProvider.createWallShelf(block, lower, lowerLeft, lowerMiddle, lowerRight, upper, upperLeft, upperMiddle, upperRight));
        generator.method_25623(block, upper);
    }

    public static void createJamJar(class_4910 generator) {
        class_2248 block = ModBlocks.JAM_JARS;
        List<class_2960> resourceLocations = List.of(class_4941.method_25843((class_2248)block, (String)"_one_jar"), class_4941.method_25843((class_2248)block, (String)"_two_jars"), class_4941.method_25843((class_2248)block, (String)"_three_jars"), class_4941.method_25843((class_2248)block, (String)"_four_jars"), class_4941.method_25843((class_2248)block, (String)"_five_jars"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_one_jar"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_two_jars"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_three_jars"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_four_jars"), class_4941.method_25843((class_2248)block, (String)"_on_shelf_five_jars"));
        generator.field_22830.accept(BlockStateProvider.createJamJar(block, resourceLocations));
        generator.method_25623(block, resourceLocations.get(4));
    }

    public static void createJamJar(class_4910 generator, class_2248 block) {
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, TextureMappings.getSimpleBlockTextureGroup(block, "jam_jars"));
        List<class_2960> resourceLocations = List.of(ModelTemplates.TEMPLATE_JAM_JAR_ONE_JAR.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_TWO_JARS.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_THREE_JARS.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_FOUR_JARS.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_FIVE_JARS.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_ON_SHELF_ONE_JAR.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_ON_SHELF_TWO_JARS.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_ON_SHELF_THREE_JARS.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_ON_SHELF_FOUR_JARS.method_25846(block, textureMapping, generator.field_22831), ModelTemplates.TEMPLATE_JAM_JAR_ON_SHELF_FIVE_JARS.method_25846(block, textureMapping, generator.field_22831));
        generator.field_22830.accept(BlockStateProvider.createJamJar(block, resourceLocations));
        generator.method_25623(block, resourceLocations.get(0));
    }

    public static void createBottle(class_4910 generator, class_2248 block) {
        String string = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_2960 resourceLocation = TextureMappings.getSimpleBlockTextureGroup(block, "bottle");
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23012, resourceLocation).method_25868(class_4945.field_23010, resourceLocation);
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_BOTTLE(string, "_one_bottle").create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.TEMPLATE_BOTTLE(string, "_two_bottles").create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation3 = ModelTemplates.TEMPLATE_BOTTLE(string, "_three_bottles").create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        class_2960 resourceLocation4 = ModelTemplates.TEMPLATE_BOTTLE(string, "_four_bottles").create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createFourStackModelDispatch(resourceLocation1, resourceLocation2, resourceLocation3, resourceLocation4)));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createNonTemplateOBJBlock(class_4910 generator, class_2248 block, @Nullable String parent) {
        String string = class_7923.field_41175.method_10221((Object)block).method_12832();
        class_2960 resourceLocation = parent != null ? TextureMappings.getSimpleBlockTextureGroup(block, parent) : class_4944.method_25860((class_2248)block);
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23012, resourceLocation).method_25868(class_4945.field_23010, resourceLocation);
        class_2960 resourceLocation1 = ModelTemplates.TEMPLATE_BOTTLE(string).create(block, textureMapping, (BiConsumer<class_2960, Supplier<JsonElement>>)generator.field_22831);
        generator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)resourceLocation1));
    }
}

