/*
 * Decompiled with CFR 0.152.
 */
package com.conquest.architects.data.models;

import com.conquest.architects.data.models.BlockStateProvider;
import com.conquest.architects.data.models.model.ModelTemplates;
import com.conquest.architects.data.models.model.TextureMappings;
import com.conquest.architects.data.models.model.TextureSlots;
import com.conquest.architects.world.level.block.state.properties.AttachFace;
import com.conquest.architects.world.level.block.state.properties.BlockStateProperty;
import com.conquest.architects.world.level.block.state.properties.Hinge;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4941;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_7923;

public abstract class BlockModelProvider
extends FabricModelProvider {
    public BlockModelProvider(FabricDataOutput output) {
        super(output);
    }

    public static void createHorizontalBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = ModelTemplates.HORIZONTAL_BEAMS.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createHorizontalBeam(block, models));
        generator.method_25623(block, models.get(7));
    }

    public static void createVerticalBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = IntStream.rangeClosed(1, 5).mapToObj(i -> ModelTemplates.verticalBeam(i).method_25846(block, textureMapping, generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createVerticalBeam(block, models.toArray(new class_2960[0])));
        generator.method_25623(block, models.get(0));
    }

    public static void createShallowDiagonalBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = ModelTemplates.SHALLOW_DIAGONAL_BEAMS.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        class_2960 resourceLocation = ModelTemplates.itemModel("shallow_diagonal_beam", class_4945.field_23018, class_4945.field_23013).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createShallowDiagonalBeam(block, models));
        generator.method_25623(block, resourceLocation);
    }

    public static void createHalfDiagonalBeam(class_4910 generator, class_2248 block, class_2248 family, String variant) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = ModelTemplates.halfDiagonalBeam(variant).stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        class_2960 resourceLocation = ModelTemplates.halfDiagonalBeamInventory(variant).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHalfDiagonalBeam(block, models));
        generator.method_25623(block, resourceLocation);
    }

    public static void createDiagonalBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = ModelTemplates.DIAGONAL_BEAM.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        List<class_2960> resourceLocation1 = models.subList(0, 4);
        List<class_2960> resourceLocation2 = models.subList(4, 8);
        class_2960 resourceLocation3 = ModelTemplates.itemModel("diagonal_beam", class_4945.field_23018, class_4945.field_23013).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createDiagonalBeam(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation3);
    }

    public static void createSteeperDiagonalBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = ModelTemplates.STEEPER_DIAGONAL_BEAM.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        List<class_2960> resourceLocation1 = models.subList(0, 4);
        List<class_2960> resourceLocation2 = models.subList(4, 8);
        List<class_2960> resourceLocation3 = models.subList(8, 12);
        List<class_2960> resourceLocation4 = models.subList(12, 16);
        class_2960 resourceLocation5 = ModelTemplates.itemModel("steeper_diagonal_beam", class_4945.field_23018, class_4945.field_23013).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createSteeperDiagonalBeam(block, resourceLocation1, resourceLocation2, resourceLocation3, resourceLocation4));
        generator.method_25623(block, resourceLocation5);
    }

    public static void createCornerHalfDiagonalBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = ModelTemplates.CORNER_HALF_DIAGONAL_BEAM.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createHalfDiagonalBeam(block, models));
        generator.method_25623(block, models.get(0));
    }

    public static void createHorizontalDiagonalBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        class_2960 bottom1 = ModelTemplates.HORIZONTAL_DIAGONAL_BEAM_BOTTOM1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 top1 = ModelTemplates.HORIZONTAL_DIAGONAL_BEAM_TOP1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottom2 = ModelTemplates.HORIZONTAL_DIAGONAL_BEAM_BOTTOM2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 top2 = ModelTemplates.HORIZONTAL_DIAGONAL_BEAM_TOP2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation = ModelTemplates.itemModel("horizontal_diagonal_beam", class_4945.field_23018, class_4945.field_23013).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDiagonalBeam(block, bottom1, top1, bottom2, top2));
        generator.method_25623(block, resourceLocation);
    }

    public static void createHorizontalHalfDiagonalBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        class_2960 bottomLeft1 = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_BOTTOM_LEFT1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomRight1 = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_BOTTOM_RIGHT1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topLeft1 = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_TOP_LEFT1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topRight1 = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_TOP_RIGHT1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomLeft2 = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_BOTTOM_LEFT2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomRight2 = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_BOTTOM_RIGHT2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topLeft2 = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_TOP_LEFT2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topRight2 = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_TOP_RIGHT2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation = ModelTemplates.HORIZONTAL_DIAGONAL_HALF_BEAM_INVENTORY.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDiagonalBeam(block, bottomLeft1, bottomRight1, topLeft1, topRight1, bottomLeft2, bottomRight2, topLeft2, topRight2));
        generator.method_25623(block, resourceLocation);
    }

    public static void bambooSteepSteps(class_4910 generator, class_2248 block) {
        class_2960 front = class_4941.method_25843((class_2248)block, (String)"_front");
        class_2960 back = class_4941.method_25843((class_2248)block, (String)"_back");
        generator.field_22830.accept(BlockStateProvider.createDirectionalHalfBlock(block, front, back));
        generator.method_25623(block, back);
    }

    public static void createDiagonalLintel(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        class_2960 bottom1 = ModelTemplates.DIAGONAL_LINTEL_BOTTOM1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 top1 = ModelTemplates.DIAGONAL_LINTEL_TOP1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottom2 = ModelTemplates.DIAGONAL_LINTEL_BOTTOM2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 top2 = ModelTemplates.DIAGONAL_LINTEL_TOP2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation = ModelTemplates.DIAGONAL_LINTEL_INVENTORY.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDiagonalBeam(block, bottom1, top1, bottom2, top2));
        generator.method_25623(block, resourceLocation);
    }

    public static void createHalfDiagonalLintel(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        class_2960 bottomLeft1 = ModelTemplates.HALF_DIAGONAL_LINTEL_BOTTOM_LEFT1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomRight1 = ModelTemplates.HALF_DIAGONAL_LINTEL_BOTTOM_RIGHT1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topLeft1 = ModelTemplates.HALF_DIAGONAL_LINTEL_TOP_LEFT1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topRight1 = ModelTemplates.HALF_DIAGONAL_LINTEL_TOP_RIGHT1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomLeft2 = ModelTemplates.HALF_DIAGONAL_LINTEL_BOTTOM_LEFT2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottomRight2 = ModelTemplates.HALF_DIAGONAL_LINTEL_BOTTOM_RIGHT2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topLeft2 = ModelTemplates.HALF_DIAGONAL_LINTEL_TOP_LEFT2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 topRight2 = ModelTemplates.HALF_DIAGONAL_LINTEL_TOP_RIGHT2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation = ModelTemplates.HALF_DIAGONAL_LINTEL_INVENTORY.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDiagonalBeam(block, bottomLeft1, bottomRight1, topLeft1, topRight1, bottomLeft2, bottomRight2, topLeft2, topRight2));
        generator.method_25623(block, resourceLocation);
    }

    public static void createStrippedLog(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        class_2960 log1 = ModelTemplates.THIN_STRIPPED_LOG1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 log2 = ModelTemplates.THIN_STRIPPED_LOG2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 log3 = ModelTemplates.THIN_STRIPPED_LOG3.method_25846(block, textureMapping, generator.field_22831);
        class_2960 log4 = ModelTemplates.THIN_STRIPPED_LOG4.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createStrippedLog(block, log1, log2, log3, log4));
        generator.method_25623(block, log1);
    }

    public static void createSupportBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        class_2960 bottom1 = ModelTemplates.SUPPORT_BEAM_BOTTOM1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottom2 = ModelTemplates.SUPPORT_BEAM_BOTTOM2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottom3 = ModelTemplates.SUPPORT_BEAM_BOTTOM3.method_25846(block, textureMapping, generator.field_22831);
        class_2960 bottom4 = ModelTemplates.SUPPORT_BEAM_BOTTOM4.method_25846(block, textureMapping, generator.field_22831);
        class_2960 top1 = ModelTemplates.SUPPORT_BEAM_TOP1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 top2 = ModelTemplates.SUPPORT_BEAM_TOP2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 top3 = ModelTemplates.SUPPORT_BEAM_TOP3.method_25846(block, textureMapping, generator.field_22831);
        class_2960 top4 = ModelTemplates.SUPPORT_BEAM_TOP4.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createSupportBeam(block, bottom1, bottom2, bottom3, bottom4, top1, top2, top3, top4));
        generator.method_25623(block, bottom1);
    }

    public static void createVerticalSupportBeam(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        class_2960 floor1 = ModelTemplates.VERTICAL_SUPPORT_BEAM_FLOOR1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 floor2 = ModelTemplates.VERTICAL_SUPPORT_BEAM_FLOOR2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 floor3 = ModelTemplates.VERTICAL_SUPPORT_BEAM_FLOOR3.method_25846(block, textureMapping, generator.field_22831);
        class_2960 floor4 = ModelTemplates.VERTICAL_SUPPORT_BEAM_FLOOR4.method_25846(block, textureMapping, generator.field_22831);
        class_2960 wall1 = ModelTemplates.VERTICAL_SUPPORT_BEAM_WALL1.method_25846(block, textureMapping, generator.field_22831);
        class_2960 wall2 = ModelTemplates.VERTICAL_SUPPORT_BEAM_WALL2.method_25846(block, textureMapping, generator.field_22831);
        class_2960 wall3 = ModelTemplates.VERTICAL_SUPPORT_BEAM_WALL3.method_25846(block, textureMapping, generator.field_22831);
        class_2960 wall4 = ModelTemplates.VERTICAL_SUPPORT_BEAM_WALL4.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createVerticalSupportBeam(block, floor1, floor2, floor3, floor4, wall1, wall2, wall3, wall4));
        generator.method_25623(block, floor1);
    }

    public static void createDiagonalBrace(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        class_2960 base = ModelTemplates.DIAGONAL_WOOD_BRACE.method_25846(block, textureMapping, generator.field_22831);
        class_2960 down = ModelTemplates.DIAGONAL_WOOD_BRACE_DOWN.method_25846(block, textureMapping, generator.field_22831);
        class_2960 up = ModelTemplates.DIAGONAL_WOOD_BRACE_UP.method_25846(block, textureMapping, generator.field_22831);
        class_2960 updown = ModelTemplates.DIAGONAL_WOOD_BRACE_UPDOWN.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createDiagonalBrace(block, base, down, up, updown));
        generator.method_25623(block, base);
    }

    public static void createLadder(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation1 = class_4941.method_25843((class_2248)block, (String)"_floor1");
        class_2960 resourceLocation2 = class_4941.method_25843((class_2248)block, (String)"_floor2");
        class_2960 resourceLocation3 = class_4941.method_25843((class_2248)block, (String)"_wall1");
        class_2960 resourceLocation4 = class_4941.method_25843((class_2248)block, (String)"_wall2");
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775((class_4926)class_4926.method_25784(BlockStateProperty.FACE, (class_2769)BlockStateProperty.TOGGLE).method_25797((Comparable)((Object)AttachFace.FLOOR), (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation1)).method_25797((Comparable)((Object)AttachFace.FLOOR), (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation2)).method_25797((Comparable)((Object)AttachFace.WALL), (Comparable)Boolean.valueOf(false), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation3)).method_25797((Comparable)((Object)AttachFace.WALL), (Comparable)Boolean.valueOf(true), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation4))));
        generator.method_25623(block, resourceLocation1);
    }

    public static void createDiagonalBoard(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = ModelTemplates.DIAGONAL_BOARD.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        class_2960 resourceLocation = ModelTemplates.itemModel("diagonal_board", class_4945.field_23018, class_4945.field_23013).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createExtendableBlock(block, models));
        generator.method_25623(block, resourceLocation);
    }

    public static void createSteeperDiagonalBoard(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.column(family);
        List<class_2960> models = ModelTemplates.STEEPER_DIAGONAL_BOARD.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        class_2960 resourceLocation = ModelTemplates.itemModel("steeper_diagonal_board", class_4945.field_23018, class_4945.field_23013).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createDirectionalHalfExtendableBlock(block, models));
        generator.method_25623(block, resourceLocation);
    }

    public static void createBalustrade(class_4910 generator, class_2248 block) {
        class_4944[] textureMapping = TextureMappings.balustrade(block);
        class_2960 single = ModelTemplates.BALUSTRADE_SINGLE.method_25846(block, textureMapping[0], generator.field_22831);
        class_2960 left = ModelTemplates.BALUSTRADE_LEFT.method_25846(block, textureMapping[2], generator.field_22831);
        class_2960 middle = ModelTemplates.BALUSTRADE_MIDDLE.method_25846(block, textureMapping[1], generator.field_22831);
        class_2960 right = ModelTemplates.BALUSTRADE_RIGHT.method_25846(block, textureMapping[2], generator.field_22831);
        class_2960 inventory = ModelTemplates.itemModel("balustrade", class_4945.field_23018, class_4945.field_23015, TextureSlots.POST).method_25846(block, textureMapping[2], generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalConnectingBlock(block, single, left, middle, right));
        generator.method_25623(block, inventory);
    }

    public static void createCornerBalustrade(class_4910 generator, class_2248 block) {
        class_4944[] textureMapping = TextureMappings.balustrade(block);
        List<class_2960> models = ModelTemplates.BALUSTRADE_CORNER.stream().map(template -> template.method_25846(block, textureMapping[2], generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createExtendableBlock(block, models));
        generator.method_25623(block, models.get(0));
    }

    public static void createDiagonalBalustrade(class_4910 generator, class_2248 block) {
        class_4944[] textureMapping = TextureMappings.balustrade(block);
        List<class_2960> models = ModelTemplates.DIAGONAL_BALUSTRADE.stream().map(template -> template.method_25846(block, textureMapping[3], generator.field_22831)).toList();
        class_2960 inventory = ModelTemplates.itemModel("diagonal_balustrade", class_4945.field_23018, TextureSlots.POST, class_4945.field_23015).method_25846(block, textureMapping[2], generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHingeExtendableBlock(block, models));
        generator.method_25623(block, inventory);
    }

    public static void createSpiralStaircase(class_4910 generator, class_2248 block) {
        class_2960 resourceLocation = class_7923.field_41175.method_10221((Object)block);
        String path = resourceLocation.method_12832();
        class_4944 textureMapping = new class_4944().method_25868(class_4945.field_23010, TextureMappings.getBlockTextureGroup(block, "spiral_staircase", path));
        class_2960 resourceLocation1 = ModelTemplates.SPIRAL_STAIRCASE.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.SPIRAL_STAIRCASE_CORNER.method_25846(block, textureMapping, generator.field_22831);
        class_2960 resourceLocation3 = ModelTemplates.itemModel("spiral_staircase", class_4945.field_23010).method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createEightWayHorizontalFacingBlock(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation3);
    }

    public static void createStoneSteps(class_4910 generator, class_2248 block) {
        class_4944 textureMapping = TextureMappings.stoneSteps(block);
        class_2960 resourceLocation = ModelTemplates.STONE_STEPS.method_25846(block, textureMapping, generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createHorizontalDirectionalBlock(block, resourceLocation));
        generator.method_25623(block, resourceLocation);
    }

    public static void createStoneShallowSteps(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.stoneSteps(family);
        List<class_2960> resourceLocation = ModelTemplates.STONE_SHALLOW_STEPS.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createVerticalHalfBlock(block, resourceLocation.get(0), resourceLocation.get(1)));
        generator.method_25623(block, resourceLocation.get(0));
    }

    public static void createWoodSteepSteps(class_4910 generator, class_2248 block, String variant) {
        class_4944 textureMapping = TextureMappings.woodSteps(block);
        List<class_2960> resourceLocation = ModelTemplates.woodSteepSteps(variant).stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createDirectionalHalfBlock(block, resourceLocation.get(0), resourceLocation.get(1)));
        generator.method_25623(block, resourceLocation.get(1));
    }

    public static void createStoneSteepSteps(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944 textureMapping = TextureMappings.stoneSteps(family);
        List<class_2960> resourceLocation = ModelTemplates.STONE_STEEP_STEPS.stream().map(template -> template.method_25846(block, textureMapping, generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createDirectionalHalfBlock(block, resourceLocation.get(0), resourceLocation.get(1)));
        generator.method_25623(block, resourceLocation.get(1));
    }

    public static void createStoneLintel(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944[] textureMapping = TextureMappings.balustrade(family);
        List<class_2960> resourceLocation = ModelTemplates.STONE_LINTEL.stream().map(template -> template.method_25846(block, textureMapping[1], generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createVerticalHalfExtendableBlock(block, resourceLocation));
        generator.method_25623(block, resourceLocation.get(4));
    }

    public static void createStoneDoorFrame(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944[] textureMapping = TextureMappings.balustrade(family);
        List<class_2960> resourceLocation = ModelTemplates.STONE_DOOR_FRAME.stream().map(template -> template.method_25846(block, textureMapping[1], generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createVerticalHalfExtendableBlock(block, resourceLocation));
        generator.method_25623(block, resourceLocation.get(7));
    }

    public static void createStoneDoorFramePost(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944[] textureMapping = TextureMappings.balustrade(family);
        List<class_2960> resourceLocation = ModelTemplates.STONE_DOOR_FRAME_POST.stream().map(template -> template.method_25846(block, textureMapping[1], generator.field_22831)).toList();
        generator.field_22830.accept(class_4925.method_25769((class_2248)block).method_25775(BlockStateProvider.createHorizontalFacingDispatch()).method_25775((class_4926)class_4926.method_25783(BlockStateProperty.HINGE).method_25793((Comparable)((Object)Hinge.LEFT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation.get(0))).method_25793((Comparable)((Object)Hinge.RIGHT), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)resourceLocation.get(1)))));
        generator.method_25623(block, resourceLocation.get(0));
    }

    public static void createCorbel(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944[] textureMapping = TextureMappings.corbel(family);
        List<class_2960> resourceLocation = ModelTemplates.CORBEL.stream().map(template -> template.method_25846(block, textureMapping[3], generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createTwoVariantBlock(block, resourceLocation.get(0), resourceLocation.get(1)));
        generator.method_25623(block, resourceLocation.get(0));
    }

    public static void createFlowerDesignCorbel(class_4910 generator, class_2248 block) {
        class_4944[] textureMapping = TextureMappings.corbel(block);
        List<class_2960> resourceLocation = ModelTemplates.FLOWER_DESIGN_CORBEL.stream().map(template -> template.method_25846(block, textureMapping[0], generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createTwoVariantBlock(block, resourceLocation.get(0), resourceLocation.get(1)));
        generator.method_25623(block, resourceLocation.get(0));
    }

    public static void createArchitrave(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944[] textureMapping = TextureMappings.corbel(family);
        List<class_2960> resourceLocation = ModelTemplates.THIN_ARCHITRAVE.stream().map(template -> template.method_25846(block, textureMapping[0], generator.field_22831)).toList();
        generator.field_22830.accept(BlockStateProvider.createVerticalHalfBlock(block, resourceLocation.get(0), resourceLocation.get(1)));
        generator.method_25623(block, resourceLocation.get(1));
    }

    public static void createWallAttachedPillar(class_4910 generator, class_2248 block, class_2248 family) {
        class_4944[] textureMapping = TextureMappings.corbel(family);
        class_2960 resourceLocation1 = ModelTemplates.WALL_ATTACHED_PILLAR.method_25846(block, textureMapping[1], generator.field_22831);
        class_2960 resourceLocation2 = ModelTemplates.WALL_ATTACHED_PILLAR_TOP.method_25846(block, textureMapping[2], generator.field_22831);
        generator.field_22830.accept(BlockStateProvider.createTwoVariantBlock(block, resourceLocation1, resourceLocation2));
        generator.method_25623(block, resourceLocation2);
    }
}

