/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.item;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.entity.PictureFrameEntity;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class PictureItem
extends class_1792 {
    public static final class_2960 ID = Camerapture.id("picture");
    public static final class_5321<class_1792> KEY = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)ID);
    private static final SimpleDateFormat SDF = new SimpleDateFormat("MMM d, yyyy 'at' HH:mm");

    public PictureItem() {
        super(new class_1792.class_1793());
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!user.method_5715()) {
            return class_1271.method_22427((Object)stack);
        }
        return class_1271.method_22430((Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null || !player.method_5715()) {
            return class_1269.field_5811;
        }
        class_1937 world = context.method_8045();
        class_2350 facing = context.method_8038();
        class_2338 pos = context.method_8037().method_10093(facing);
        class_1799 itemStack = context.method_8041();
        if (facing.method_10166().method_10178() || !player.method_7343(pos, facing, itemStack)) {
            return class_1269.field_5811;
        }
        PictureFrameEntity pictureFrameEntity = new PictureFrameEntity(world, pos, facing);
        if (!pictureFrameEntity.canStayAttached()) {
            return class_1269.field_5811;
        }
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound != null) {
            class_1299.method_5881((class_1937)world, (class_1657)player, (class_1297)pictureFrameEntity, (class_2487)nbtCompound);
        }
        pictureFrameEntity.setItemStack(itemStack.method_46651(1));
        if (!world.field_9236) {
            pictureFrameEntity.onPlace();
            world.method_43275((class_1297)player, class_5712.field_28738, pictureFrameEntity.method_19538());
            world.method_8649((class_1297)pictureFrameEntity);
        }
        itemStack.method_7934(1);
        return class_1269.field_5812;
    }

    public static class_1799 create(String creator, UUID uuid) {
        class_1799 stack = new class_1799((class_1935)Camerapture.PICTURE, 1);
        class_2487 nbt = stack.method_7948();
        nbt.method_10582("creator", creator);
        nbt.method_25927("uuid", uuid);
        nbt.method_10544("timestamp", System.currentTimeMillis());
        return stack;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        PictureItem.getTooltip(tooltip::add, stack);
    }

    public static void getTooltip(Consumer<class_2561> textConsumer, class_1799 stack) {
        PictureData data = PictureItem.getPictureData(stack);
        if (data == null) {
            return;
        }
        textConsumer.accept((class_2561)class_2561.method_43469((String)"item.camerapture.picture.creator_tooltip", (Object[])new Object[]{class_2561.method_43470((String)data.creator).method_27692(class_124.field_1080)}).method_27692(class_124.field_1063));
        String timestamp = SDF.format(new Date(data.timestamp));
        textConsumer.accept((class_2561)class_2561.method_43469((String)"item.camerapture.picture.timestamp_tooltip", (Object[])new Object[]{class_2561.method_43470((String)timestamp).method_27692(class_124.field_1080)}).method_27692(class_124.field_1063));
    }

    @Nullable
    public static PictureData getPictureData(class_1799 stack) {
        class_2487 nbt = stack.method_7948();
        if (nbt.method_10545("uuid")) {
            return new PictureData(nbt.method_25926("uuid"), nbt.method_10558("creator"), nbt.method_10537("timestamp"));
        }
        return null;
    }

    public record PictureData(UUID id, String creator, long timestamp) {
    }
}

