/*
 * Decompiled with CFR 0.152.
 */
package kpan.bq_popup.util;

import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class StringReader {
    private final String string;
    private int cursor;

    public StringReader(StringReader other) {
        this.string = other.string;
        this.cursor = other.cursor;
    }

    public StringReader(String string) {
        this.string = string;
        this.setCursor(0);
    }

    public String getString() {
        return this.string;
    }

    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    public void setCursorToEnd() {
        this.cursor = this.string.length();
    }

    public int getRemainingLength() {
        return this.string.length() - this.cursor;
    }

    public int getTotalLength() {
        return this.string.length();
    }

    public int getCursor() {
        return this.cursor;
    }

    public String getAlreadyRead() {
        return this.string.substring(0, this.cursor);
    }

    public String getRemaining() {
        return this.string.substring(this.cursor);
    }

    public boolean canRead(int length) {
        return this.cursor + length <= this.string.length();
    }

    public boolean canRead() {
        return this.canRead(1);
    }

    public char peek() {
        return this.string.charAt(this.cursor);
    }

    public char peek(int offset) {
        return this.string.charAt(this.cursor + offset);
    }

    public String peekStr(int length) {
        return this.string.substring(this.cursor, this.cursor + length);
    }

    public char read() {
        return this.string.charAt(this.cursor++);
    }

    public void skip() {
        ++this.cursor;
    }

    public void skip(int count) {
        this.cursor += count;
    }

    public void skipWhitespace() {
        while (this.canRead() && Character.isWhitespace(this.peek())) {
            this.skip();
        }
    }

    public void expect(char expected) {
        char next = this.peek();
        if (next != expected) {
            throw new IllegalStateException("Expected '" + expected + "', not " + next);
        }
        this.skip();
    }

    public boolean testAndSkip(char c) {
        if (this.canRead() && this.peek() == c) {
            this.skip();
            return true;
        }
        return false;
    }

    @Nullable
    public String tryReadToChar(char charInclusive) {
        int index = this.string.indexOf(charInclusive, this.cursor);
        if (index == -1) {
            return null;
        }
        return this.readTo(index + 1);
    }

    public String readToChar(char charExclusive) {
        int index = this.string.indexOf(charExclusive, this.cursor);
        if (index == -1) {
            return this.readTo(this.string.length());
        }
        return this.readTo(index);
    }

    public String readStr(int length) {
        return this.readTo(this.cursor + length);
    }

    private String readTo(int indexExcl) {
        String res = this.string.substring(this.cursor, indexExcl);
        this.cursor = indexExcl;
        return res;
    }

    public String readQuotedString() {
        if (!this.canRead()) {
            return "";
        }
        this.expect('\"');
        int index = this.string.indexOf(34, this.cursor);
        if (index == -1) {
            return null;
        }
        return this.readTo(index + 1);
    }

    public String readStr(Predicate<Character> filter) {
        int start = this.cursor;
        while (this.canRead() && filter.test(Character.valueOf(this.peek()))) {
            this.skip();
        }
        return this.string.substring(start, this.cursor);
    }

    public double readDouble() {
        if (!this.canRead()) {
            return Double.NaN;
        }
        String valueStr = this.readStr(c -> c.charValue() >= '0' && c.charValue() <= '9' || c.charValue() == '.');
        if (valueStr == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(valueStr);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public double readDoubleWithSign() {
        boolean isNegative;
        if (!this.canRead()) {
            return Double.NaN;
        }
        if (this.testAndSkip('-')) {
            isNegative = true;
        } else {
            isNegative = false;
            this.testAndSkip('+');
        }
        double value = this.readDouble();
        return isNegative ? -value : value;
    }
}

