/*
 * Decompiled with CFR 0.152.
 */
package kpan.bq_popup.client;

import java.util.Stack;
import java.util.function.DoubleBinaryOperator;
import kpan.bq_popup.util.StringReader;

public class PositionExpression {
    public static boolean canParse(String expression) {
        return !Double.isNaN(PositionExpression.parseExpression(0, 0, expression));
    }

    public static double parseExpression(int screenSize, int iconSize, String expression) {
        Double b;
        Stack<Double> valueStack = new Stack<Double>();
        Stack<Operation> operationStack = new Stack<Operation>();
        StringReader stringReader = new StringReader(expression);
        while (stringReader.canRead()) {
            stringReader.skipWhitespace();
            if (stringReader.testAndSkip('+')) {
                if (!operationStack.isEmpty()) {
                    if (valueStack.size() < 2) {
                        return Double.NaN;
                    }
                    Double a = (Double)valueStack.pop();
                    b = (Double)valueStack.pop();
                    valueStack.push(((Operation)((Object)operationStack.pop())).operate(a, b));
                }
                operationStack.add(Operation.ADD);
                continue;
            }
            if (stringReader.testAndSkip('-')) {
                if (!operationStack.isEmpty()) {
                    if (valueStack.size() < 2) {
                        return Double.NaN;
                    }
                    Double a = (Double)valueStack.pop();
                    b = (Double)valueStack.pop();
                    valueStack.push(((Operation)((Object)operationStack.pop())).operate(a, b));
                }
                operationStack.add(Operation.SUB);
                continue;
            }
            double value = stringReader.readDouble();
            if (Double.isNaN(value)) {
                return Double.NaN;
            }
            if (stringReader.testAndSkip('%')) {
                value *= (double)screenSize * 0.01;
            }
            valueStack.push(value);
        }
        while (!operationStack.isEmpty()) {
            if (valueStack.size() < 2) {
                return Double.NaN;
            }
            Double a = (Double)valueStack.pop();
            b = (Double)valueStack.pop();
            valueStack.push(((Operation)((Object)operationStack.pop())).operate(a, b));
        }
        if (valueStack.isEmpty()) {
            return Double.NaN;
        }
        return (Double)valueStack.pop();
    }

    private static enum Operation {
        ADD((a, b) -> a + b),
        SUB((a, b) -> a - b);

        private final DoubleBinaryOperator operation;

        private Operation(DoubleBinaryOperator operation) {
            this.operation = operation;
        }

        public double operate(double a, double b) {
            return this.operation.applyAsDouble(a, b);
        }
    }
}

