/*
 * Decompiled with CFR 0.152.
 */
package kpan.bq_popup.client;

import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.gui.ToastQuestObject;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import kpan.bq_popup.ModMain;
import kpan.bq_popup.client.QuestCompletePopup;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_642;
import org.apache.commons.lang3.StringUtils;

public class DisplayedPopup {
    public static LongSet popupDisplayed = new LongOpenHashSet();
    private static final File cacheDir = new File(new File(class_310.method_1551().field_1697, "better_quest_popup"), "completed-cache");

    public static void add(QuestObject object) {
        popupDisplayed.add(object.id);
        DisplayedPopup.writeToFile();
    }

    public static void remove(QuestObject object) {
        popupDisplayed.remove(object.id);
        DisplayedPopup.writeToFile();
    }

    public static void display(QuestObject object) {
        if (popupDisplayed.contains(object.id)) {
            if (object instanceof Quest) {
                class_310.method_1551().method_1566().method_1999((class_368)new ToastQuestObject(object));
            }
        } else {
            QuestCompletePopup.add(object);
            DisplayedPopup.add(object);
        }
    }

    public static void onLoad() {
        ClientQuestFile questFile = ClientQuestFile.INSTANCE;
        DisplayedPopup.readFromFile();
        if (!popupDisplayed.isEmpty()) {
            TeamData teamData = questFile.selfTeamData;
            for (ChapterGroup chapterGroup : questFile.getChapterGroups()) {
                for (Chapter chapter : chapterGroup.getChapters()) {
                    for (Quest quest : chapter.getQuests()) {
                        if (!teamData.isCompleted((QuestObject)quest) || popupDisplayed.contains(quest.id)) continue;
                        QuestCompletePopup.add((QuestObject)quest);
                    }
                    if (!teamData.isCompleted((QuestObject)chapter) || popupDisplayed.contains(chapter.id)) continue;
                    QuestCompletePopup.add((QuestObject)chapter);
                }
            }
            if (teamData.isCompleted((QuestObject)questFile) && !popupDisplayed.contains(questFile.id)) {
                QuestCompletePopup.add((QuestObject)questFile);
            }
        }
        DisplayedPopup.sync(questFile);
    }

    public static void sync(ClientQuestFile questFile) {
        popupDisplayed.clear();
        TeamData teamData = questFile.selfTeamData;
        for (ChapterGroup chapterGroup : questFile.getChapterGroups()) {
            for (Chapter chapter : chapterGroup.getChapters()) {
                for (Quest quest : chapter.getQuests()) {
                    if (!teamData.isCompleted((QuestObject)quest)) continue;
                    popupDisplayed.add(quest.id);
                }
                if (!teamData.isCompleted((QuestObject)chapter)) continue;
                popupDisplayed.add(chapter.id);
            }
        }
        if (teamData.isCompleted((QuestObject)questFile)) {
            popupDisplayed.add(questFile.id);
        }
        DisplayedPopup.writeToFile();
    }

    private static void readFromFile() {
        popupDisplayed.clear();
        class_642 currentServerEntry = class_310.method_1551().method_1558();
        if (currentServerEntry == null) {
            return;
        }
        try {
            if (!cacheDir.exists()) {
                return;
            }
            for (String line : Files.readAllLines(new File(cacheDir, DisplayedPopup.sanitizeFileName(currentServerEntry.field_3761)).toPath(), StandardCharsets.UTF_8)) {
                if (line.isEmpty()) continue;
                popupDisplayed.add(Long.parseLong(line));
            }
        }
        catch (IOException | NumberFormatException e) {
            ModMain.LOGGER.error("Error while reading the cache.", (Throwable)e);
        }
    }

    private static void writeToFile() {
        class_642 currentServerEntry = class_310.method_1551().method_1558();
        if (currentServerEntry != null) {
            File file = new File(cacheDir, DisplayedPopup.sanitizeFileName(currentServerEntry.field_3761));
            try {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists() && !file.createNewFile()) {
                    ModMain.LOGGER.error("Cannot create a cache");
                    return;
                }
                if (file.canWrite()) {
                    FileOutputStream fos = new FileOutputStream(file);
                    BufferedWriter buffer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
                    for (Long id : popupDisplayed) {
                        buffer.write(id + "\n");
                    }
                    buffer.close();
                    fos.close();
                } else {
                    ModMain.LOGGER.error("Cannot write the cache file");
                }
            }
            catch (IOException e) {
                ModMain.LOGGER.error("Error while saving the cache.", (Throwable)e);
            }
        }
    }

    private static String sanitizeFileName(String name) {
        return StringUtils.replaceAll((String)name, (String)"[/\\:*?\"<>|]", (String)"-");
    }
}

