/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.common.entities;

import com.obscuria.aquamirae.Aquamirae;
import com.obscuria.aquamirae.AquamiraeClient;
import com.obscuria.aquamirae.common.entities.ShipGraveyardEntity;
import com.obscuria.aquamirae.common.items.weapon.DividerItem;
import com.obscuria.aquamirae.common.items.weapon.PoisonedBladeItem;
import com.obscuria.aquamirae.common.items.weapon.RemnantsSaberItem;
import com.obscuria.aquamirae.common.items.weapon.WhisperOfTheAbyssItem;
import com.obscuria.aquamirae.registry.AquamiraeEntities;
import com.obscuria.aquamirae.registry.AquamiraeItems;
import com.obscuria.aquamirae.registry.AquamiraeParticles;
import com.obscuria.aquamirae.registry.AquamiraeSounds;
import com.obscuria.obscureapi.api.hekate.Animation;
import com.obscuria.obscureapi.api.hekate.AnimationHelper;
import com.obscuria.obscureapi.api.hekate.IAnimated;
import com.obscuria.obscureapi.api.utils.EntityUtils;
import com.obscuria.obscureapi.common.entities.CompoundProjectileEntity;
import com.obscuria.obscureapi.common.entities.TextureFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1543;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;

@ShipGraveyardEntity
public class CaptainCorneliaEntity
extends class_1588
implements IAnimated {
    private static final class_2940<Integer> REGENERATION = class_2945.method_12791(CaptainCorneliaEntity.class, (class_2941)class_2943.field_13327);
    private final class_3213 bossInfo = new class_3213(this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795);
    public final Animation PULL_ATTACK = new Animation(1);
    public final Animation SWING_ATTACK = new Animation(2);
    public final Animation THRUST_ATTACK = new Animation(3);
    public final Animation SWITCH_WEAPON = new Animation(4);
    public final Animation DEATH = new Animation(5);
    private static final int WEAPON_SWITCH_INTERVAL = 400;
    private int weaponSwitchTick;

    public CaptainCorneliaEntity(class_1299<CaptainCorneliaEntity> type, class_1937 world) {
        super(type, world);
        this.field_6194 = 100;
        this.method_5971();
        this.method_5673(class_1304.field_6173, this.getMainWeapon().method_7854());
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(4, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.2, false){

            protected double method_6289(class_1309 entity) {
                return 0.0;
            }
        });
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, false, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1543.class, false, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1646.class, false, false));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(REGENERATION, (Object)2);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        class_2487 data = new class_2487();
        data.method_10569("Regeneration", ((Integer)this.field_6011.method_12789(REGENERATION)).intValue());
        nbt.method_10566("CorneliaData", (class_2520)data);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        class_2487 data = nbt.method_10562("CorneliaData");
        if (data.method_33133()) {
            return;
        }
        this.field_6011.method_12778(REGENERATION, (Object)data.method_10550("Regeneration"));
    }

    public Optional<Animation> getAnimation(byte id) {
        return switch (id) {
            case 1 -> Optional.of(this.PULL_ATTACK);
            case 2 -> Optional.of(this.SWING_ATTACK);
            case 3 -> Optional.of(this.THRUST_ATTACK);
            case 4 -> Optional.of(this.SWITCH_WEAPON);
            case 5 -> Optional.of(this.DEATH);
            default -> Optional.empty();
        };
    }

    public boolean isAttacks() {
        return this.PULL_ATTACK.isPlaying() || this.SWING_ATTACK.isPlaying() || this.THRUST_ATTACK.isPlaying() || this.SWITCH_WEAPON.isPlaying();
    }

    public void method_5773() {
        class_1937 class_19372;
        AnimationHelper.handleDeath((class_1309)this, (Animation)this.DEATH, (int)60);
        AnimationHelper.handle((Animation[])new Animation[]{this.PULL_ATTACK, this.SWING_ATTACK, this.THRUST_ATTACK, this.SWITCH_WEAPON, this.DEATH});
        if (this.PULL_ATTACK.hasPlayed() && this.method_5968() != null) {
            this.SWING_ATTACK.play((class_1297)this, 40);
        }
        if (this.SWING_ATTACK.hasPlayed() && this.method_5968() != null) {
            this.THRUST_ATTACK.play((class_1297)this, 40);
        }
        if (this.SWITCH_WEAPON.getTick() == 10) {
            this.switchWeapon();
        }
        this.SWING_ATTACK.sound((class_1297)this, 1, () -> AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_ATTACK_1, class_3419.field_15251, 2.0f, 1.0f);
        this.THRUST_ATTACK.sound((class_1297)this, 1, () -> AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_ATTACK_2, class_3419.field_15251, 2.0f, 1.0f);
        this.SWITCH_WEAPON.sound((class_1297)this, 8, () -> class_3417.field_14862, class_3419.field_15251, 1.0f, 1.0f);
        ++this.weaponSwitchTick;
        if (this.method_29504()) {
            this.method_6012();
        }
        if ((double)this.method_6032() < (double)this.method_6063() * 0.25 && (Integer)this.field_6011.method_12789(REGENERATION) > 0 && !this.method_6059(class_1294.field_5902)) {
            this.rage();
        }
        if (this.method_6032() <= 16.0f && !this.method_6059(class_1294.field_5911)) {
            this.method_6025(0.5f);
        }
        if (this.method_5968() != null) {
            class_1309 target = this.method_5968();
            double distance = this.method_5858((class_1297)target);
            this.modifyYRot(EntityUtils.getYAngleBetween((class_1297)this, (class_1297)target), this.method_24828() ? 0.15f : 0.3f);
            this.field_6206.method_35111((class_1297)target);
            if (!this.isAttacks() && !this.method_37908().method_8608()) {
                if (this.weaponSwitchTick > 400 && this.field_5974.method_43057() < (float)(this.weaponSwitchTick - 400) / 5000.0f) {
                    this.SWITCH_WEAPON.play((class_1297)this, 20);
                    this.weaponSwitchTick = 0;
                } else if (distance < 3.0 || this.method_6059(class_1294.field_5902) || distance < 25.0 && this.field_5974.method_43048(100) == 1) {
                    if (this.field_5974.method_43056()) {
                        this.SWING_ATTACK.play((class_1297)this, 40);
                    } else {
                        this.THRUST_ATTACK.play((class_1297)this, 40);
                    }
                } else if (distance < 600.0 && this.field_5974.method_43048(200) == 1) {
                    this.PULL_ATTACK.play((class_1297)this, 30);
                }
            }
            if (this.PULL_ATTACK.getTick() == 10) {
                target.method_18799(target.method_19538().method_1035(this.method_19538().method_1031(0.0, 0.5, 0.0)).method_1021(0.25));
                if (target instanceof class_1657) {
                    class_1657 player = (class_1657)target;
                    player.field_6037 = true;
                }
            }
            if (this.SWING_ATTACK.getTick() == 12 || this.THRUST_ATTACK.getTick() == 12) {
                this.method_18799(this.method_19538().method_1035(target.method_19538().method_1031(0.0, 0.1, 0.0)).method_1021((double)0.2f));
            }
            if (this.SWING_ATTACK.getTick() == 14 && distance < 9.0) {
                EntityUtils.getRelativeEntities((class_1309)this, class_1309.class, (float)5.0f, (float)0.0f, (float)0.0f, (float)6.0f, (boolean)true, (boolean)true).forEach(e -> {
                    if (e != this) {
                        this.method_6121((class_1297)e);
                    }
                });
            }
            if (this.THRUST_ATTACK.getTick() == 14 && distance < 12.0) {
                this.method_6121((class_1297)target);
            }
            if (this.SWING_ATTACK.getTick() == 12) {
                TextureFX.Builder.create((int)30).owner((class_1297)this).texture("aquamirae", "swing").relativePos((class_1309)this, 1.0f, 0.0f, -0.7f).relativeRot((class_1309)this, false, true).yRot(-90.0f, 0.0f, 0.0f).moveForward(0.0f, 3.0f, -0.2f).scale(0.4f, 0.4f, -0.013f).alpha(1.0f, -0.01f, -0.01f).build(this.method_37908());
            }
            if (this.method_5869() && !this.method_6059(class_1294.field_5902)) {
                this.method_18799(this.method_19538().method_1035(target.method_19538()).method_1021((double)0.04f));
            } else if (this.method_5799() && !this.method_6059(class_1294.field_5902)) {
                this.method_18799(this.method_19538().method_1035(target.method_19538()).method_1021((double)0.04f).method_1031(0.0, (double)0.08f, 0.0));
            }
        }
        if (this.isAttacks()) {
            this.method_6092(new class_1293(class_1294.field_5909, 5, 3, false, false));
        }
        if (this.method_6059(class_1294.field_5902)) {
            this.method_6025(1.0f);
            if (!this.method_37908().method_8608()) {
                List list = this.method_37908().method_8390(class_1309.class, new class_238(this.method_19538(), this.method_19538()).method_1014(10.0), e -> true);
                class_1293 LEVITATION = this.method_6112(class_1294.field_5902);
                int DURATION = LEVITATION == null ? 0 : LEVITATION.method_5584();
                list.forEach(entity -> {
                    class_1657 player;
                    if (entity instanceof class_1657 && ((player = (class_1657)entity).method_7337() || player.method_7325())) {
                        return;
                    }
                    if (entity.method_6063() <= 100.0f) {
                        if (DURATION > 1) {
                            double radius = 5.0;
                            class_243 orbit = new class_243(this.method_23317() + Math.cos((float)entity.field_6012 * -0.1f) * 5.0, this.method_23318(), this.method_23321() + Math.sin((float)entity.field_6012 * -0.1f) * 5.0);
                            entity.method_18799(entity.method_19538().method_1035(orbit).method_1021((double)0.2f));
                            if (entity instanceof class_1657) {
                                class_1657 _player = (class_1657)entity;
                                _player.field_6037 = true;
                            }
                        } else if (DURATION == 1) {
                            entity.method_18799(this.method_19538().method_1035(entity.method_19538()).method_1021((double)0.2f));
                            if (entity instanceof class_1657) {
                                class_1657 _player = (class_1657)entity;
                                _player.field_6037 = true;
                            }
                        }
                    }
                });
                class_1937 class_19373 = this.method_37908();
                if (class_19373 instanceof class_3218) {
                    class_3218 server = (class_3218)class_19373;
                    if (this.field_6012 % 2 == 0) {
                        server.method_14199((class_2394)AquamiraeParticles.GHOST, this.method_23317(), this.method_23318() - 0.2, this.method_23321(), 1, 0.3, 0.1, 0.3, 0.1);
                    }
                }
                if (this.method_5799()) {
                    this.method_18799(new class_243(0.0, (double)0.4f, 0.0));
                }
            }
        }
        if ((class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 server = (class_3218)class_19372;
            if (this.field_6012 % 10 == 0) {
                server.method_14199((class_2394)AquamiraeParticles.GHOST_SHINE, this.method_23317(), this.method_23318() + 1.7, this.method_23321(), 1, 0.15, 0.1, 0.15, 0.1);
            }
        }
        if (this.method_37908().method_8608()) {
            class_243 center = this.method_19538();
            this.method_37908().method_8390(class_1657.class, new class_238(center, center).method_1014(32.0), e -> true).forEach(AquamiraeClient::playCorneliaMusic);
        }
        super.method_5773();
    }

    private void modifyYRot(float rotation, float mod2) {
        this.field_5982 = this.method_36454();
        this.method_36456(this.method_36454() + (rotation - this.method_36454()) * mod2);
    }

    public class_1792 getMainWeapon() {
        return Aquamirae.isWinterEvent() ? AquamiraeItems.SWEET_LANCE : AquamiraeItems.CORAL_LANCE;
    }

    public void switchWeapon() {
        class_1309 target = this.method_5968();
        class_1792 current = this.method_6047().method_7909();
        class_1792 main = this.getMainWeapon();
        WhisperOfTheAbyssItem armor = AquamiraeItems.WHISPER_OF_THE_ABYSS;
        DividerItem health = AquamiraeItems.DIVIDER;
        PoisonedBladeItem poison = AquamiraeItems.POISONED_BLADE;
        RemnantsSaberItem heal = AquamiraeItems.REMNANTS_SABER;
        ArrayList<class_1792> weapons = new ArrayList<class_1792>();
        if (!current.equals(main)) {
            this.add(weapons, main, 10);
        }
        if (!current.equals((Object)poison)) {
            this.add(weapons, (class_1792)poison, 10);
        }
        if (!current.equals((Object)health)) {
            this.add(weapons, (class_1792)health, target == null ? 1 : (int)(target.method_6032() / 5.0f) + (target.method_6032() >= 200.0f ? 1000 : 0));
        }
        if (!current.equals((Object)armor)) {
            this.add(weapons, (class_1792)armor, target == null ? 1 : target.method_6096());
        }
        if (!current.equals((Object)heal)) {
            this.add(weapons, (class_1792)heal, (int)(this.method_6063() - this.method_6063() / 5.0f) + (this.method_6032() <= 20.0f ? 1000 : 0));
        }
        if (weapons.isEmpty()) {
            return;
        }
        class_1792 item = (class_1792)weapons.get(this.field_5974.method_39332(0, Math.max(1, weapons.size() - 1)));
        this.method_5673(class_1304.field_6173, item.method_7854());
        this.method_5673(class_1304.field_6171, item instanceof DividerItem || item instanceof PoisonedBladeItem || item instanceof RemnantsSaberItem ? item.method_7854() : class_1799.field_8037);
    }

    private void add(List<class_1792> list, class_1792 item, int times) {
        for (int i = 1; i <= times; ++i) {
            list.add(item);
        }
    }

    public void rage() {
        this.field_6011.method_12778(REGENERATION, (Object)((Integer)this.field_6011.method_12789(REGENERATION) - 1));
        this.method_6092(new class_1293(class_1294.field_5902, 200, 0, false, false));
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2338 pos = this.method_24515();
            class_1538 entityToSpawn = new class_1538(class_1299.field_6112, (class_1937)serverLevel);
            entityToSpawn.method_33574(class_243.method_24953((class_2382)pos));
            entityToSpawn.method_29498(true);
            serverLevel.method_8649((class_1297)entityToSpawn);
            serverLevel.method_8396(null, pos, AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_HORN, class_3419.field_15251, 3.0f, 1.0f);
            serverLevel.method_8396(null, pos, AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_RAGE, class_3419.field_15251, 4.0f, 1.0f);
            Object type = this.field_5974.method_43056() ? AquamiraeEntities.POISONED_CHAKRA : AquamiraeEntities.MAZE_ROSE;
            CompoundProjectileEntity.create(type, (class_1297)this, (class_1937)this.method_37908(), null, (int)5, (float)0.0f, (int)600, (int)1000);
            CompoundProjectileEntity.create(type, (class_1297)this, (class_1937)this.method_37908(), null, (int)5, (float)0.33f, (int)600, (int)1000);
            CompoundProjectileEntity.create(type, (class_1297)this, (class_1937)this.method_37908(), null, (int)5, (float)0.66f, (int)600, (int)1000);
        }
    }

    public boolean method_6121(class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            class_1792 item = this.method_6047().method_7909();
            if (item instanceof PoisonedBladeItem) {
                living.method_6092(new class_1293(class_1294.field_5899, 80, 2));
                return super.method_6121(entity);
            }
            if (item instanceof WhisperOfTheAbyssItem) {
                living.method_6015((class_1309)this);
                return this.tryAttack(living, this.method_48923().method_48831(), 8.0f);
            }
            if (item instanceof DividerItem) {
                living.method_6015((class_1309)this);
                return this.tryAttack(living, this.method_48923().method_48831(), Math.max(4.0f, living.method_6032() / 2.0f));
            }
            if (item instanceof RemnantsSaberItem) {
                this.method_6025(Math.min(30.0f, living.method_6063() * 0.4f));
                return super.method_6121(entity);
            }
        }
        return super.method_6121(entity);
    }

    private boolean tryAttack(class_1309 entity, class_1282 source, float amount) {
        boolean hurt = entity.method_5643(source, amount);
        if (hurt) {
            float knockback = (float)this.method_26825(class_5134.field_23722);
            if (knockback > 0.0f) {
                entity.method_6005((double)(knockback * 0.5f), (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
                this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            this.method_5723((class_1309)this, (class_1297)entity);
            entity.method_6015((class_1309)this);
        }
        return hurt;
    }

    protected void method_16078() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_1799 map;
            class_3218 server = (class_3218)class_19372;
            if (Math.random() <= (double)0.2f) {
                class_1542 item = new class_1542(class_1299.field_6052, (class_1937)server);
                item.method_6979(this.getMainWeapon().method_7854());
                item.method_33574(this.method_19538());
                server.method_8649((class_1297)item);
            }
            if (!(map = Aquamirae.createStructureMap(Aquamirae.SHELTER, server, (class_1297)this)).method_7960()) {
                class_1542 item = new class_1542(class_1299.field_6052, (class_1937)server);
                item.method_6979(map);
                item.method_33574(this.method_19538());
                server.method_8649((class_1297)item);
            }
        }
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    public boolean method_5974(double distanceSquared) {
        return false;
    }

    public class_3414 method_5994() {
        return AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_AMBIENT;
    }

    public class_3414 method_6011(class_1282 source) {
        return AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_HURT;
    }

    public class_3414 method_6002() {
        return AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_DEATH;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() instanceof class_1667) {
            return false;
        }
        if (source.method_49708(class_8111.field_42345)) {
            return false;
        }
        if (source.method_49708(class_8111.field_42344)) {
            return false;
        }
        if (source.method_49708(class_8111.field_42342)) {
            return false;
        }
        if (source.method_49708(class_8111.field_42336)) {
            return false;
        }
        if (source.method_49708(class_8111.field_42331)) {
            return false;
        }
        if (source.method_49708(class_8111.field_42322)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        world.method_8396(null, this.method_24515(), AquamiraeSounds.ENTITY_CAPTAIN_CORNELIA_HORN, class_3419.field_15251, 3.0f, 1.0f);
        this.method_6092(new class_1293(class_1294.field_5902, 120, 0, false, false));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean method_5822() {
        return false;
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossInfo.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossInfo.method_14089(player);
    }

    public void method_5670() {
        super.method_5670();
        if (!this.method_37908().method_8608()) {
            this.bossInfo.method_5408(this.method_6032() / this.method_6063());
        }
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23716, 200.0).method_26868(class_5134.field_23724, 16.0).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, 128.0).method_26868(class_5134.field_23718, 0.5).method_26868(class_5134.field_23722, 2.0);
    }
}

