/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.utils;

import com.yogpc.qp.utils.ConstantEntry;
import com.yogpc.qp.utils.SupplierCacheEntry;
import java.util.function.Supplier;
import net.minecraft.class_1937;

public abstract class CacheEntry<T> {
    protected long lastUpdateTime = 0L;
    protected final long cacheInterval;
    protected T cached;

    protected CacheEntry(long cacheInterval) {
        this.cacheInterval = cacheInterval;
    }

    public T getValue(long currentTime) {
        if (currentTime - this.lastUpdateTime >= this.cacheInterval || this.cached == null) {
            this.setNewCache();
            this.lastUpdateTime = currentTime;
        }
        return this.cached;
    }

    public T getValue(class_1937 level) {
        if (level == null) {
            return this.getValue(0L);
        }
        return this.getValue(level.method_8510());
    }

    protected abstract void setNewCache();

    public void expire() {
        this.cached = null;
    }

    public String toString() {
        return "CacheEntry{cached=" + this.cached + "}";
    }

    public static <T> CacheEntry<T> supplierCache(long cacheInterval, Supplier<T> supplier) {
        return new SupplierCacheEntry<T>(cacheInterval, supplier);
    }

    public static <T> CacheEntry<T> constantCache(Supplier<T> supplier) {
        return new ConstantEntry<T>(supplier);
    }
}

