/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.marker.TileMarker;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.ColorBox;
import com.yogpc.qp.render.Sprites;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class RenderMarker
implements class_827<TileMarker> {
    private static final double a = 0.5;
    private static final double b = 0.625;
    private static final double c = 0.375;

    public RenderMarker(class_5614.class_5615 context) {
    }

    public void render(TileMarker entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        ColorBox color;
        class_1058 sprite;
        Box[] renderBoxes;
        Optional<Box[]> optionalBoxes = entity.renderArea();
        class_2338 markerPos = entity.method_11016();
        if (optionalBoxes.isPresent()) {
            renderBoxes = optionalBoxes.get();
            sprite = Sprites.INSTANCE.getWhite();
            color = ColorBox.markerBlueColor;
        } else if (entity.rsReceiving && entity.getArea().isEmpty()) {
            class_746 player = class_310.method_1551().field_1724;
            double playerX = player == null ? (double)markerPos.method_10263() : player.method_23317();
            double playerZ = player == null ? (double)markerPos.method_10260() : player.method_23321();
            int visibleRange = 32;
            double xMin = Math.max(playerX - (double)visibleRange, (double)(markerPos.method_10263() - 256));
            double xMax = Math.min(playerX + (double)visibleRange, (double)(markerPos.method_10263() + 256));
            double zMin = Math.max(playerZ - (double)visibleRange, (double)(markerPos.method_10260() - 256));
            double zMax = Math.min(playerZ + (double)visibleRange, (double)(markerPos.method_10260() + 256));
            renderBoxes = (Box[])Stream.of(Box.apply(xMin + 0.625, (double)markerPos.method_10264() + 0.5, (double)markerPos.method_10260() + 0.5, xMax + 0.375, (double)markerPos.method_10264() + 0.5, (double)markerPos.method_10260() + 0.5, xMax - xMin - 0.25, 0.126, 0.126, false, false), Box.apply((double)markerPos.method_10263() + 0.5, (double)markerPos.method_10264() + 0.5, zMin + 0.625, (double)markerPos.method_10263() + 0.5, (double)markerPos.method_10264() + 0.5, zMax + 0.375, 0.126, 0.126, zMax - zMin - 0.25, false, false)).toArray(Box[]::new);
            sprite = Sprites.INSTANCE.getWhite();
            color = ColorBox.markerRedColor;
        } else {
            return;
        }
        class_310.method_1551().method_16011().method_15396("quarryplus");
        class_310.method_1551().method_16011().method_15396("RenderMarker");
        class_4588 buffer = vertexConsumers.getBuffer(class_1921.method_23579());
        matrices.method_22903();
        matrices.method_46416((float)(-markerPos.method_10263()), (float)(-markerPos.method_10264()), (float)(-markerPos.method_10260()));
        for (Box box : renderBoxes) {
            box.render(buffer, matrices, sprite, color);
        }
        matrices.method_22909();
        class_310.method_1551().method_16011().method_15407();
        class_310.method_1551().method_16011().method_15407();
    }

    public static Box[] getRenderBox(Area area) {
        int flag = 0;
        int xMin = area.minX();
        int yMin = area.minY();
        int zMin = area.minZ();
        int xMax = area.maxX();
        int yMax = area.maxY();
        int zMax = area.maxZ();
        if (xMin != xMax) {
            flag |= 1;
        }
        if (yMin != yMax) {
            flag |= 2;
        }
        if (zMin != zMax) {
            flag |= 4;
        }
        class_238[] lineBoxes = new class_238[12];
        if ((flag & 1) == 1) {
            lineBoxes[0] = new class_238((double)xMin + 0.625, (double)yMin + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMin + 0.5);
        }
        if ((flag & 2) == 2) {
            lineBoxes[4] = new class_238((double)xMin + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMin + 0.5);
        }
        if ((flag & 4) == 4) {
            lineBoxes[8] = new class_238((double)xMin + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMin + 0.5, (double)zMax + 0.375);
        }
        if ((flag & 3) == 3) {
            lineBoxes[2] = new class_238((double)xMin + 0.625, (double)yMax + 0.5, (double)zMin + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMin + 0.5);
            lineBoxes[6] = new class_238((double)xMax + 0.5, (double)yMin + 0.625, (double)zMin + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMin + 0.5);
        }
        if ((flag & 5) == 5) {
            lineBoxes[1] = new class_238((double)xMin + 0.625, (double)yMin + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMin + 0.5, (double)zMax + 0.5);
            lineBoxes[9] = new class_238((double)xMax + 0.5, (double)yMin + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMin + 0.5, (double)zMax + 0.375);
        }
        if ((flag & 6) == 6) {
            lineBoxes[5] = new class_238((double)xMin + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMin + 0.5, (double)yMax + 0.375, (double)zMax + 0.5);
            lineBoxes[10] = new class_238((double)xMin + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMin + 0.5, (double)yMax + 0.5, (double)zMax + 0.375);
        }
        if ((flag & 7) == 7) {
            lineBoxes[3] = new class_238((double)xMin + 0.625, (double)yMax + 0.5, (double)zMax + 0.5, (double)xMax + 0.375, (double)yMax + 0.5, (double)zMax + 0.5);
            lineBoxes[7] = new class_238((double)xMax + 0.5, (double)yMin + 0.625, (double)zMax + 0.5, (double)xMax + 0.5, (double)yMax + 0.375, (double)zMax + 0.5);
            lineBoxes[11] = new class_238((double)xMax + 0.5, (double)yMax + 0.5, (double)zMin + 0.625, (double)xMax + 0.5, (double)yMax + 0.5, (double)zMax + 0.375);
        }
        return (Box[])Arrays.stream(lineBoxes).filter(Objects::nonNull).map(range -> Box.apply(range, Math.max(range.method_17939(), 0.126), Math.max(range.method_17940(), 0.126), Math.max(range.method_17941(), 0.126), false, false)).toArray(Box[]::new);
    }

    public int method_33893() {
        return 256;
    }

    public boolean shouldRenderOffScreen(TileMarker blockEntity) {
        return true;
    }
}

