/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.recipe;

import com.google.gson.JsonObject;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.QPBlock;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8566;

public class QuarryBedrockModuleRecipe
extends class_1867 {
    public static final class_2960 NAME = new class_2960("quarryplus", "quarry_bedrock_recipe");
    public static final class_1865<QuarryBedrockModuleRecipe> SERIALIZER = new QuarryBedrockModuleSerializer();
    private final QPBlock targetBlock;

    public QuarryBedrockModuleRecipe(class_2960 id, QPBlock targetBlock) {
        super(id, "quarryplus:bedrock_module_recipe", class_7710.field_40251, QuarryBedrockModuleRecipe.makeOutputStack(targetBlock), class_2371.method_10212((Object)class_1856.method_35226(), (Object[])new class_1856[]{class_1856.method_8091((class_1935[])new class_1935[]{targetBlock}), class_1856.method_8091((class_1935[])new class_1935[]{QuarryPlus.ModObjects.ITEM_BEDROCK_MODULE})}));
        this.targetBlock = targetBlock;
    }

    public boolean method_17730(class_8566 inventory, class_1937 world) {
        List<class_1799> stacks = IntStream.range(0, inventory.method_5439()).mapToObj(arg_0 -> ((class_8566)inventory).method_5438(arg_0)).filter(Predicate.not(class_1799::method_7960)).toList();
        if (stacks.size() == 2) {
            class_1799 quarryStack = stacks.stream().filter(s -> s.method_7909() == this.targetBlock.blockItem).findFirst().map(class_1799::method_7972).orElse(class_1799.field_8037);
            class_2487 subNbt = class_1747.method_38072((class_1799)quarryStack);
            boolean hasQuarry = !quarryStack.method_7960() && (subNbt == null || !subNbt.method_10577("bedrockRemove"));
            boolean hasModule = stacks.stream().map(class_1799::method_7909).anyMatch(Predicate.isEqual(QuarryPlus.ModObjects.ITEM_BEDROCK_MODULE));
            return hasQuarry && hasModule;
        }
        return false;
    }

    private static class_1799 makeOutputStack(class_2248 targetBlock) {
        class_1799 quarryStack = new class_1799((class_1935)targetBlock);
        quarryStack.method_7911("BlockEntityTag").method_10556("bedrockRemove", true);
        return quarryStack;
    }

    public class_1799 method_17729(class_8566 inventory, class_5455 access) {
        List<class_1799> stacks = IntStream.range(0, inventory.method_5439()).mapToObj(arg_0 -> ((class_8566)inventory).method_5438(arg_0)).filter(Predicate.not(class_1799::method_7960)).toList();
        class_1799 quarryStack = stacks.stream().filter(s -> s.method_7909() == this.targetBlock.blockItem).findFirst().map(class_1799::method_7972).orElseThrow();
        quarryStack.method_7911("BlockEntityTag").method_10556("bedrockRemove", true);
        return quarryStack;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    private static final class QuarryBedrockModuleSerializer
    implements class_1865<QuarryBedrockModuleRecipe> {
        private QuarryBedrockModuleSerializer() {
        }

        public QuarryBedrockModuleRecipe fromJson(class_2960 resourceLocation, JsonObject jsonObject) {
            String name = class_3518.method_15265((JsonObject)jsonObject, (String)"target");
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(name));
            if (block instanceof QPBlock) {
                QPBlock qpBlock = (QPBlock)block;
                return new QuarryBedrockModuleRecipe(resourceLocation, qpBlock);
            }
            throw new IllegalArgumentException("Invalid block %s(%s)".formatted(block, name));
        }

        public QuarryBedrockModuleRecipe fromNetwork(class_2960 resourceLocation, class_2540 buf) {
            class_2960 name = buf.method_10810();
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(name);
            if (block instanceof QPBlock) {
                QPBlock qpBlock = (QPBlock)block;
                return new QuarryBedrockModuleRecipe(resourceLocation, qpBlock);
            }
            throw new IllegalArgumentException("Invalid block %s(%s)".formatted(block, name));
        }

        public void toNetwork(class_2540 buf, QuarryBedrockModuleRecipe recipe) {
            buf.method_10812(recipe.targetBlock.getRegistryName());
        }
    }
}

