/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet;

import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.packet.IMessage;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.Pair;

public class QuarryPlacedMessage
implements IMessage<QuarryPlacedMessage> {
    public static final class_2960 NAME = new class_2960("quarryplus", "quarry_placed_message");
    private final class_2338 pos;
    private final class_5321<class_1937> dim;
    private final List<EnchantmentLevel> levels;
    private final class_2487 otherData;

    public QuarryPlacedMessage(TileQuarry quarry) {
        this(quarry.method_10997(), quarry.method_11016(), quarry.getEnchantments(), quarry.getTileDataForItem());
    }

    public QuarryPlacedMessage(class_1937 world, class_2338 pos, List<EnchantmentLevel> levels, class_2487 otherData) {
        this.levels = levels;
        this.otherData = otherData;
        this.pos = pos;
        this.dim = world != null ? world.method_27983() : class_1937.field_25179;
    }

    public QuarryPlacedMessage(class_2540 buffer) {
        this.pos = buffer.method_10811();
        this.dim = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)buffer.method_10810());
        this.levels = IntStream.range(0, buffer.readInt()).mapToObj(i -> new EnchantmentLevel(buffer.method_10810(), buffer.readInt())).toList();
        this.otherData = buffer.method_10798();
    }

    @Override
    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10807(this.pos).method_10812(this.dim.method_29177());
        buffer.writeInt(this.levels.size());
        for (EnchantmentLevel level : this.levels) {
            buffer.method_10812(Objects.requireNonNull(level.enchantmentID())).writeInt(level.level());
        }
        buffer.method_10794(this.otherData);
    }

    @Override
    public class_2960 getIdentifier() {
        return NAME;
    }

    @Environment(value=EnvType.CLIENT)
    static class HandlerHolder {
        static final ClientPlayNetworking.PlayChannelHandler HANDLER = (client, handler, buf, responseSender) -> {
            QuarryPlacedMessage message = new QuarryPlacedMessage(buf);
            class_638 world = client.field_1687;
            if (world != null && world.method_27983().equals(message.dim)) {
                client.execute(() -> {
                    class_2586 patt2990$temp = world.method_8321(message.pos);
                    if (patt2990$temp instanceof TileQuarry) {
                        TileQuarry quarry = (TileQuarry)patt2990$temp;
                        quarry.setEnchantments(message.levels.stream().map(e -> Pair.of((Object)e.enchantment(), (Object)e.level())).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
                        quarry.setTileDataFromItem(message.otherData);
                    }
                });
            }
        };

        HandlerHolder() {
        }
    }
}

