/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.packet;

import com.yogpc.qp.machines.advquarry.AdvActionMessage;
import com.yogpc.qp.machines.filler.FillerButtonMessage;
import com.yogpc.qp.machines.misc.LevelMessage;
import com.yogpc.qp.machines.placer.RemotePlacerMessage;
import com.yogpc.qp.machines.quarry.QuarryConfigSyncMessage;
import com.yogpc.qp.packet.ClientSyncMessage;
import com.yogpc.qp.packet.FlexMarkerMessage;
import com.yogpc.qp.packet.IMessage;
import com.yogpc.qp.packet.Marker16Message;
import com.yogpc.qp.packet.QuarryPlacedMessage;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class PacketHandler {
    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(@NotNull IMessage<?> message) {
        class_2540 packet = PacketByteBufs.create();
        message.writeToBuffer(packet);
        ClientPlayNetworking.send((class_2960)message.getIdentifier(), (class_2540)packet);
    }

    public static void sendToClientPlayer(@NotNull IMessage<?> message, @NotNull class_3222 player) {
        class_2540 packet = PacketByteBufs.create();
        message.writeToBuffer(packet);
        ServerPlayNetworking.send((class_3222)player, (class_2960)message.getIdentifier(), (class_2540)packet);
    }

    public static void sendToClientWorld(@NotNull IMessage<?> message, class_1937 level) {
        class_2540 packet = PacketByteBufs.create();
        message.writeToBuffer(packet);
        for (class_3222 player : PlayerLookup.world((class_3218)((class_3218)level))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)message.getIdentifier(), (class_2540)packet);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        public static void initClient() {
            List<ClientPacketInit> list = List.of(new ClientPacketInit(QuarryPlacedMessage.NAME, QuarryPlacedMessage.HandlerHolder.HANDLER), new ClientPacketInit(ClientSyncMessage.NAME, ClientSyncMessage.HandlerHolder.HANDLER));
            list.forEach(i -> ClientPlayNetworking.registerGlobalReceiver((class_2960)i.name(), (ClientPlayNetworking.PlayChannelHandler)i.handler()));
        }

        private record ClientPacketInit(class_2960 name, ClientPlayNetworking.PlayChannelHandler handler) {
        }
    }

    public static class Server {
        public static void initServer() {
            List<ServerPacketInit> list = List.of(new ServerPacketInit(QuarryConfigSyncMessage.NAME, QuarryConfigSyncMessage.handler), new ServerPacketInit(LevelMessage.NAME, LevelMessage.handler), new ServerPacketInit(AdvActionMessage.NAME, AdvActionMessage.handler), new ServerPacketInit(FlexMarkerMessage.NAME, FlexMarkerMessage.handler), new ServerPacketInit(Marker16Message.NAME, Marker16Message.handler), new ServerPacketInit(FillerButtonMessage.NAME, FillerButtonMessage.handler), new ServerPacketInit(RemotePlacerMessage.NAME, RemotePlacerMessage.handler));
            list.forEach(i -> ServerPlayNetworking.registerGlobalReceiver((class_2960)i.name(), (ServerPlayNetworking.PlayChannelHandler)i.handler()));
        }

        private record ServerPacketInit(class_2960 name, ServerPlayNetworking.PlayChannelHandler handler) {
        }
    }
}

