/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.EnergyConfigAccessor;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.quarry.EnchantmentRestriction;
import com.yogpc.qp.machines.quarry.QuarryConfig;
import com.yogpc.qp.machines.quarry.QuarryEnergyConfigAccessor;
import com.yogpc.qp.machines.quarry.QuarryMenu;
import com.yogpc.qp.machines.quarry.QuarryState;
import com.yogpc.qp.machines.quarry.Target;
import com.yogpc.qp.packet.ClientSync;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public class TileQuarry
extends PowerTile
implements ClientSync,
CheckerLog,
MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
ExtendedScreenHandlerFactory {
    private static final Marker MARKER = MarkerManager.getMarker((String)"TileQuarry");
    private static final EnchantmentRestriction RESTRICTION = EnchantmentRestriction.builder().add(class_1893.field_9131).add(class_1893.field_9119).add(class_1893.field_9130).add(class_1893.field_9099).build();
    @Nullable
    public Target target;
    public QuarryState state = QuarryState.FINISHED;
    @Nullable
    private Area area;
    private List<EnchantmentLevel> enchantments = new ArrayList<EnchantmentLevel>();
    public MachineStorage storage = new MachineStorage();
    public double headX;
    public double headY;
    public double headZ;
    private boolean bedrockRemove = false;
    public int digMinY = 0;
    private final ItemConverter itemConverter = ItemConverter.defaultConverter();
    QuarryConfig quarryConfig = new QuarryConfig(true);

    public TileQuarry(class_2338 pos, class_2680 state) {
        super(QuarryPlus.ModObjects.QUARRY_TYPE, pos, state, (long)(1.0E9 * QuarryPlus.config.quarry.quarryEnergyCapacity));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        if (this.target != null) {
            nbt.method_10566("target", (class_2520)Target.toNbt(this.target));
        }
        nbt.method_10582("state", this.state.name());
        if (this.area != null) {
            nbt.method_10566("area", (class_2520)this.area.toNBT());
        }
        class_2487 enchantments = new class_2487();
        this.enchantments.forEach(e -> enchantments.method_10569(Objects.requireNonNull(e.enchantmentID(), "Invalid enchantment. " + e.enchantment()).toString(), e.level()));
        nbt.method_10566("enchantments", (class_2520)enchantments);
        nbt.method_10549("headX", this.headX);
        nbt.method_10549("headY", this.headY);
        nbt.method_10549("headZ", this.headZ);
        nbt.method_10566("storage", (class_2520)this.storage.toNbt());
        nbt.method_10556("bedrockRemove", this.bedrockRemove);
        nbt.method_10569("digMinY", this.digMinY);
        nbt.method_10566("quarryConfig", (class_2520)this.quarryConfig.toTag());
        super.method_11007(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.target = nbt.method_10545("target") ? Target.fromNbt(nbt.method_10562("target")) : null;
        this.state = QuarryState.valueOf(nbt.method_10558("state"));
        this.area = Area.fromNBT(nbt.method_10562("area")).orElse(null);
        class_2487 enchantments = nbt.method_10562("enchantments");
        this.enchantments = enchantments.method_10541().stream().map(k -> Pair.of((Object)((class_1887)class_7923.field_41176.method_10223(new class_2960(k))), (Object)enchantments.method_10550(k))).filter(p -> p.getKey() != null).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList();
        this.headX = nbt.method_10574("headX");
        this.headY = nbt.method_10574("headY");
        this.headZ = nbt.method_10574("headZ");
        this.storage.readNbt(nbt.method_10562("storage"));
        this.bedrockRemove = nbt.method_10577("bedrockRemove");
        this.digMinY = nbt.method_10550("digMinY");
        this.quarryConfig = QuarryConfig.fromTag(nbt.method_10562("quarryConfig"));
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public final class_2487 toClientTag(class_2487 tag) {
        if (this.area != null) {
            tag.method_10566("area", (class_2520)this.area.toNBT());
        }
        tag.method_10582("state", this.state.name());
        tag.method_10549("headX", this.headX);
        tag.method_10549("headY", this.headY);
        tag.method_10549("headZ", this.headZ);
        return tag;
    }

    @Override
    public final void fromClientTag(class_2487 tag) {
        this.area = Area.fromNBT(tag.method_10562("area")).orElse(null);
        this.state = QuarryState.valueOf(tag.method_10558("state"));
        this.headX = tag.method_10574("headX");
        this.headY = tag.method_10574("headY");
        this.headZ = tag.method_10574("headZ");
    }

    public void setArea(@Nullable Area area) {
        this.area = area;
        QuarryPlus.LOGGER.debug(MARKER, "Quarry({}) Area changed to {}.", (Object)this.field_11867, (Object)area);
        if (area != null) {
            this.headX = area.minX();
            this.headY = area.minY();
            this.headZ = area.minZ();
        }
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    public void setState(QuarryState quarryState, class_2680 blockState) {
        if (this.state != quarryState) {
            this.state = quarryState;
            this.sync();
            if (this.field_11863 != null) {
                this.field_11863.method_8652(this.field_11867, (class_2680)blockState.method_11657((class_2769)QPBlock.WORKING, (Comparable)Boolean.valueOf(quarryState.isWorking)), 2);
                if (!this.field_11863.field_9236 && !quarryState.isWorking) {
                    this.logUsage();
                }
            }
            QuarryPlus.LOGGER.debug(MARKER, "Quarry({}) State changed to {}.", (Object)this.field_11867, (Object)quarryState);
        }
    }

    public void setBedrockRemove(boolean bedrockRemove) {
        this.bedrockRemove = bedrockRemove;
    }

    public class_3218 getTargetWorld() {
        return (class_3218)this.method_10997();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TileQuarry quarry) {
        if (quarry.hasEnoughEnergy()) {
            quarry.state.tick(world, pos, state, quarry);
        }
    }

    public BreakResult breakBlock(class_2338 targetPos) {
        return this.breakBlock(targetPos, true);
    }

    public BreakResult breakBlock(class_2338 targetPos, boolean requireEnergy) {
        float hardness;
        class_2248 class_22482;
        class_2680 blockState;
        class_3218 targetWorld = this.getTargetWorld();
        if (targetPos.method_10263() % 3 == 0 && targetPos.method_10260() % 3 == 0) {
            targetWorld.method_8390(class_1542.class, new class_238(targetPos).method_1014(5.0), Predicate.not(i -> i.method_6983().method_7960())).forEach(i -> {
                this.storage.addItem(i.method_6983());
                i.method_5768();
            });
        }
        if ((blockState = targetWorld.method_8320(targetPos)).method_26215() || !this.canBreak((class_1937)targetWorld, targetPos, blockState)) {
            return BreakResult.SKIPPED;
        }
        BreakResult notEnoughEnergy = TileQuarry.checkEdgeFluid(targetPos, requireEnergy, targetWorld, this);
        if (notEnoughEnergy == BreakResult.NOT_ENOUGH_ENERGY) {
            return notEnoughEnergy;
        }
        class_3610 fluidState = targetWorld.method_8316(targetPos);
        if (!fluidState.method_15769() && (class_22482 = blockState.method_26204()) instanceof class_2263) {
            class_2263 fluidBlock = (class_2263)class_22482;
            if (requireEnergy && !this.useEnergy(PowerTile.Constants.getBreakBlockFluidEnergy(this), PowerTile.Reason.REMOVE_FLUID, false)) {
                return BreakResult.NOT_ENOUGH_ENERGY;
            }
            class_1799 bucketItem = fluidBlock.method_9700((class_1936)targetWorld, targetPos, blockState);
            this.storage.addFluid(bucketItem);
            blockState = targetWorld.method_8320(targetPos);
        }
        float f = hardness = fluidState.method_15769() ? blockState.method_26214((class_1922)targetWorld, targetPos) : 5.0f;
        if (requireEnergy && !this.useEnergy(PowerTile.Constants.getBreakEnergy(hardness, this), PowerTile.Reason.BREAK_BLOCK, false)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        List drops = class_2248.method_9609((class_2680)blockState, (class_3218)targetWorld, (class_2338)targetPos, (class_2586)targetWorld.method_8321(targetPos), null, (class_1799)this.getPickaxe());
        drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
        targetWorld.method_8652(targetPos, class_2246.field_10124.method_9564(), 3);
        class_2498 sound = blockState.method_26231();
        if (requireEnergy) {
            targetWorld.method_8396(null, targetPos, sound.method_10595(), class_3419.field_15245, (sound.method_10597() + 1.0f) / 4.0f, sound.method_10599() * 0.8f);
        }
        return BreakResult.SUCCESS;
    }

    public static BreakResult checkEdgeFluid(class_2338 targetPos, boolean requireEnergy, class_3218 targetWorld, TileQuarry quarry) {
        boolean flagMaxZ;
        Area area = quarry.getArea();
        assert (area != null);
        boolean flagMinX = targetPos.method_10263() - 1 == area.minX();
        boolean flagMaxX = targetPos.method_10263() + 1 == area.maxX();
        boolean flagMinZ = targetPos.method_10260() - 1 == area.minZ();
        boolean bl = flagMaxZ = targetPos.method_10260() + 1 == area.maxZ();
        if (flagMinX && TileQuarry.removeFluidAtEdge(targetWorld, new class_2338(area.minX(), targetPos.method_10264(), targetPos.method_10260()), requireEnergy, quarry)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        if (flagMaxX && TileQuarry.removeFluidAtEdge(targetWorld, new class_2338(area.maxX(), targetPos.method_10264(), targetPos.method_10260()), requireEnergy, quarry)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        if (flagMinZ && TileQuarry.removeFluidAtEdge(targetWorld, new class_2338(targetPos.method_10263(), targetPos.method_10264(), area.minZ()), requireEnergy, quarry)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        if (flagMaxZ && TileQuarry.removeFluidAtEdge(targetWorld, new class_2338(targetPos.method_10263(), targetPos.method_10264(), area.maxZ()), requireEnergy, quarry)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        if (flagMinX && flagMinZ && TileQuarry.removeFluidAtEdge(targetWorld, new class_2338(area.minX(), targetPos.method_10264(), area.minZ()), requireEnergy, quarry)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        if (flagMinX && flagMaxZ && TileQuarry.removeFluidAtEdge(targetWorld, new class_2338(area.minX(), targetPos.method_10264(), area.maxZ()), requireEnergy, quarry)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        if (flagMaxX && flagMinZ && TileQuarry.removeFluidAtEdge(targetWorld, new class_2338(area.maxX(), targetPos.method_10264(), area.minZ()), requireEnergy, quarry)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        if (flagMaxX && flagMaxZ && TileQuarry.removeFluidAtEdge(targetWorld, new class_2338(area.maxX(), targetPos.method_10264(), area.maxZ()), requireEnergy, quarry)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        return BreakResult.SUCCESS;
    }

    private static boolean removeFluidAtEdge(class_3218 world, class_2338 pos, boolean requireEnergy, TileQuarry quarry) {
        class_2680 state = world.method_8320(pos);
        class_3610 fluidState = world.method_8316(pos);
        if (!fluidState.method_15769()) {
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2263) {
                class_2263 fluidBlock = (class_2263)class_22482;
                if (requireEnergy && !quarry.useEnergy(PowerTile.Constants.getBreakBlockFluidEnergy(quarry), PowerTile.Reason.REMOVE_FLUID, false)) {
                    return true;
                }
                class_1799 bucketItem = fluidBlock.method_9700((class_1936)world, pos, state);
                quarry.storage.addFluid(bucketItem);
                if (world.method_22347(pos) || fluidBlock instanceof class_2404 && !fluidState.method_15771()) {
                    world.method_8501(pos, QuarryPlus.ModObjects.BLOCK_FRAME.getDammingState());
                }
            } else if (state.method_26204() instanceof class_2402) {
                float hardness = state.method_26214((class_1922)world, pos);
                if (requireEnergy && !quarry.useEnergy(PowerTile.Constants.getBreakEnergy(hardness, quarry), PowerTile.Reason.REMOVE_FLUID, false)) {
                    return true;
                }
                List drops = class_2248.method_9609((class_2680)state, (class_3218)world, (class_2338)pos, (class_2586)world.method_8321(pos), null, (class_1799)quarry.getPickaxe());
                drops.forEach(quarry.storage::addItem);
                world.method_8501(pos, QuarryPlus.ModObjects.BLOCK_FRAME.getDammingState());
            }
        }
        return false;
    }

    public void setEnchantments(Map<class_1887, Integer> enchantments) {
        this.enchantments = RESTRICTION.filterMap(enchantments).entrySet().stream().map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList();
    }

    public void setTileDataFromItem(@Nullable class_2487 tileData) {
        if (tileData == null) {
            this.digMinY = this.field_11863 == null ? 0 : this.field_11863.method_31607();
            return;
        }
        this.setBedrockRemove(tileData.method_10577("bedrockRemove"));
        this.digMinY = tileData.method_10545("digMinY") ? tileData.method_10550("digMinY") : (this.field_11863 == null ? 0 : this.field_11863.method_31607());
    }

    public class_2487 getTileDataForItem() {
        class_2487 tag = new class_2487();
        if (this.bedrockRemove) {
            tag.method_10556("bedrockRemove", true);
        }
        if (this.digMinY != 0) {
            tag.method_10569("digMinY", this.digMinY);
        }
        return tag;
    }

    double headSpeed() {
        return TileQuarry.headSpeed(this.enchantments.stream().filter(e -> e.enchantment() == class_1893.field_9131).mapToInt(EnchantmentLevel::level).findFirst().orElse(0));
    }

    static double headSpeed(int efficiency) {
        if (efficiency >= 4) {
            return Math.pow(2.0, efficiency - 4);
        }
        return Math.pow(1.681792830507429, efficiency) / 8.0;
    }

    public boolean canBreak(class_1937 targetWorld, class_2338 targetPos, class_2680 state) {
        boolean unbreakable;
        boolean bl = unbreakable = state.method_26214((class_1922)targetWorld, targetPos) < 0.0f;
        if (unbreakable && this.bedrockRemove && state.method_26204() == class_2246.field_9987) {
            int worldBottom = targetWorld.method_31607();
            if (targetWorld.method_27983().equals(class_1937.field_25180)) {
                return worldBottom < targetPos.method_10264() && targetPos.method_10264() < worldBottom + 5 || 122 < targetPos.method_10264() && targetPos.method_10264() < QuarryPlus.config.common.netherTop;
            }
            return worldBottom < targetPos.method_10264() && targetPos.method_10264() < worldBottom + 5;
        }
        return !unbreakable;
    }

    @Override
    public List<? extends class_2561> getDebugLogs() {
        return Stream.of("%sArea:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.area), "%sTarget:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.target), "%sState:%s %s".formatted(new Object[]{class_124.field_1060, class_124.field_1070, this.state}), "%sRemoveBedrock:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.bedrockRemove), "%sConfig:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.quarryConfig), "%sEnchantment:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.enchantments), "%sDigMinY:%s %d".formatted(class_124.field_1060, class_124.field_1070, this.digMinY), "%sHead:%s (%f, %f, %f)".formatted(class_124.field_1060, class_124.field_1070, this.headX, this.headY, this.headZ), "%sEnergy:%s %f FE (%d)".formatted(class_124.field_1060, class_124.field_1070, (double)this.getEnergy() / 1.0E9, this.getEnergy())).map(class_2561::method_43470).toList();
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return Collections.unmodifiableList(this.enchantments);
    }

    @Override
    public EnergyConfigAccessor getAccessor() {
        return QuarryEnergyConfigAccessor.INSTANCE;
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    public class_2561 method_5476() {
        return this.method_11010().method_26204().method_9518();
    }

    public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
        return new QuarryMenu(i, player, this.method_11016());
    }
}

