/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.quarry.DigTarget;
import com.yogpc.qp.machines.quarry.FrameInsideTarget;
import com.yogpc.qp.machines.quarry.FrameTarget;
import com.yogpc.qp.machines.quarry.PosesTarget;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Target {
    @Nullable
    public abstract class_2338 get(boolean var1);

    public final class_2338 goNextAndGet() {
        this.get(true);
        return this.get(false);
    }

    @NotNull
    public abstract Stream<class_2338> allPoses();

    @NotNull
    protected abstract class_2487 toNbt();

    public static class_2487 toNbt(Target target) {
        class_2487 tag = target.toNbt();
        tag.method_10582("target", target.getClass().getSimpleName());
        return tag;
    }

    public static Target fromNbt(class_2487 tag) {
        return switch (tag.method_10558("target")) {
            case "DigTarget" -> DigTarget.from(tag);
            case "FrameTarget" -> FrameTarget.from(tag);
            case "PosesTarget" -> PosesTarget.from(tag);
            case "FrameInsideTarget" -> FrameInsideTarget.from(tag);
            default -> {
                if (QuarryPlus.config.common.debug) {
                    throw new IllegalArgumentException("Invalid target nbt. " + tag);
                }
                QuarryPlus.LOGGER.error("Invalid target nbt in Quarry Target. %s".formatted(tag));
                yield null;
            }
        };
    }

    public static Target newFrameTarget(Area area) {
        return new FrameTarget(area);
    }

    public static Target newDigTarget(Area area, int y) {
        return new DigTarget(area, y);
    }

    public static Target newFrameInside(Area area, int minY, int maxY) {
        return new FrameInsideTarget(area, minY, maxY);
    }

    @Nullable
    public static Target nextY(@Nullable Target previous, Area area, int digMinY) {
        if (previous instanceof DigTarget) {
            DigTarget digTarget = (DigTarget)previous;
            int nextY = digTarget.y - 1;
            if (digMinY < nextY && nextY <= area.maxY()) {
                return Target.newDigTarget(digTarget.area, nextY);
            }
            return null;
        }
        if (previous instanceof PosesTarget) {
            PosesTarget posesTarget = (PosesTarget)previous;
            int nextY = posesTarget.allPoses().mapToInt(class_2382::method_10264).max().orElse(area.minY()) - 1;
            if (digMinY < nextY && nextY <= area.maxY()) {
                return Target.newDigTarget(area, nextY);
            }
            return null;
        }
        return Target.newDigTarget(area, area.minY());
    }

    @NotNull
    public static Target poses(List<class_2338> pos) {
        return new PosesTarget(pos);
    }

    static String posToStr(@Nullable class_2338 pos) {
        if (pos == null) {
            return "NULL POS";
        }
        return "{x=" + pos.method_10263() + ", y=" + pos.method_10264() + ", z=" + pos.method_10260() + "}";
    }
}

