/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.quarry.StateConditions;
import com.yogpc.qp.machines.quarry.Target;
import com.yogpc.qp.machines.quarry.TileQuarry;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5558;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum QuarryState implements class_5558<TileQuarry>
{
    FINISHED(false){

        @Override
        public void tick(class_1937 world, class_2338 quarryPos, class_2680 state, TileQuarry quarry) {
        }
    }
    ,
    WAITING(false){

        @Override
        public void tick(class_1937 world, class_2338 quarryPos, class_2680 state, TileQuarry quarry) {
            if (quarry.getArea() != null && quarry.getEnergy() > quarry.getMaxEnergy() / 200L) {
                quarry.setState(BREAK_INSIDE_FRAME, state);
            }
        }
    }
    ,
    BREAK_INSIDE_FRAME(true){

        @Override
        public void tick(class_1937 world, class_2338 quarryPos, class_2680 state, TileQuarry quarry) {
            class_2338 targetPos;
            if (world.method_8510() % (long)3.headInterval(quarry) != 0L) {
                return;
            }
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newFrameInside(quarry.getArea(), quarry.getArea().minY(), quarry.getArea().maxY());
                QuarryPlus.LOGGER.debug(MARKER, "Quarry({}) Target changed to {} in {}.", (Object)quarryPos, (Object)quarry.target, (Object)this.name());
            }
            if ((targetPos = QuarryState.dropUntilPos(quarry.target, StateConditions.skipNoBreak(quarry))) == null) {
                quarry.target = null;
                quarry.setState(MAKE_FRAME, state);
                return;
            }
            if (!quarry.getTargetWorld().method_8316(targetPos).method_15769()) {
                if (quarry.quarryConfig.removeFluid()) {
                    quarry.setState(REMOVE_FLUID, state);
                } else {
                    quarry.target.get(true);
                }
            } else if (quarry.breakBlock(targetPos).isSuccess()) {
                quarry.target.get(true);
            }
        }
    }
    ,
    MAKE_FRAME(true){

        @Override
        public void tick(class_1937 world, class_2338 quarryPos, class_2680 state, TileQuarry quarry) {
            class_2338 targetPos;
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newFrameTarget(quarry.getArea());
                QuarryPlus.LOGGER.debug(MARKER, "Quarry({}) Target changed to {} in {}.", (Object)quarryPos, (Object)quarry.target, (Object)this.name());
            }
            if ((targetPos = QuarryState.dropUntilPos(quarry.target, StateConditions.skipFramePlace(quarry))) == null) {
                quarry.setState(MOVE_HEAD, state);
            } else {
                BreakResult breakResult = quarry.breakBlock(targetPos);
                if (breakResult.isSuccess() && quarry.useEnergy(PowerTile.Constants.getMakeFrameEnergy(quarry), PowerTile.Reason.MAKE_FRAME, false)) {
                    quarry.getTargetWorld().method_8501(targetPos, QuarryPlus.ModObjects.BLOCK_FRAME.method_9564());
                }
            }
        }
    }
    ,
    MOVE_HEAD(true){

        @Override
        public void tick(class_1937 world, class_2338 quarryPos, class_2680 state, TileQuarry quarry) {
            class_2338 blockTarget;
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newDigTarget(quarry.getArea(), quarry.getArea().minY());
                QuarryPlus.LOGGER.debug(MARKER, "Quarry({}) Target changed to {} in {}.", (Object)quarryPos, (Object)quarry.target, (Object)this.name());
            }
            if ((blockTarget = QuarryState.dropUntilPos(quarry.target, StateConditions.skipNoBreak(quarry))) == null) {
                List<class_2338> fluidPoses = quarry.target.allPoses().filter(p -> !quarry.getTargetWorld().method_8316(p).method_15769()).map(class_2338::method_10062).toList();
                if (!quarry.quarryConfig.removeFluid() || fluidPoses.isEmpty()) {
                    quarry.target = Target.nextY(quarry.target, quarry.getArea(), quarry.digMinY);
                    QuarryPlus.LOGGER.debug(MARKER, "Quarry({}) Target changed to {} in {}.", (Object)quarryPos, (Object)quarry.target, (Object)this.name());
                    if (quarry.target != null) {
                        this.tick(world, quarryPos, state, quarry);
                    } else {
                        quarry.setState(FINISHED, state);
                    }
                } else {
                    quarry.target = Target.poses(fluidPoses);
                    quarry.setState(REMOVE_FLUID, state);
                }
            } else {
                class_243 difference = new class_243((double)blockTarget.method_10263() - quarry.headX, (double)blockTarget.method_10264() - quarry.headY, (double)blockTarget.method_10260() - quarry.headZ);
                double squaredDistance = difference.method_1027();
                if (squaredDistance > 1.0E-8) {
                    double moveDistance = Math.min(squaredDistance, quarry.headSpeed());
                    long required = PowerTile.Constants.getMoveEnergy(Math.sqrt(moveDistance), quarry);
                    if (!quarry.useEnergy(required, PowerTile.Reason.MOVE_HEAD, false)) {
                        return;
                    }
                    class_243 normalized = difference.method_1029();
                    quarry.headX += normalized.method_10216() * Math.sqrt(moveDistance);
                    quarry.headY += normalized.method_10214() * Math.sqrt(moveDistance);
                    quarry.headZ += normalized.method_10215() * Math.sqrt(moveDistance);
                    quarry.sync();
                }
                if (blockTarget.method_40081(quarry.headX, quarry.headY, quarry.headZ) <= 1.0E-8) {
                    BREAK_BLOCK.tick(world, quarryPos, state, quarry);
                }
            }
        }
    }
    ,
    BREAK_BLOCK(true){

        @Override
        public void tick(class_1937 world, class_2338 quarryPos, class_2680 state, TileQuarry quarry) {
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newDigTarget(quarry.getArea(), quarry.getArea().minY());
                QuarryPlus.LOGGER.debug(MARKER, "Quarry({}) Target changed to {} in {}.", (Object)quarryPos, (Object)quarry.target, (Object)this.name());
            }
            if (!quarry.getTargetWorld().method_8316(Objects.requireNonNull(quarry.target.get(false))).method_15769()) {
                if (quarry.quarryConfig.removeFluid()) {
                    quarry.setState(REMOVE_FLUID, state);
                } else {
                    quarry.target.get(true);
                }
            } else if (quarry.breakBlock(Objects.requireNonNull(quarry.target.get(false))).isSuccess()) {
                quarry.target.get(true);
                quarry.setState(MOVE_HEAD, state);
            } else {
                quarry.setState(BREAK_BLOCK, state);
            }
        }
    }
    ,
    REMOVE_FLUID(true){

        @Override
        public void tick(class_1937 world, class_2338 quarryPos, class_2680 state, TileQuarry quarry) {
            Objects.requireNonNull(quarry.getArea());
            if (quarry.target == null) {
                quarry.target = Target.newDigTarget(quarry.getArea(), quarry.getArea().minY());
                QuarryPlus.LOGGER.debug(MARKER, "Quarry({}) Target changed to {} in {}.", (Object)quarryPos, (Object)quarry.target, (Object)this.name());
            }
            class_2338 original = Objects.requireNonNull(quarry.target.get(false));
            class_3218 targetWorld = quarry.getTargetWorld();
            Set<class_2338> fluidPoses = QuarryState.countFluid((class_1937)targetWorld, original, quarry.getArea());
            if (quarry.useEnergy(PowerTile.Constants.getBreakBlockFluidEnergy(quarry) * (long)fluidPoses.size(), PowerTile.Reason.REMOVE_FLUID, true)) {
                for (class_2338 fluidPos : fluidPoses) {
                    class_2680 blockState = targetWorld.method_8320(fluidPos);
                    if (blockState.method_26204() instanceof class_2404) {
                        fluidState = targetWorld.method_8316(fluidPos);
                        if (!fluidState.method_15769() && fluidState.method_15771()) {
                            quarry.storage.addFluid(fluidState.method_15772(), 1000L);
                        }
                        targetWorld.method_8652(fluidPos, class_2246.field_10124.method_9564(), 2);
                    } else {
                        fluidState = blockState.method_26204();
                        if (fluidState instanceof class_2263) {
                            class_2263 drain = (class_2263)fluidState;
                            class_1799 bucket = drain.method_9700((class_1936)targetWorld, fluidPos, blockState);
                            quarry.storage.addFluid(bucket);
                        } else {
                            targetWorld.method_8652(fluidPos, class_2246.field_10124.method_9564(), 2);
                        }
                    }
                    TileQuarry.checkEdgeFluid(fluidPos, false, targetWorld, quarry);
                }
                quarry.setState(BREAK_BLOCK, state);
            }
        }
    };

    public final boolean isWorking;
    private static final Marker MARKER;

    private QuarryState(boolean isWorking) {
        this.isWorking = isWorking;
    }

    public abstract void tick(class_1937 var1, class_2338 var2, class_2680 var3, TileQuarry var4);

    @Nullable
    private static class_2338 dropUntilPos(Target target, Predicate<class_2338> condition) {
        class_2338 pos = target.get(false);
        while (pos != null && condition.test(pos)) {
            pos = target.goNextAndGet();
        }
        return pos;
    }

    private static Set<class_2338> countFluid(class_1937 world, class_2338 originalPos, Area area) {
        HashSet<class_2338> counted = new HashSet<class_2338>();
        EnumSet<class_2350> directions = EnumSet.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034, class_2350.field_11036);
        Set<class_2338> search = Set.of(originalPos);
        HashSet<class_2338> checked = new HashSet<class_2338>(area.sizeOfEachY());
        while (!search.isEmpty()) {
            HashSet<class_2338> nextSearch = new HashSet<class_2338>();
            for (class_2338 pos : search) {
                checked.add(pos);
                if (world.method_8316(pos).method_15769() || !counted.add(pos)) continue;
                directions.stream().map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).filter(area::isInAreaIgnoreY).filter(Predicate.not(checked::contains)).forEach(nextSearch::add);
            }
            search = nextSearch;
        }
        return counted;
    }

    static int headInterval(TileQuarry quarry) {
        return (int)Math.ceil(1.0 / quarry.headSpeed());
    }

    static {
        MARKER = MarkerManager.getMarker((String)"QuarryState");
    }
}

