/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.quarry.Target;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FrameTarget
extends Target {
    final Area area;
    private final Iterator<class_2338> iterator;
    @Nullable
    private class_2338 currentTarget;

    FrameTarget(Area area) {
        this.area = area;
        this.iterator = this.getPosStream(area).iterator();
        this.currentTarget = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    FrameTarget(Area area, class_2338 pre) {
        this.area = area;
        this.iterator = this.getPosStream(area).dropWhile(p -> !p.equals((Object)pre)).iterator();
        this.currentTarget = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    @NotNull
    private Stream<class_2338> getPosStream(Area area) {
        return Stream.of(FrameTarget.makeSquare(area, area.minY()), FrameTarget.makePole(area, area.minY() + 1, area.maxY()), FrameTarget.makeSquare(area, area.maxY())).flatMap(Function.identity());
    }

    @Override
    @Nullable
    public class_2338 get(boolean goNext) {
        class_2338 pre = this.currentTarget;
        if (goNext) {
            this.currentTarget = this.iterator.hasNext() ? this.iterator.next() : null;
        }
        return pre;
    }

    @Override
    @NotNull
    public Stream<class_2338> allPoses() {
        return this.getPosStream(this.area);
    }

    @Override
    @NotNull
    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10566("area", (class_2520)this.area.toNBT());
        tag.method_10544("currentTarget", Objects.requireNonNullElse(this.currentTarget, new class_2338(this.area.minX(), this.area.maxY(), this.area.minZ() + 1)).method_10063());
        return tag;
    }

    static FrameTarget from(class_2487 tag) {
        return new FrameTarget(Area.fromNBT(tag.method_10562("area")).orElseThrow(), class_2338.method_10092((long)tag.method_10537("currentTarget")));
    }

    static Stream<class_2338> makeSquare(Area area, int y) {
        return Stream.of(IntStream.rangeClosed(area.minX(), area.maxX()).mapToObj(x -> new class_2338(x, y, area.minZ())), IntStream.rangeClosed(area.minZ(), area.maxZ()).mapToObj(z -> new class_2338(area.maxX(), y, z)), IntStream.iterate(area.maxX(), x -> x >= area.minX(), x -> x - 1).mapToObj(x -> new class_2338(x, y, area.maxZ())), IntStream.iterate(area.maxZ(), z -> z >= area.minZ(), z -> z - 1).mapToObj(z -> new class_2338(area.minX(), y, z))).flatMap(Function.identity());
    }

    static Stream<class_2338> makePole(Area area, int yMin, int yMax) {
        return IntStream.rangeClosed(yMin, yMax).boxed().flatMap(y -> Stream.of(new class_2338(area.minX(), y.intValue(), area.minZ()), new class_2338(area.maxX(), y.intValue(), area.minZ()), new class_2338(area.maxX(), y.intValue(), area.maxZ()), new class_2338(area.minX(), y.intValue(), area.maxZ())));
    }

    public String toString() {
        return "FrameTarget{area=" + this.area + ", currentTarget=" + FrameTarget.posToStr(this.currentTarget) + ", hasNext=" + this.iterator.hasNext() + "}";
    }
}

