/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.quarry.Target;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FrameInsideTarget
extends Target {
    private final Area area;
    private final int minY;
    private final int maxY;
    private int index = 0;

    FrameInsideTarget(Area area, int minY, int maxY) {
        this.area = area;
        this.minY = minY;
        this.maxY = maxY;
    }

    @Override
    @Nullable
    public class_2338 get(boolean goNext) {
        int zSize;
        int xSize = this.area.maxX() - this.area.minX() - 1;
        int areaSize = xSize * (zSize = this.area.maxZ() - this.area.minZ() - 1);
        int y = this.maxY - this.index / areaSize;
        if (y < this.minY) {
            return null;
        }
        int xz = this.index % areaSize;
        int x = this.area.minX() + 1 + xz / zSize;
        int z = this.area.minZ() + 1 + xz % zSize;
        if (goNext) {
            ++this.index;
        }
        return new class_2338(x, y, z);
    }

    @Override
    @NotNull
    public Stream<class_2338> allPoses() {
        return class_2338.method_17962((int)(this.area.minX() + 1), (int)this.minY, (int)(this.area.minZ() + 1), (int)(this.area.maxX() - 1), (int)this.maxY, (int)(this.area.maxZ() - 1));
    }

    @Override
    @NotNull
    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10566("area", (class_2520)this.area.toNBT());
        tag.method_10569("minY", this.minY);
        tag.method_10569("maxY", this.maxY);
        tag.method_10569("index", this.index);
        return tag;
    }

    public static FrameInsideTarget from(class_2487 tag) {
        Area area = Area.fromNBT(tag.method_10562("area")).orElseThrow();
        int minY = tag.method_10550("minY");
        int maxY = tag.method_10550("maxY");
        int index = tag.method_10550("index");
        FrameInsideTarget t = new FrameInsideTarget(area, minY, maxY);
        t.index = index;
        return t;
    }

    public String toString() {
        return "FrameInsideTarget{area=" + this.area + ", minY=" + this.minY + ", maxY=" + this.maxY + ", index=" + this.index + "}";
    }
}

