/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.wrench.WrenchItems;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.Direction8;
import com.yogpc.qp.machines.EnchantedLootFunction;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.machines.quarry.BlockFrame;
import com.yogpc.qp.machines.quarry.ItemQuarry;
import com.yogpc.qp.machines.quarry.QuarryLootFunction;
import com.yogpc.qp.machines.quarry.QuarryState;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.utils.CombinedBlockEntityTicker;
import com.yogpc.qp.utils.MapMulti;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_5558;

public class BlockQuarry
extends QPBlock
implements class_2343 {
    public static final String NAME = "quarry";

    public BlockQuarry() {
        super(FabricBlockSettings.create().mapColor(class_3620.field_16005).method_50012(class_3619.field_15972).method_9629(1.5f, 10.0f).method_9626(class_2498.field_11544).method_29292(), NAME, ItemQuarry::new);
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11043)).method_11657((class_2769)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return QuarryPlus.ModObjects.QUARRY_TYPE.method_11032(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : BlockQuarry.createTickerHelper(type, QuarryPlus.ModObjects.QUARRY_TYPE, new CombinedBlockEntityTicker(PowerTile.getGenerator(), TileQuarry::tick, PowerTile.logTicker(), MachineStorage.passItems(), MachineStorage.passFluid()));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{class_2741.field_12525, WORKING});
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        super.method_9567(level, pos, state, entity, stack);
        if (!level.field_9236) {
            class_2350 facing = entity == null ? class_2350.field_11043 : entity.method_5735().method_10153();
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)class_25862;
                quarry.setEnchantments(class_1890.method_8222((class_1799)stack));
                quarry.setTileDataFromItem(class_1747.method_38072((class_1799)stack));
                Area area = BlockQuarry.findArea(level, pos, facing.method_10153(), quarry.storage::addItem);
                if (area.maxX() - area.minX() > 1 && area.maxZ() - area.minZ() > 1) {
                    quarry.setState(QuarryState.WAITING, (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)facing));
                    quarry.setArea(area);
                    quarry.sync();
                } else if (entity instanceof class_1657) {
                    class_1657 player = (class_1657)entity;
                    player.method_7353((class_2561)class_2561.method_43471((String)"quarryplus.chat.warn_area"), false);
                }
                boolean preForced = QuarryChunkLoadUtil.makeChunkLoaded(level, pos);
                quarry.setChunkPreLoaded(preForced);
            }
        }
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204()) && QuarryPlus.config.common.removeFrameAfterQuarryIsRemoved) {
            for (Direction8 dir : Direction8.DIRECTIONS) {
                class_2338 offset = pos.method_10081(dir.vec());
                class_2680 maybeFrame = level.method_8320(offset);
                if (!maybeFrame.method_27852((class_2248)QuarryPlus.ModObjects.BLOCK_FRAME) || ((Boolean)maybeFrame.method_11654((class_2769)BlockFrame.DAMMING)).booleanValue()) continue;
                level.method_8650(offset, false);
            }
        }
        super.method_9536(state, level, pos, newState, moved);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 stack = player.method_5998(hand);
        if (WrenchItems.isWrenchItem(stack)) {
            class_2586 class_25862;
            if (!world.field_9236 && (class_25862 = world.method_8321(pos)) instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)class_25862;
                quarry.setState(QuarryState.WAITING, state);
                quarry.target = null;
            }
            return class_1269.field_5812;
        }
        if (!player.method_5715()) {
            class_2586 class_25863;
            if (!world.field_9236 && (class_25863 = world.method_8321(pos)) instanceof TileQuarry) {
                TileQuarry quarry = (TileQuarry)class_25863;
                player.method_17355((class_3908)quarry);
            }
            return class_1269.field_5812;
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(world, pos, state);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TileQuarry) {
            TileQuarry quarry = (TileQuarry)class_25862;
            QuarryLootFunction.process(stack, quarry);
            EnchantedLootFunction.process(stack, quarry);
        }
        return stack;
    }

    static Area findArea(class_1937 world, class_2338 pos, class_2350 quarryBehind, Consumer<class_1799> itemCollector) {
        return Stream.of(quarryBehind, quarryBehind.method_10160(), quarryBehind.method_10170()).map(arg_0 -> ((class_2338)pos).method_10093(arg_0)).map(arg_0 -> ((class_1937)world).method_8321(arg_0)).mapMulti(MapMulti.cast(QuarryMarker.class)).flatMap(m -> m.getArea().stream().peek(a -> m.removeAndGetItems().forEach(itemCollector))).findFirst().map(a -> a.assureY(4)).orElse(new Area((class_2382)pos.method_10093(quarryBehind).method_10079(quarryBehind.method_10160(), 5), (class_2382)pos.method_10079(quarryBehind, 11).method_10079(quarryBehind.method_10170(), 5).method_10079(class_2350.field_11036, 4), quarryBehind));
    }
}

