/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.mojang.authlib.GameProfile;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.QuarryItemTransfer;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryFakePlayer;
import com.yogpc.qp.machines.placer.PlacerBlock;
import com.yogpc.qp.machines.placer.PlacerContainer;
import com.yogpc.qp.packet.ClientSync;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class PlacerTile
extends class_2586
implements class_1263,
CheckerLog,
ExtendedScreenHandlerFactory,
ClientSync {
    public static final String KEY_ITEM = "items";
    public static final String KEY_LAST_PLACED = "last_placed";
    public static final String KEY_RS_MODE = "redstone_mode";
    public static final Map<class_2350, class_243> DIRECTION_VEC3D_MAP;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
    private int lastPlacedIndex = 0;
    public RedstoneMode redstoneMode = RedstoneMode.PULSE;
    private static final int PULSE_ID = 0;
    private static final int RS_IGNORE_ID = 1;
    private static final int RS_ON_ID = 2;
    private static final int RS_OFF_ID = 3;

    public PlacerTile(class_2338 pos, class_2680 state) {
        super(QuarryPlus.ModObjects.PLACER_TYPE, pos, state);
    }

    protected PlacerTile(class_2591<?> entityType, class_2338 pos, class_2680 state) {
        super(entityType, pos, state);
    }

    public void tick() {
        if (this.field_11863 != null && !this.field_11863.field_9236 && this.redstoneMode.isAlways() && this.redstoneMode.shouldWork(this::isPowered)) {
            if (this.field_11863.method_8320(this.getTargetPos()).method_26215()) {
                this.placeBlock();
            } else {
                this.breakBlock();
            }
        }
    }

    protected class_2338 getTargetPos() {
        return this.method_11016().method_10093(this.getMachineFacing());
    }

    protected class_2350 getMachineFacing() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
    }

    protected boolean isPowered() {
        return PlacerBlock.isPoweredToWork(this.field_11863, this.method_11016(), this.getMachineFacing());
    }

    public void breakBlock() {
        if (this.field_11863 == null || !this.redstoneMode.canBreak()) {
            return;
        }
        class_2338 pos = this.getTargetPos();
        class_2680 state = this.field_11863.method_8320(pos);
        if (state.method_26214((class_1922)this.field_11863, pos) < 0.0f) {
            return;
        }
        List drops = class_2248.method_9609((class_2680)state, (class_3218)((class_3218)this.field_11863), (class_2338)pos, (class_2586)this.field_11863.method_8321(pos), null, (class_1799)PlacerTile.getSilkPickaxe());
        this.field_11863.method_8650(pos, false);
        drops.stream().map(s -> QuarryItemTransfer.transfer(this.method_10997(), this.method_11016(), s, class_2350.field_11036)).filter(Predicate.not(class_1799::method_7960)).forEach(s -> class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.method_11016(), (class_1799)s));
    }

    public void placeBlock() {
        if (this.method_5442() || !this.redstoneMode.canPlace()) {
            return;
        }
        class_2350 facing = this.getMachineFacing();
        class_2338 pos = this.getTargetPos();
        PlacerTile.findEntry(this.inventory, i -> PlacerTile.isItemPlaceable(i, this.method_10997(), pos, facing), this.lastPlacedIndex).ifPresent(i -> {
            this.lastPlacedIndex = !this.method_5438(i).method_7960() ? i : PlacerTile.findEntry(this.inventory, s -> !s.method_7960() && s.method_7909() instanceof class_1747, i).orElse(0);
            this.method_5431();
            this.sendPacket();
        });
    }

    public static <T> OptionalInt findEntry(List<T> check, Predicate<T> filter, int startIndex) {
        int listSize = check.size();
        if (startIndex >= listSize) {
            return OptionalInt.empty();
        }
        return PlacerTile.findEntryInternal(check, filter, startIndex, startIndex, listSize);
    }

    private static <T> OptionalInt findEntryInternal(List<T> check, Predicate<T> filter, int startIndex, int index, int listSize) {
        T value = check.get(index);
        if (filter.test(value)) {
            return OptionalInt.of(index);
        }
        if (index == startIndex - 1 || startIndex == 0 && index == listSize - 1) {
            return OptionalInt.empty();
        }
        int next = index + 1 == listSize ? 0 : index + 1;
        return PlacerTile.findEntryInternal(check, filter, startIndex, next, listSize);
    }

    public static boolean isItemPlaceable(class_1799 stack, class_1937 level, class_2338 pos, class_2350 tileDirection) {
        if (stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            FakePlayer player = FakePlayer.get((class_3218)((class_3218)level), (GameProfile)QuarryFakePlayer.PROFILE);
            QuarryFakePlayer.setDirection((class_3222)player, tileDirection);
            class_3965 hitResult = new class_3965(class_243.method_24955((class_2382)pos), tileDirection.method_10153(), pos, false);
            class_1750 context = new class_1750((class_1657)player, class_1268.field_5808, stack, hitResult);
            return blockItem.method_7712(context).method_23665();
        }
        return false;
    }

    public int getLastPlacedIndex() {
        return this.lastPlacedIndex;
    }

    void sendPacket() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.sync();
        }
    }

    private static class_1799 getSilkPickaxe() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8377);
        stack.method_7978(class_1893.field_9099, 1);
        return stack;
    }

    public void method_11007(class_2487 compound) {
        compound.method_10566(KEY_ITEM, (class_2520)class_1262.method_5426((class_2487)new class_2487(), this.inventory));
        compound.method_10569(KEY_LAST_PLACED, this.lastPlacedIndex);
        compound.method_10582(KEY_RS_MODE, this.redstoneMode.name());
        super.method_11007(compound);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        class_1262.method_5429((class_2487)compound.method_10562(KEY_ITEM), this.inventory);
        this.lastPlacedIndex = compound.method_10550(KEY_LAST_PLACED);
        try {
            this.redstoneMode = RedstoneMode.valueOf(compound.method_10558(KEY_RS_MODE));
        }
        catch (IllegalArgumentException e) {
            QuarryPlus.LOGGER.error("Illegal name(%s) was passed to placer mode.".formatted(compound.method_10558(KEY_RS_MODE)), (Throwable)e);
            this.redstoneMode = RedstoneMode.PULSE;
        }
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public void fromClientTag(class_2487 tag) {
        this.method_11014(tag);
    }

    @Override
    public class_2487 toClientTag(class_2487 tag) {
        return this.method_38244();
    }

    public class_2561 method_5476() {
        return this.method_11010().method_26204().method_9518();
    }

    @Override
    public List<? extends class_2561> getDebugLogs() {
        return Stream.of("RS Mode: " + this.redstoneMode.toString(), "Last Placed: " + this.getLastPlacedIndex(), "Target: " + this.getTargetPos(), "Inv: " + this.inventory.stream().filter(s -> !s.method_7960()).count()).map(class_2561::method_43470).collect(Collectors.toList());
    }

    public int method_5439() {
        return 9;
    }

    public boolean method_5442() {
        return this.inventory.stream().allMatch(class_1799::method_7960);
    }

    public class_1799 method_5438(int index) {
        if (index >= 0 && index < this.method_5439()) {
            return (class_1799)this.inventory.get(index);
        }
        return class_1799.field_8037;
    }

    public class_1799 method_5434(int index, int count) {
        return class_1262.method_5430(this.inventory, (int)index, (int)count);
    }

    public class_1799 method_5441(int index) {
        return class_1262.method_5428(this.inventory, (int)index);
    }

    public void method_5447(int index, class_1799 stack) {
        if (index >= 0 && index < this.method_5439()) {
            this.inventory.set(index, (Object)stack);
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.field_11863 != null && this.method_11016().method_19770((class_2374)player.method_19538()) < 64.0;
    }

    public void method_5448() {
        this.inventory.clear();
    }

    public int method_5444() {
        return 64;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public PlacerContainer createMenu(int id, class_1661 p, class_1657 player) {
        return new PlacerContainer(id, player, this.method_11016(), this.getClass());
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.cycle(this.redstoneMode);
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.sendPacket();
        }
    }

    static {
        EnumMap<class_2350, class_243> map = new EnumMap<class_2350, class_243>(class_2350.class);
        map.put(class_2350.field_11033, new class_243(0.5, 0.0, 0.5));
        map.put(class_2350.field_11036, new class_243(0.5, 1.0, 0.5));
        map.put(class_2350.field_11043, new class_243(0.5, 0.5, 0.0));
        map.put(class_2350.field_11035, new class_243(0.5, 0.5, 1.0));
        map.put(class_2350.field_11034, new class_243(1.0, 0.5, 0.5));
        map.put(class_2350.field_11039, new class_243(0.0, 0.5, 0.5));
        DIRECTION_VEC3D_MAP = Collections.unmodifiableMap(map);
    }

    public static enum RedstoneMode {
        PULSE(0, true, true),
        PULSE_PLACE_ONLY(0, true, false),
        PULSE_BREAK_ONLY(0, false, true);

        private final int modeID;
        private final boolean placeEnabled;
        private final boolean breakEnabled;

        private RedstoneMode(int modeID, boolean placeEnabled, boolean breakEnabled) {
            this.modeID = modeID;
            this.placeEnabled = placeEnabled;
            this.breakEnabled = breakEnabled;
        }

        public String toString() {
            return this.name().replace('_', ' ');
        }

        public boolean isAlways() {
            return this.modeID == 1 || this.modeID == 2 || this.modeID == 3;
        }

        public boolean isPulse() {
            return this.modeID == 0;
        }

        public boolean canPlace() {
            return this.placeEnabled;
        }

        public boolean canBreak() {
            return this.breakEnabled;
        }

        public boolean isRsOn() {
            return this.modeID == 2;
        }

        public boolean isRsOff() {
            return this.modeID == 3;
        }

        public boolean shouldWork(BooleanSupplier powered) {
            if (this.isRsOn()) {
                return powered.getAsBoolean();
            }
            if (this.isRsOff()) {
                return !powered.getAsBoolean();
            }
            return true;
        }

        public static RedstoneMode cycle(RedstoneMode now) {
            RedstoneMode[] modes = RedstoneMode.values();
            for (int i = 0; i < modes.length; ++i) {
                RedstoneMode mode = modes[i];
                if (mode != now) continue;
                if (i + 1 == modes.length) {
                    return modes[0];
                }
                return modes[i + 1];
            }
            return modes[0];
        }
    }
}

