/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.RenderMarker;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileMarker
extends class_2586
implements QuarryMarker,
CheckerLog,
ClientSync {
    public static final int MAX_SEARCH = 256;
    private MarkerConnection markerConnection = MarkerConnection.EMPTY;
    @Nullable
    private RenderBox renderBox;
    public boolean rsReceiving;

    public TileMarker(class_2338 pos, class_2680 state) {
        super(QuarryPlus.ModObjects.MARKER_TYPE, pos, state);
    }

    void tryConnect(boolean first) {
        assert (this.method_10997() != null);
        Optional zMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> this.method_11016().method_10079(class_2350.field_11043, i)).flatMap(p -> this.method_10997().method_35230(p, QuarryPlus.ModObjects.MARKER_TYPE).stream()).findFirst();
        Optional xMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).mapToObj(i -> this.method_11016().method_10079(class_2350.field_11034, i)).flatMap(p -> this.method_10997().method_35230(p, QuarryPlus.ModObjects.MARKER_TYPE).stream()).findFirst();
        Optional yMarker = IntStream.range(1, 256).flatMap(i -> IntStream.of(i, -i)).filter(y -> !this.method_10997().method_31601(y)).boxed().flatMap(y -> Stream.concat(Stream.of(this.method_11016()), Stream.concat(xMarker.stream(), zMarker.stream()).map(class_2586::method_11016)).map(p -> p.method_30513(class_2350.class_2351.field_11052, y.intValue())).flatMap(p -> this.method_10997().method_35230(p, QuarryPlus.ModObjects.MARKER_TYPE).stream())).findFirst();
        MarkerConnection.set(this, xMarker.orElse(null), zMarker.orElse(null), yMarker.orElse(null));
        if (first && this.markerConnection == MarkerConnection.EMPTY) {
            xMarker.ifPresent(marker -> marker.tryConnect(false));
        }
        if (first && this.markerConnection == MarkerConnection.EMPTY) {
            zMarker.ifPresent(marker -> marker.tryConnect(false));
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.markerConnection.markerPlaces().stream().flatMap(p -> this.field_11863.method_35230(p, QuarryPlus.ModObjects.MARKER_TYPE).stream()).forEach(TileMarker::resetConnection);
        }
    }

    private static void resetConnection(TileMarker m) {
        m.markerConnection = MarkerConnection.EMPTY;
        m.sync();
    }

    @Override
    public Optional<Area> getArea() {
        return this.markerConnection.getArea();
    }

    @Environment(value=EnvType.CLIENT)
    public Optional<Box[]> renderArea() {
        if (this.markerConnection.render()) {
            if (this.renderBox == null || this.renderBox.parent != this.markerConnection) {
                if (this.markerConnection.area != null) {
                    this.renderBox = new RenderBox(this.markerConnection, RenderMarker.getRenderBox(this.markerConnection.area));
                    return Optional.of(this.renderBox.boxes);
                }
                return Optional.empty();
            }
            return Optional.of(this.renderBox.boxes);
        }
        return Optional.empty();
    }

    @Override
    public List<class_1799> removeAndGetItems() {
        assert (this.method_10997() != null);
        List<class_1799> drops = this.markerConnection.markerPlaces().stream().map(arg_0 -> ((class_1937)this.method_10997()).method_8320(arg_0)).map(class_4970.class_4971::method_26204).map(class_1799::new).toList();
        this.markerConnection.markerPlaces().forEach(p -> this.method_10997().method_8650(p, false));
        return drops;
    }

    @Override
    public List<? extends class_2561> getDebugLogs() {
        return List.of(class_2561.method_43470((String)"%sMarker Area%s: %s".formatted(class_124.field_1075, class_124.field_1070, this.markerConnection.getArea())), this.renderBox != null ? class_2561.method_43470((String)"%sRender%s: IsParent %b, Box %d".formatted(class_124.field_1075, class_124.field_1070, this.renderBox.parent == this.markerConnection, Stream.of(this.renderBox.boxes).filter(Objects::nonNull).count())) : class_2561.method_43470((String)"%sRender%s: null".formatted(class_124.field_1075, class_124.field_1070)), class_2561.method_43470((String)"%sMarker Poses%s: %s".formatted(class_124.field_1075, class_124.field_1070, this.markerConnection.markerPlaces())));
    }

    @Override
    public void fromClientTag(class_2487 tag) {
        this.markerConnection = MarkerConnection.fromClientNbt(tag.method_10562("markerConnection"));
        this.rsReceiving = tag.method_10577("rsReceiving");
    }

    @Override
    public class_2487 toClientTag(class_2487 tag) {
        tag.method_10566("markerConnection", (class_2520)this.markerConnection.toClientNbt());
        tag.method_10556("rsReceiving", this.rsReceiving);
        return tag;
    }

    record MarkerConnection(@Nullable Area area, @NotNull Set<class_2338> markerPlaces, boolean render) {
        static final MarkerConnection EMPTY = new MarkerConnection(null, Collections.emptySet(), false);

        static void set(TileMarker thisMarker, @Nullable TileMarker xMarker, @Nullable TileMarker zMarker, @Nullable TileMarker yMarker) {
            if (xMarker != null && zMarker != null) {
                Area area = new Area((class_2382)xMarker.method_11016(), (class_2382)(yMarker != null ? zMarker.method_11016().method_33096(yMarker.method_11016().method_10264()) : zMarker.method_11016().method_10086(4)), class_2350.field_11036);
                MarkerConnection connectionParent = new MarkerConnection(area, Set.of(thisMarker.method_11016(), xMarker.method_11016(), zMarker.method_11016()), true);
                MarkerConnection connectionChild = new MarkerConnection(area, Set.of(thisMarker.method_11016(), xMarker.method_11016(), zMarker.method_11016()), false);
                thisMarker.markerConnection = connectionParent;
                xMarker.markerConnection = connectionChild;
                zMarker.markerConnection = connectionChild;
                thisMarker.sync();
                xMarker.sync();
                zMarker.sync();
                if (yMarker != null) {
                    yMarker.markerConnection = connectionChild;
                    yMarker.sync();
                }
            }
        }

        Optional<Area> getArea() {
            return Optional.ofNullable(this.area);
        }

        class_2487 toClientNbt() {
            class_2487 tag = new class_2487();
            if (this.area != null) {
                tag.method_10566("area", (class_2520)this.area.toNBT());
            }
            tag.method_10556("render", this.render);
            return tag;
        }

        static MarkerConnection fromClientNbt(class_2487 tag) {
            Optional area;
            Optional<Object> optional = area = tag.method_10545("area") ? Area.fromNBT(tag.method_10562("area")) : Optional.empty();
            if (area.isEmpty()) {
                return EMPTY;
            }
            return new MarkerConnection(area.orElse(null), Collections.emptySet(), tag.method_10577("render"));
        }
    }

    record RenderBox(MarkerConnection parent, Box[] boxes) {
    }
}

