/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.marker;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.render.Box;
import com.yogpc.qp.render.RenderMarker;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class TileFlexMarker
extends class_2586
implements QuarryMarker,
CheckerLog,
ClientSync {
    private static final int maxRange = 256;
    private class_2338 min;
    private class_2338 max;
    @Nullable
    public Box[] boxes;
    @Nullable
    public Box directionBox;
    public class_2350 direction;

    public TileFlexMarker(class_2338 pos, class_2680 state) {
        super(QuarryPlus.ModObjects.FLEX_MARKER_TYPE, pos, state);
        this.min = pos;
        this.max = pos;
    }

    public void init(class_2350 facing) {
        this.direction = facing;
        this.min = this.method_11016();
        this.max = this.method_11016();
        this.move(Movable.LEFT, 5);
        this.move(Movable.RIGHT, 5);
        this.move(Movable.FORWARD, 10);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.setRender();
        }
    }

    public void move(Movable movable, int amount) {
        assert (this.field_11863 != null);
        class_2350 facing = movable.getActualFacing(this.direction);
        class_2338 offset = this.method_11016();
        if (facing.method_10171() == class_2350.class_2352.field_11056) {
            this.max = this.max.method_10079(facing, amount);
            int d = TileFlexMarker.getDistance(this.max, offset, facing.method_10166());
            if (d > 256) {
                this.max = TileFlexMarker.getLimited(this.max, offset, facing, 256);
            } else if (d < 0) {
                this.max = TileFlexMarker.getLimited(this.max, offset, facing, 0);
            }
        } else {
            this.min = this.min.method_10079(facing, amount);
            int d = TileFlexMarker.getDistance(offset, this.min, facing.method_10166());
            if (d > 256) {
                this.min = TileFlexMarker.getLimited(this.min, offset, facing, 256);
            } else if (d < 0) {
                this.min = TileFlexMarker.getLimited(this.min, offset, facing, 0);
            }
            if (facing == class_2350.field_11033 && this.min.method_10264() < this.field_11863.method_31607()) {
                this.min = new class_2338(this.min.method_10263(), this.field_11863.method_31607(), this.min.method_10260());
            }
        }
    }

    private void setRender() {
        if (this.field_11863 == null) {
            return;
        }
        Area area = new Area((class_2382)this.min, (class_2382)this.max, this.direction);
        this.boxes = RenderMarker.getRenderBox(area);
        double a = 0.5;
        double c = 0.375;
        class_238 bb = this.direction == null ? new class_238((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5) : (this.direction.method_10166() == class_2350.class_2351.field_11048 ? new class_238((double)this.method_11016().method_10263() - 0.375 + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5, (double)this.method_11016().method_10263() + 0.375 + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5) : new class_238((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() - 0.375 + 0.5, (double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.375 + 0.5));
        this.directionBox = Box.apply(bb.method_997(class_243.method_24954((class_2382)this.direction.method_10163()).method_1021(0.5)), 0.125, 0.125, 0.125, true, true);
    }

    public void method_11007(class_2487 compound) {
        compound.method_10544("min", this.min.method_10063());
        compound.method_10544("max", this.max.method_10063());
        compound.method_10582("direction", Optional.ofNullable(this.direction).map(class_2350::toString).orElse(""));
        super.method_11007(compound);
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.min = class_2338.method_10092((long)compound.method_10537("min"));
        this.max = class_2338.method_10092((long)compound.method_10537("max"));
        this.direction = class_2350.method_10168((String)compound.method_10558("direction"));
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.setRender();
        }
    }

    @Override
    public List<? extends class_2561> getDebugLogs() {
        return Stream.of("Direction: " + this.direction, "Min: " + this.min, "Max: " + this.max).map(class_2561::method_43470).toList();
    }

    @Override
    public Optional<Area> getArea() {
        if (this.direction == null) {
            return Optional.empty();
        }
        return Optional.of(new Area((class_2382)this.min, (class_2382)this.max, this.direction));
    }

    @Override
    public List<class_1799> removeAndGetItems() {
        assert (this.field_11863 != null);
        this.field_11863.method_8650(this.field_11867, false);
        return List.of(new class_1799((class_1935)this.method_11010().method_26204()));
    }

    @Override
    public void fromClientTag(class_2487 tag) {
        this.method_11014(tag);
    }

    @Override
    public class_2487 toClientTag(class_2487 tag) {
        return this.method_38242();
    }

    public static int getDistance(class_2338 to, class_2338 from, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> to.method_10263() - from.method_10263();
            case class_2350.class_2351.field_11052 -> to.method_10264() - from.method_10264();
            case class_2350.class_2351.field_11051 -> to.method_10260() - from.method_10260();
        };
    }

    public static class_2338 getLimited(class_2338 to, class_2338 from, class_2350 facing, int limit) {
        return switch (facing.method_10166()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> new class_2338(from.method_10263(), to.method_10264(), to.method_10260()).method_10079(facing, limit);
            case class_2350.class_2351.field_11052 -> new class_2338(to.method_10263(), from.method_10264(), to.method_10260()).method_10079(facing, limit);
            case class_2350.class_2351.field_11051 -> new class_2338(to.method_10263(), to.method_10264(), from.method_10260()).method_10079(facing, limit);
        };
    }

    public static enum Movable {
        UP(facing -> class_2350.field_11036),
        LEFT(class_2350::method_10160),
        FORWARD(UnaryOperator.identity()),
        RIGHT(class_2350::method_10170),
        DOWN(facing -> class_2350.field_11033);

        private final UnaryOperator<class_2350> operator;
        public final String transName;
        private static final Movable[] v;

        private Movable(UnaryOperator<class_2350> operator) {
            this.operator = operator;
            this.transName = "gui." + this.name().toLowerCase(Locale.ROOT);
        }

        public class_2350 getActualFacing(class_2350 facing) {
            return (class_2350)this.operator.apply(facing);
        }

        public static Movable valueOf(int i) {
            return v[i];
        }

        public int distanceFromOrigin(class_2338 origin, class_2338 areaMin, class_2338 areaMax, class_2350 facing) {
            class_2350 actualFacing = this.getActualFacing(facing);
            class_2338 relative = actualFacing.method_10171() == class_2350.class_2352.field_11056 ? areaMax : areaMin;
            return Math.abs(TileFlexMarker.getDistance(origin, relative, actualFacing.method_10166()));
        }

        static {
            v = Movable.values();
        }
    }
}

