/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.filler.FillerEntity;
import com.yogpc.qp.machines.filler.FillerTargetPosIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class SkipIterator {
    FillerTargetPosIterator posIterator;
    List<class_2338> skipped;
    private final Area area;

    SkipIterator(Area area, Function<Area, FillerTargetPosIterator> constructor) {
        this.area = area;
        this.posIterator = constructor.apply(area);
        this.skipped = new ArrayList<class_2338>();
    }

    @Nullable
    class_2338 peek(Predicate<class_2338> filter) {
        Optional<class_2338> skipped = this.skipped.stream().filter(filter).findFirst();
        if (skipped.isPresent()) {
            return skipped.get();
        }
        while (this.posIterator.hasNext()) {
            class_2338 pos = (class_2338)this.posIterator.peek();
            if (filter.test(pos)) {
                return pos;
            }
            this.commit(pos, true);
        }
        return null;
    }

    void commit(class_2338 pos, boolean skip) {
        boolean alreadySkipped = this.skipped.remove(pos);
        if (skip) {
            this.skipped.add(pos);
        }
        if (!alreadySkipped) {
            this.posIterator.next();
        }
    }

    @VisibleForTesting
    @Nullable
    class_2338 next(Predicate<class_2338> filter) {
        class_2338 pos = this.peek(filter);
        this.commit(pos, false);
        return pos;
    }

    class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10582("type", this.posIterator.type().name());
        tag.method_10566("area", (class_2520)this.area.toNBT());
        tag.method_10544("current", ((class_2338)this.posIterator.peek()).method_10063());
        long[] skips = this.skipped.stream().mapToLong(class_2338::method_10063).toArray();
        tag.method_10564("skips", skips);
        return tag;
    }

    static SkipIterator fromNbt(class_2487 tag) {
        Area area = Area.fromNBT(tag.method_10562("area")).orElseThrow(() -> new IllegalArgumentException("Invalid tag for SkipIterator. %s".formatted(tag)));
        FillerEntity.Action action = FillerEntity.Action.valueOf(tag.method_10558("type"));
        SkipIterator skipIterator = new SkipIterator(area, action.iteratorProvider);
        class_2338 current = class_2338.method_10092((long)tag.method_10537("current"));
        skipIterator.posIterator.setCurrent(current);
        Arrays.stream(tag.method_10565("skips")).mapToObj(class_2338::method_10092).forEach(skipIterator.skipped::add);
        return skipIterator;
    }
}

