/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.PickIterator;
import com.yogpc.qp.machines.TargetIterator;
import com.yogpc.qp.machines.filler.FillerEntity;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public abstract class FillerTargetPosIterator
extends PickIterator<class_2338> {
    final Area area;
    final int maxY;
    final int minY;

    protected FillerTargetPosIterator(Area area) {
        this.area = area;
        this.maxY = area.maxY();
        this.minY = area.minY();
    }

    @Override
    public boolean hasNext() {
        return this.area.minX() <= ((class_2338)this.current).method_10263() && ((class_2338)this.current).method_10263() <= this.area.maxX() && this.area.minZ() <= ((class_2338)this.current).method_10260() && ((class_2338)this.current).method_10260() <= this.area.maxZ() && this.minY <= ((class_2338)this.current).method_10264() && ((class_2338)this.current).method_10264() <= this.maxY;
    }

    abstract FillerEntity.Action type();

    static final class Wall
    extends FillerTargetPosIterator {
        Wall(Area area) {
            super(area);
            this.reset();
        }

        @Override
        FillerEntity.Action type() {
            return FillerEntity.Action.WALL;
        }

        @Override
        protected class_2338 update() {
            class_2338 next;
            if (((class_2338)this.current).method_10264() == this.minY || ((class_2338)this.current).method_10264() == this.maxY) {
                next = ((class_2338)this.current).method_10263() < this.area.maxX() ? ((class_2338)this.current).method_30513(class_2350.class_2351.field_11048, 1) : (((class_2338)this.current).method_10260() < this.area.maxZ() ? new class_2338(this.area.minX(), ((class_2338)this.current).method_10264(), ((class_2338)this.current).method_10260() + 1) : new class_2338(this.area.minX(), ((class_2338)this.current).method_10264() + 1, this.area.minZ()));
            } else if (((class_2338)this.current).method_10263() == this.area.minX()) {
                next = ((class_2338)this.current).method_10260() == this.area.maxZ() ? ((class_2338)this.current).method_30513(class_2350.class_2351.field_11048, 1) : ((class_2338)this.current).method_30513(class_2350.class_2351.field_11051, 1);
            } else if (((class_2338)this.current).method_10260() == this.area.maxZ()) {
                next = ((class_2338)this.current).method_10263() == this.area.maxX() ? ((class_2338)this.current).method_30513(class_2350.class_2351.field_11051, -1) : ((class_2338)this.current).method_30513(class_2350.class_2351.field_11048, 1);
            } else if (((class_2338)this.current).method_10263() == this.area.maxX()) {
                next = ((class_2338)this.current).method_10260() == this.area.minZ() ? ((class_2338)this.current).method_30513(class_2350.class_2351.field_11048, -1) : ((class_2338)this.current).method_30513(class_2350.class_2351.field_11051, -1);
            } else if (((class_2338)this.current).method_10260() == this.area.minZ()) {
                next = ((class_2338)this.current).method_10263() == this.area.minX() + 1 ? new class_2338(this.area.minX(), ((class_2338)this.current).method_10264() + 1, this.area.minZ()) : ((class_2338)this.current).method_30513(class_2350.class_2351.field_11048, -1);
            } else {
                throw new IllegalStateException("Bad Position(%s) in %s".formatted(this.current, this.area));
            }
            this.current = next;
            return next;
        }

        @Override
        public class_2338 head() {
            return new class_2338(this.area.minX(), this.minY, this.area.minZ());
        }
    }

    static final class Box
    extends FillerTargetPosIterator {
        TargetIterator iterator;

        Box(Area area) {
            super(area);
            this.setNewIterator();
            this.reset();
        }

        @Override
        FillerEntity.Action type() {
            return FillerEntity.Action.BOX;
        }

        @Override
        public void reset() {
            this.iterator.reset();
            this.iterator.next();
            super.reset();
        }

        @Override
        protected class_2338 update() {
            if (this.iterator.hasNext()) {
                TargetIterator.XZPair xz = (TargetIterator.XZPair)this.iterator.next();
                return new class_2338(xz.x(), ((class_2338)this.current).method_10264(), xz.z());
            }
            this.setNewIterator();
            TargetIterator.XZPair xz = (TargetIterator.XZPair)this.iterator.next();
            return new class_2338(xz.x(), ((class_2338)this.current).method_10264() + 1, xz.z());
        }

        @Override
        public void setCurrent(class_2338 current) {
            super.setCurrent(current);
            this.iterator.setCurrent(new TargetIterator.XZPair(current.method_10263(), current.method_10260()));
            this.iterator.next();
        }

        @Override
        public class_2338 head() {
            TargetIterator.XZPair head = (TargetIterator.XZPair)this.iterator.head();
            return new class_2338(head.x(), this.minY, head.z());
        }

        private void setNewIterator() {
            Area fixedArea = new Area(this.area.minX() - 1, this.area.minY(), this.area.minZ() - 1, this.area.maxX() + 1, this.area.maxY(), this.area.maxZ() + 1, this.area.direction());
            this.iterator = TargetIterator.of(fixedArea);
        }
    }
}

