/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.EnergyConfigAccessor;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.QuarryMarker;
import com.yogpc.qp.machines.filler.FillerAction;
import com.yogpc.qp.machines.filler.FillerContainer;
import com.yogpc.qp.machines.filler.FillerEnergyConfigAccessor;
import com.yogpc.qp.machines.filler.FillerMenu;
import com.yogpc.qp.machines.filler.FillerTargetPosIterator;
import com.yogpc.qp.machines.filler.SkipIterator;
import com.yogpc.qp.utils.MapMulti;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class FillerEntity
extends PowerTile
implements CheckerLog,
EnchantmentLevel.HasEnchantments,
ExtendedScreenHandlerFactory {
    private static final Logger LOGGER = QuarryPlus.getLogger(FillerEntity.class);
    final FillerContainer container = new FillerContainer(27);
    final FillerAction fillerAction = new FillerAction(this.container::getFirstItem, this);

    public FillerEntity(@NotNull class_2338 pos, class_2680 state) {
        super(QuarryPlus.ModObjects.FILLER_TYPE, pos, state, (long)(1.0E9 * QuarryPlus.config.filler.fillerEnergyCapacity));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        if (!this.fillerAction.isFinished()) {
            nbt.method_10566("fillerAction", (class_2520)this.fillerAction.toNbt());
        }
        nbt.method_10566("container", (class_2520)this.container.method_7660());
        super.method_11007(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt.method_10545("fillerAction")) {
            this.fillerAction.fromNbt(nbt.method_10562("fillerAction"));
        }
        this.container.method_7659(nbt.method_10554("container", 10));
    }

    @Override
    public EnergyConfigAccessor getAccessor() {
        return FillerEnergyConfigAccessor.INSTANCE;
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return List.of();
    }

    @Override
    public List<? extends class_2561> getDebugLogs() {
        return Stream.of("Iterator: %s".formatted(this.fillerAction.iterator), "%sEnergy:%s %f/%d FE (%d)".formatted(class_124.field_1060, class_124.field_1070, (double)this.getEnergy() / 1.0E9, this.getMaxEnergy() / 1000000000L, this.getEnergy())).map(class_2561::method_43470).toList();
    }

    void tick() {
        if (!this.fillerAction.isFinished() && this.hasEnoughEnergy()) {
            if (this.field_11863 == null) {
                LOGGER.error("Level is NULL in {}#tick at {}", (Object)this.getClass().getSimpleName(), (Object)this.method_11016());
                return;
            }
            long energy = PowerTile.Constants.getFillerEnergy(this);
            this.fillerAction.tick(energy);
            if (this.fillerAction.isFinished()) {
                this.logUsage();
            }
        }
    }

    void start(Action fillerAction) {
        if (!this.fillerAction.isFinished()) {
            return;
        }
        assert (this.field_11863 != null);
        Stream.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039).map(arg_0 -> ((class_2338)this.method_11016()).method_10093(arg_0)).map(arg_0 -> ((class_1937)this.field_11863).method_8321(arg_0)).mapMulti(MapMulti.cast(QuarryMarker.class)).findFirst().ifPresent(m -> {
            this.fillerAction.setIterator(m.getArea().map(a -> new SkipIterator((Area)a, fillerAction.iteratorProvider)).orElse(null));
            m.removeAndGetItems().forEach(stack -> class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.method_11016().method_10084(), (class_1799)stack));
        });
    }

    public class_2561 method_5476() {
        return this.method_11010().method_26204().method_9518();
    }

    public class_1703 createMenu(int pContainerId, class_1661 pInventory, class_1657 pPlayer) {
        return new FillerMenu(pContainerId, pPlayer, this.method_11016());
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    public static InventoryStorage getFillerStorage(class_2586 entity, class_2350 context) {
        if (entity instanceof FillerEntity) {
            FillerEntity filler = (FillerEntity)entity;
            return InventoryStorage.of((class_1263)filler.container, (class_2350)context);
        }
        return null;
    }

    public static enum Action {
        BOX(FillerTargetPosIterator.Box::new),
        WALL(FillerTargetPosIterator.Wall::new);

        final Function<Area, FillerTargetPosIterator> iteratorProvider;

        private Action(Function<Area, FillerTargetPosIterator> iteratorProvider) {
            this.iteratorProvider = iteratorProvider;
        }
    }
}

