/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.filler;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.filler.SkipIterator;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class FillerAction {
    private static final Logger LOGGER = QuarryPlus.getLogger(FillerAction.class);
    final Supplier<Optional<class_1799>> stackProvider;
    final PowerTile powerSource;
    @Nullable
    SkipIterator iterator = null;

    public FillerAction(Supplier<Optional<class_1799>> stackProvider, PowerTile powerSource) {
        this.stackProvider = stackProvider;
        this.powerSource = powerSource;
    }

    void tick(long energy) {
        if (this.iterator == null || this.powerSource.method_10997() == null) {
            return;
        }
        Optional<class_1799> maybeStack = this.stackProvider.get();
        class_1937 level = this.powerSource.method_10997();
        maybeStack.ifPresent(blockStack -> {
            class_2338 targetPos = this.iterator.peek(FillerAction.predicate(level, blockStack));
            if (targetPos == null) {
                this.iterator = null;
            } else if (this.powerSource.useEnergy(energy, PowerTile.Reason.FILLER, false)) {
                class_1750 context = FillerAction.createContext(level, targetPos, blockStack);
                class_2680 state = FillerAction.getStateFromItem((class_1747)blockStack.method_7909(), context);
                if (state != null) {
                    level.method_8652(targetPos, state, 3);
                    blockStack.method_7934(1);
                }
                this.iterator.commit(targetPos, false);
            }
        });
    }

    public boolean isFinished() {
        return this.iterator == null;
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        if (this.iterator != null) {
            tag.method_10566("iterator", (class_2520)this.iterator.toNbt());
        }
        return tag;
    }

    public void fromNbt(class_2487 tag) {
        if (tag.method_10545("iterator")) {
            this.iterator = SkipIterator.fromNbt(tag.method_10562("iterator"));
        }
    }

    public void setIterator(@Nullable SkipIterator iterator) {
        this.iterator = iterator;
    }

    private static Predicate<class_2338> predicate(class_1937 level, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            return pos -> {
                class_1750 context = FillerAction.createContext(level, pos, stack);
                class_2680 state = FillerAction.getStateFromItem(blockItem, context);
                if (!context.method_8037().equals(pos)) {
                    return false;
                }
                if (!context.method_7716() || state == null) {
                    return false;
                }
                return level.method_8628(state, pos, class_3726.method_16194());
            };
        }
        return pos -> false;
    }

    static class_1750 createContext(class_1937 level, class_2338 pos, class_1799 stack) {
        return new class_1750(level, null, class_1268.field_5808, stack, new class_3965(class_243.method_24955((class_2382)pos), class_2350.field_11036, pos, false));
    }

    @Nullable
    private static class_2680 getStateFromItem(class_1747 blockItem, class_1750 context) {
        try {
            String blockItemName = FabricLoader.getInstance().getMappingResolver().unmapClassName("intermediary", class_1747.class.getName());
            String placeContext = FabricLoader.getInstance().getMappingResolver().unmapClassName("intermediary", class_1750.class.getName()).replace('.', '/');
            String blockState = FabricLoader.getInstance().getMappingResolver().unmapClassName("intermediary", class_2680.class.getName()).replace('.', '/');
            String methodName = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", blockItemName, "method_7707", "(L%s;)L%s;".formatted(placeContext, blockState));
            Method method = class_1747.class.getDeclaredMethod(methodName, class_1750.class);
            method.trySetAccessible();
            return (class_2680)method.invoke((Object)blockItem, context);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Caught exception in Filler", (Throwable)e);
            return null;
        }
    }
}

