/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentHolder;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.EnergyConfigAccessor;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.AdvQuarryEnergyConfigAccessor;
import com.yogpc.qp.machines.advquarry.AdvQuarryMenu;
import com.yogpc.qp.machines.advquarry.BlockAdvQuarry;
import com.yogpc.qp.packet.ClientSync;
import com.yogpc.qp.utils.CacheEntry;
import com.yogpc.qp.utils.MapMulti;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public class TileAdvQuarry
extends PowerTile
implements CheckerLog,
MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
ClientSync,
ExtendedScreenHandlerFactory {
    private boolean isBlockModuleLoaded = false;
    private final MachineStorage storage = new MachineStorage();
    private final QuarryCache cache = new QuarryCache();
    private final ItemConverter itemConverter = ItemConverter.defaultConverter().combined(ItemConverter.advQuarryConverter());
    public int digMinY;
    private boolean removeBedrock;
    @Nullable
    Area area = null;
    private List<EnchantmentLevel> enchantments = List.of();
    private AdvQuarryAction action = AdvQuarryAction.Waiting.WAITING;
    public String actionKey;

    public TileAdvQuarry(class_2338 pos, class_2680 state) {
        super(QuarryPlus.ModObjects.ADV_QUARRY_TYPE, pos, state, (long)(1.0E9 * QuarryPlus.config.adv_quarry.advQuarryEnergyCapacity));
    }

    @Override
    public List<? extends class_2561> getDebugLogs() {
        return Stream.of("%sArea:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.area), "%sAction:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.action), "%sActionKey:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.actionKey), "%sRemoveBedrock:%s %s".formatted(class_124.field_1060, class_124.field_1070, this.hasBedrockModule()), "%sDigMinY:%s %d".formatted(class_124.field_1060, class_124.field_1070, this.digMinY), "%sEnergy:%s %.1f/%d FE (%d)".formatted(class_124.field_1060, class_124.field_1070, (double)this.getEnergy() / 1.0E9, this.getMaxEnergy() / 1000000000L, this.getEnergy())).map(class_2561::method_43470).toList();
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TileAdvQuarry quarry) {
        if (!quarry.isBlockModuleLoaded) {
            quarry.isBlockModuleLoaded = true;
        }
        if (quarry.hasEnoughEnergy()) {
            quarry.action.tick(world, pos, state, quarry);
        }
    }

    public class_238 getRenderBoundingBox() {
        if (this.area != null) {
            return new class_238((double)this.area.minX(), 0.0, (double)this.area.minZ(), (double)this.area.maxX(), (double)this.area.maxY(), (double)this.area.maxZ());
        }
        return new class_238(this.method_11016(), this.method_11016().method_10069(1, 1, 1));
    }

    @Override
    public void method_11007(class_2487 nbt) {
        this.toClientTag(nbt);
        nbt.method_10566("storage", (class_2520)this.storage.toNbt());
        nbt.method_10566("action", (class_2520)this.action.toNbt());
        super.method_11007(nbt);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.fromClientTag(nbt);
        this.storage.readNbt(nbt.method_10562("storage"));
        this.action = AdvQuarryAction.fromNbt(nbt.method_10562("action"), this);
        this.isBlockModuleLoaded = false;
    }

    @Override
    public class_2487 toClientTag(class_2487 nbt) {
        if (this.area != null) {
            nbt.method_10566("area", (class_2520)this.area.toNBT());
        }
        class_2487 enchantments = new class_2487();
        this.enchantments.forEach(e -> enchantments.method_10569(Objects.requireNonNull(e.enchantmentID()).toString(), e.level()));
        nbt.method_10566("enchantments", (class_2520)enchantments);
        nbt.method_10582("actionKey", this.action.key());
        nbt.method_10569("digMinY", this.digMinY);
        nbt.method_10556("bedrockRemove", this.removeBedrock);
        return nbt;
    }

    @Override
    public void fromClientTag(class_2487 nbt) {
        this.area = Area.fromNBT(nbt.method_10562("area")).orElse(null);
        class_2487 enchantments = nbt.method_10562("enchantments");
        this.setEnchantments(enchantments.method_10541().stream().mapMulti(MapMulti.getEntry(class_7923.field_41176, arg_0 -> ((class_2487)enchantments).method_10550(arg_0))).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList());
        this.actionKey = nbt.method_10558("actionKey");
        this.digMinY = nbt.method_10550("digMinY");
        this.removeBedrock = nbt.method_10577("bedrockRemove");
    }

    public void setEnchantments(List<EnchantmentLevel> enchantments) {
        this.enchantments = enchantments;
        this.cache.enchantments.expire();
        this.setMaxEnergy((long)(QuarryPlus.config.adv_quarry.advQuarryEnergyCapacity * 1.0E9 * (double)(this.efficiencyLevel() + 1)));
    }

    @Nullable
    public Area getArea() {
        return this.area;
    }

    public void setDigMinYDefault() {
        Objects.requireNonNull(this.field_11863);
        this.digMinY = this.field_11863.method_31607();
    }

    void setAction(AdvQuarryAction action) {
        AdvQuarryAction pre = this.action;
        if (this.action == AdvQuarryAction.Waiting.WAITING && this.field_11863 != null) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)BlockAdvQuarry.WORKING, (Comparable)Boolean.valueOf(true)), 3);
        }
        this.action = action;
        if (action == AdvQuarryAction.Finished.FINISHED && this.field_11863 != null) {
            this.field_11863.method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)BlockAdvQuarry.WORKING, (Comparable)Boolean.valueOf(false)), 3);
            this.logUsage();
        }
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.sync();
            QuarryPlus.LOGGER.debug("ChunkDestroyer({}) State changed from {} to {}.", (Object)this.method_11016(), (Object)pre, (Object)action);
        }
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return this.enchantments;
    }

    public boolean canBreak(class_1937 targetWorld, class_2338 targetPos, class_2680 state) {
        boolean unbreakable;
        if (state.method_26215()) {
            return true;
        }
        boolean bl = unbreakable = state.method_26214((class_1922)targetWorld, targetPos) < 0.0f;
        if (unbreakable) {
            if (this.hasBedrockModule() && state.method_26204() == class_2246.field_9987) {
                return !targetWorld.method_27983().equals(class_1937.field_25181);
            }
            return false;
        }
        if (!targetWorld.method_8316(targetPos).method_15769()) {
            return true;
        }
        return this.getReplacementState() != state;
    }

    private boolean hasBedrockModule() {
        return this.removeBedrock;
    }

    class_2680 getReplacementState() {
        return this.cache.replaceState.getValue(this.field_11863);
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    public AdvQuarryMenu createMenu(int id, class_1661 p, class_1657 player) {
        return new AdvQuarryMenu(id, player, this.method_11016());
    }

    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
        buf.method_10807(this.method_11016());
    }

    public class_3218 getTargetWorld() {
        return (class_3218)this.field_11863;
    }

    public BreakResult breakOneBlock(class_2338 targetPos, boolean requireEnergy) {
        class_3218 targetWorld = this.getTargetWorld();
        class_1799 pickaxe = this.getPickaxe();
        class_2680 state = targetWorld.method_8320(targetPos);
        if (state.method_26215() || !this.canBreak((class_1937)targetWorld, targetPos, state)) {
            return BreakResult.SKIPPED;
        }
        float hardness = state.method_26214((class_1922)targetWorld, targetPos);
        if (requireEnergy && !this.useEnergy(PowerTile.Constants.getBreakEnergy(hardness, this), PowerTile.Reason.BREAK_BLOCK, false)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        List drops = class_2248.method_9609((class_2680)state, (class_3218)targetWorld, (class_2338)targetPos, (class_2586)targetWorld.method_8321(targetPos), null, (class_1799)pickaxe);
        drops.stream().map(this.itemConverter::map).forEach(this.storage::addItem);
        targetWorld.method_8652(targetPos, this.getReplacementState(), 3);
        this.method_5431();
        return BreakResult.SUCCESS;
    }

    BreakResult breakBlocks(int x, int z) {
        class_3218 targetWorld = this.getTargetWorld();
        class_1799 pickaxe = this.getPickaxe();
        class_238 aabb = new class_238((double)(x - 5), (double)(this.digMinY - 5), (double)(z - 5), (double)(x + 5), (double)(this.method_11016().method_10264() - 1), (double)(z + 5));
        targetWorld.method_8390(class_1542.class, aabb, Predicate.not(i -> i.method_6983().method_7960())).forEach(i -> {
            this.storage.addItem(i.method_6983());
            i.method_5768();
        });
        this.checkEdgeFluid(x, z, targetWorld);
        long requiredEnergy = 0L;
        ArrayList<Pair> toBreak = new ArrayList<Pair>();
        ArrayList<Pair> toDrain = new ArrayList<Pair>();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, 0, z);
        for (int y = this.method_11016().method_10264() - 1; y > this.digMinY; --y) {
            mutableBlockPos.method_33098(y);
            class_2680 state = targetWorld.method_8320((class_2338)mutableBlockPos);
            class_3610 fluidState = targetWorld.method_8316((class_2338)mutableBlockPos);
            if (fluidState.method_15769()) {
                if (state.method_26215()) continue;
                if (!this.canBreak((class_1937)targetWorld, (class_2338)mutableBlockPos, state)) {
                    if (state.method_26204() != class_2246.field_10316) continue;
                    targetWorld.method_8650((class_2338)mutableBlockPos, false);
                    continue;
                }
                float hardness = state.method_26214((class_1922)targetWorld, (class_2338)mutableBlockPos);
                long energy = PowerTile.Constants.getBreakEnergy(hardness, this);
                requiredEnergy += energy;
                toBreak.add(Pair.of((Object)mutableBlockPos.method_10062(), (Object)state));
                continue;
            }
            long energy = PowerTile.Constants.getBreakBlockFluidEnergy(this);
            requiredEnergy += energy;
            toDrain.add(Pair.of((Object)mutableBlockPos.method_10062(), (Object)state));
        }
        if (toBreak.isEmpty() && toDrain.isEmpty()) {
            return BreakResult.SKIPPED;
        }
        this.useEnergy(requiredEnergy, PowerTile.Reason.BREAK_BLOCK, true);
        for (Pair pair : toDrain) {
            class_2680 state;
            class_2248 energy = ((class_2680)pair.getRight()).method_26204();
            if (energy instanceof class_2263) {
                class_2263 fluidBlock = (class_2263)energy;
                class_1799 bucketItem = fluidBlock.method_9700((class_1936)targetWorld, (class_2338)pair.getLeft(), (class_2680)pair.getRight());
                this.storage.addFluid(bucketItem);
            }
            if (!(state = targetWorld.method_8320((class_2338)pair.getLeft())).method_26215() && this.canBreak((class_1937)targetWorld, (class_2338)pair.getLeft(), state)) {
                this.breakOneBlock((class_2338)pair.getLeft(), false);
            }
            targetWorld.method_8652((class_2338)pair.getLeft(), QuarryPlus.ModObjects.BLOCK_DUMMY.method_9564(), 18);
        }
        toBreak.stream().flatMap(p -> class_2248.method_9609((class_2680)((class_2680)p.getRight()), (class_3218)targetWorld, (class_2338)((class_2338)p.getLeft()), (class_2586)targetWorld.method_8321((class_2338)p.getLeft()), null, (class_1799)pickaxe).stream()).map(this.itemConverter::map).forEach(this.storage::addItem);
        toBreak.stream().map(Pair::getLeft).forEach(p -> targetWorld.method_8652(p, this.getReplacementState(), 18));
        this.method_5431();
        return BreakResult.SUCCESS;
    }

    void checkEdgeFluid(int x, int z, class_3218 targetWorld) {
        boolean flagMaxZ;
        assert (this.area != null);
        boolean flagMinX = x - 1 == this.area.minX();
        boolean flagMaxX = x + 1 == this.area.maxX();
        boolean flagMinZ = z - 1 == this.area.minZ();
        boolean bl = flagMaxZ = z + 1 == this.area.maxZ();
        if (flagMinX) {
            this.removeFluidAtEdge(this.area.minX(), z, targetWorld);
        }
        if (flagMaxX) {
            this.removeFluidAtEdge(this.area.maxX(), z, targetWorld);
        }
        if (flagMinZ) {
            this.removeFluidAtEdge(x, this.area.minZ(), targetWorld);
        }
        if (flagMaxZ) {
            this.removeFluidAtEdge(x, this.area.maxZ(), targetWorld);
        }
        if (flagMinX && flagMinZ) {
            this.removeFluidAtEdge(this.area.minX(), this.area.minZ(), targetWorld);
        }
        if (flagMinX && flagMaxZ) {
            this.removeFluidAtEdge(this.area.minX(), this.area.maxZ(), targetWorld);
        }
        if (flagMaxX && flagMinZ) {
            this.removeFluidAtEdge(this.area.maxX(), this.area.minZ(), targetWorld);
        }
        if (flagMaxX && flagMaxZ) {
            this.removeFluidAtEdge(this.area.maxX(), this.area.maxZ(), targetWorld);
        }
    }

    void removeFluidAtEdge(int x, int z, class_3218 world) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, 0, z);
        for (int y = this.method_11016().method_10264() - 1; y > this.digMinY; --y) {
            pos.method_33098(y);
            class_3610 fluidState = world.method_8316((class_2338)pos);
            if (fluidState.method_15769()) continue;
            class_2680 state = world.method_8320((class_2338)pos);
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof class_2263) {
                class_2263 fluidBlock = (class_2263)class_22482;
                this.useEnergy(PowerTile.Constants.getBreakBlockFluidEnergy(this), PowerTile.Reason.REMOVE_FLUID, true);
                class_1799 bucketItem = fluidBlock.method_9700((class_1936)world, (class_2338)pos, state);
                this.storage.addFluid(bucketItem);
                if (!world.method_8320((class_2338)pos).method_26215() && (!(fluidBlock instanceof class_2404) || fluidState.method_15771())) continue;
                world.method_8652((class_2338)pos, QuarryPlus.ModObjects.BLOCK_FRAME.getDammingState(), 3);
                continue;
            }
            if (!(state.method_26204() instanceof class_2402)) continue;
            float hardness = state.method_26214((class_1922)world, (class_2338)pos);
            this.useEnergy(PowerTile.Constants.getBreakEnergy(hardness, this), PowerTile.Reason.REMOVE_FLUID, true);
            List drops = class_2248.method_9609((class_2680)state, (class_3218)world, (class_2338)pos, (class_2586)world.method_8321((class_2338)pos), null, (class_1799)this.getPickaxe());
            drops.forEach(this.storage::addItem);
            world.method_8652((class_2338)pos, QuarryPlus.ModObjects.BLOCK_FRAME.getDammingState(), 3);
        }
    }

    public class_2561 method_5476() {
        return this.method_11010().method_26204().method_9518();
    }

    @Override
    public int efficiencyLevel() {
        return this.cache.enchantments.getValue(this.method_10997()).efficiency();
    }

    @Override
    public int unbreakingLevel() {
        return this.cache.enchantments.getValue(this.method_10997()).unbreaking();
    }

    @Override
    public int fortuneLevel() {
        return this.cache.enchantments.getValue(this.method_10997()).fortune();
    }

    @Override
    public int silktouchLevel() {
        return this.cache.enchantments.getValue(this.method_10997()).silktouch();
    }

    @Override
    public EnergyConfigAccessor getAccessor() {
        return AdvQuarryEnergyConfigAccessor.INSTANCE;
    }

    private class QuarryCache {
        final CacheEntry<class_2680> replaceState = CacheEntry.constantCache(() -> ((class_2248)class_2246.field_10124).method_9564());
        final CacheEntry<Integer> netherTop = CacheEntry.supplierCache(100L, () -> QuarryPlus.config.common.netherTop);
        final CacheEntry<EnchantmentHolder> enchantments = CacheEntry.supplierCache(1000L, () -> EnchantmentHolder.makeHolder(TileAdvQuarry.this));
    }
}

