/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.TargetIterator;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5558;
import org.apache.logging.log4j.Logger;

public abstract class AdvQuarryAction
implements class_5558<TileAdvQuarry> {
    private static final Logger LOGGER = QuarryPlus.getLogger(AdvQuarryAction.class);
    static final Map<String, Serializer> SERIALIZER_MAP = Stream.of(new WaitingSerializer(), new MakeFrameSerializer(), new BreakBlockSerializer(), new CheckFluidSerializer(), new FinishedSerializer()).collect(Collectors.toMap(Serializer::key, Function.identity()));

    final class_2487 toNbt() {
        class_2487 tag = new class_2487();
        tag.method_10582("type", this.key());
        return this.writeDetail(tag);
    }

    static AdvQuarryAction fromNbt(class_2487 tag, TileAdvQuarry quarry) {
        String key = tag.method_10558("type");
        return Optional.ofNullable(SERIALIZER_MAP.get(key)).map(s -> s.fromTag(tag, quarry)).orElseGet(() -> {
            if (!tag.method_33133()) {
                LOGGER.error("Unknown type '{}' found in tag: {}", (Object)key, (Object)tag);
            }
            return Waiting.WAITING;
        });
    }

    abstract class_2487 writeDetail(class_2487 var1);

    abstract String key();

    public String toString() {
        return this.key();
    }

    public abstract void tick(class_1937 var1, class_2338 var2, class_2680 var3, TileAdvQuarry var4);

    @Nullable
    static <T> T skipIterator(Iterator<T> iterator, Predicate<T> skipCondition) {
        while (iterator.hasNext()) {
            T next = iterator.next();
            if (skipCondition.test(next)) continue;
            return next;
        }
        return null;
    }

    static abstract class Serializer {
        Serializer() {
        }

        abstract String key();

        abstract AdvQuarryAction fromTag(class_2487 var1, TileAdvQuarry var2);
    }

    public static final class Waiting
    extends AdvQuarryAction {
        public static final Waiting WAITING = new Waiting();

        private Waiting() {
        }

        @Override
        String key() {
            return "Waiting";
        }

        @Override
        class_2487 writeDetail(class_2487 tag) {
            return new class_2487();
        }

        @Override
        public void tick(class_1937 level, class_2338 pos, class_2680 state, TileAdvQuarry quarry) {
            if (quarry.getEnergy() > quarry.getMaxEnergy() / 4L) {
                quarry.setAction(new MakeFrame(quarry.getArea()));
            }
        }
    }

    private static final class WaitingSerializer
    extends Serializer {
        private WaitingSerializer() {
        }

        @Override
        String key() {
            return "Waiting";
        }

        @Override
        AdvQuarryAction fromTag(class_2487 tag, TileAdvQuarry quarry) {
            return Waiting.WAITING;
        }
    }

    private static final class MakeFrameSerializer
    extends Serializer {
        private MakeFrameSerializer() {
        }

        @Override
        String key() {
            return "MakeFrame";
        }

        @Override
        AdvQuarryAction fromTag(class_2487 tag, TileAdvQuarry quarry) {
            class_2338 pos = tag.method_10545("current") ? class_2338.method_10092((long)tag.method_10537("current")) : null;
            return new MakeFrame(quarry.getArea(), pos);
        }
    }

    private static final class BreakBlockSerializer
    extends Serializer {
        private BreakBlockSerializer() {
        }

        @Override
        String key() {
            return "BreakBlock";
        }

        @Override
        AdvQuarryAction fromTag(class_2487 tag, TileAdvQuarry quarry) {
            int x = tag.method_10550("currentX");
            int z = tag.method_10550("currentZ");
            boolean searchEnergyConsumed = tag.method_10577("searchEnergyConsumed");
            return new BreakBlock(quarry, x, z, searchEnergyConsumed);
        }
    }

    private static final class CheckFluidSerializer
    extends Serializer {
        private CheckFluidSerializer() {
        }

        @Override
        String key() {
            return "CheckFluid";
        }

        @Override
        AdvQuarryAction fromTag(class_2487 tag, TileAdvQuarry quarry) {
            int x = tag.method_10550("currentX");
            int z = tag.method_10550("currentZ");
            return new CheckFluid(quarry, x, z);
        }
    }

    private static final class FinishedSerializer
    extends Serializer {
        private FinishedSerializer() {
        }

        @Override
        String key() {
            return "Finished";
        }

        @Override
        AdvQuarryAction fromTag(class_2487 tag, TileAdvQuarry quarry) {
            return Finished.FINISHED;
        }
    }

    public static final class Finished
    extends AdvQuarryAction {
        public static final Finished FINISHED = new Finished();

        private Finished() {
        }

        @Override
        class_2487 writeDetail(class_2487 tag) {
            return tag;
        }

        @Override
        String key() {
            return "Finished";
        }

        @Override
        public void tick(class_1937 level, class_2338 pos, class_2680 state, TileAdvQuarry quarry) {
        }
    }

    public static final class CheckFluid
    extends AdvQuarryAction {
        private final TargetIterator iterator;

        public CheckFluid(TileAdvQuarry quarry) {
            assert (quarry.getArea() != null);
            this.iterator = TargetIterator.of(quarry.getArea());
        }

        CheckFluid(TileAdvQuarry quarry, int x, int z) {
            assert (quarry.getArea() != null);
            this.iterator = TargetIterator.of(quarry.getArea());
            this.iterator.setCurrent(new TargetIterator.XZPair(x, z));
        }

        @Override
        class_2487 writeDetail(class_2487 tag) {
            TargetIterator.XZPair xzPair = (TargetIterator.XZPair)this.iterator.peek();
            tag.method_10569("currentX", xzPair.x());
            tag.method_10569("currentZ", xzPair.z());
            return tag;
        }

        @Override
        String key() {
            return "CheckFluid";
        }

        @Override
        public void tick(class_1937 level, class_2338 pos, class_2680 state, TileAdvQuarry quarry) {
            int count = 0;
            class_3218 targetWorld = quarry.getTargetWorld();
            while (count < 32 && this.iterator.hasNext()) {
                boolean flagRemoved = false;
                TargetIterator.XZPair target = (TargetIterator.XZPair)this.iterator.peek();
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(target.x(), 0, target.z());
                for (int y = quarry.digMinY + 1; y < pos.method_10264() - 1; ++y) {
                    mutableBlockPos.method_33098(y);
                    class_2680 blockState = targetWorld.method_8320((class_2338)mutableBlockPos);
                    if (!blockState.method_27852((class_2248)QuarryPlus.ModObjects.BLOCK_DUMMY) && !blockState.method_27852(class_2246.field_10340) && !blockState.method_27852(class_2246.field_10445)) continue;
                    targetWorld.method_8652((class_2338)mutableBlockPos, class_2246.field_10124.method_9564(), 3);
                    flagRemoved = true;
                }
                this.iterator.next();
                if (!flagRemoved) continue;
                ++count;
            }
            if (!this.iterator.hasNext()) {
                quarry.setAction(Finished.FINISHED);
            }
        }
    }

    public static final class BreakBlock
    extends AdvQuarryAction {
        private final TargetIterator iterator;
        private boolean searchEnergyConsumed;

        public BreakBlock(TileAdvQuarry quarry) {
            assert (quarry.getArea() != null);
            this.iterator = TargetIterator.of(quarry.getArea());
        }

        BreakBlock(TileAdvQuarry quarry, int x, int z, boolean searchEnergyConsumed) {
            assert (quarry.getArea() != null);
            this.iterator = TargetIterator.of(quarry.getArea());
            this.iterator.setCurrent(new TargetIterator.XZPair(x, z));
            this.searchEnergyConsumed = searchEnergyConsumed;
        }

        @Override
        class_2487 writeDetail(class_2487 tag) {
            TargetIterator.XZPair xzPair = (TargetIterator.XZPair)this.iterator.peek();
            tag.method_10569("currentX", xzPair.x());
            tag.method_10569("currentZ", xzPair.z());
            tag.method_10556("searchEnergyConsumed", this.searchEnergyConsumed);
            return tag;
        }

        @Override
        String key() {
            return "BreakBlock";
        }

        @Override
        public void tick(class_1937 level, class_2338 pos, class_2680 state, TileAdvQuarry quarry) {
            BreakResult result = null;
            while (result == null || result == BreakResult.SKIPPED) {
                TargetIterator.XZPair target = (TargetIterator.XZPair)this.iterator.peek();
                if (!this.searchEnergyConsumed) {
                    long energy = PowerTile.Constants.getAdvSearchEnergy(pos.method_10264() - quarry.digMinY, quarry);
                    this.searchEnergyConsumed = quarry.useEnergy(energy, PowerTile.Reason.ADV_SEARCH, false);
                }
                if (!this.searchEnergyConsumed) break;
                result = quarry.breakBlocks(target.x(), target.z());
                if (!result.isSuccess()) continue;
                this.iterator.next();
                this.searchEnergyConsumed = false;
                if (this.iterator.hasNext()) continue;
                quarry.setAction(new CheckFluid(quarry));
                break;
            }
        }
    }

    public static final class MakeFrame
    extends AdvQuarryAction {
        private Iterator<class_2338> posIterator;
        @Nullable
        private class_2338 current;

        public MakeFrame(Area area) {
            this.posIterator = Area.getFramePosStream(area).iterator();
            this.current = this.posIterator.next();
        }

        MakeFrame(Area area, @Nullable class_2338 current) {
            this.posIterator = Area.getFramePosStream(area).dropWhile(Predicate.isEqual(current).negate()).iterator();
            if (!this.posIterator.hasNext()) {
                this.posIterator = Area.getFramePosStream(area).iterator();
                this.current = this.posIterator.next();
            } else {
                this.current = current;
            }
        }

        @Override
        class_2487 writeDetail(class_2487 tag) {
            if (this.current != null) {
                tag.method_10544("current", this.current.method_10063());
            }
            return tag;
        }

        @Override
        String key() {
            return "MakeFrame";
        }

        @Override
        public void tick(class_1937 level, class_2338 pos, class_2680 state, TileAdvQuarry quarry) {
            for (int i = 0; i < 4; ++i) {
                if (this.current != null) {
                    class_2680 targetState = quarry.getTargetWorld().method_8320(this.current);
                    BreakResult result = targetState.method_26215() ? BreakResult.SUCCESS : quarry.breakOneBlock(this.current, true);
                    if (!result.isSuccess()) continue;
                    if (result == BreakResult.SKIPPED) {
                        this.current = MakeFrame.skipIterator(this.posIterator, MakeFrame.skipFramePlace(quarry));
                        continue;
                    }
                    if (!quarry.useEnergy(PowerTile.Constants.getMakeFrameEnergy(quarry), PowerTile.Reason.MAKE_FRAME, false)) continue;
                    quarry.getTargetWorld().method_8501(this.current, QuarryPlus.ModObjects.BLOCK_FRAME.method_9564());
                    this.current = MakeFrame.skipIterator(this.posIterator, MakeFrame.skipFramePlace(quarry));
                    continue;
                }
                quarry.setAction(new BreakBlock(quarry));
                break;
            }
        }

        static Predicate<class_2338> skipFramePlace(TileAdvQuarry quarry) {
            class_3218 world = quarry.getTargetWorld();
            assert (world != null);
            return pos -> {
                class_2680 state = world.method_8320(pos);
                return state.method_27852((class_2248)QuarryPlus.ModObjects.BLOCK_FRAME) || !quarry.canBreak((class_1937)world, (class_2338)pos, state) || pos.equals((Object)quarry.method_11016());
            };
        }
    }
}

