/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.BreakResult;
import com.yogpc.qp.machines.CheckerLog;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.FluidKey;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.PowerTile;
import com.yogpc.qp.machines.advpump.BlockAdvPump;
import com.yogpc.qp.machines.advpump.EnchantmentEfficiency;
import com.yogpc.qp.machines.advpump.Target;
import com.yogpc.qp.packet.ClientSync;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_5250;

public class TileAdvPump
extends PowerTile
implements MachineStorage.HasStorage,
EnchantmentLevel.HasEnchantments,
CheckerLog,
ClientSync {
    private final MachineStorage storage = new MachineStorage();
    private int y;
    private Target target;
    private EnchantmentEfficiency enchantmentEfficiency;
    private boolean finished = false;

    public TileAdvPump(class_2338 pos, class_2680 state) {
        super(QuarryPlus.ModObjects.ADV_PUMP_TYPE, pos, state, (long)(1.0E9 * QuarryPlus.config.adv_pump.advPumpEnergyCapacity));
        this.y = pos.method_10264() - 1;
        this.enchantmentEfficiency = new EnchantmentEfficiency(List.of());
    }

    @Override
    public void method_11007(class_2487 nbt) {
        nbt.method_10566("storage", (class_2520)this.storage.toNbt());
        nbt.method_10569("y", this.y);
        nbt.method_10566("enchantments", (class_2520)this.enchantmentEfficiency.toNbt());
        nbt.method_10556("finished", this.finished);
        super.method_11007(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt.method_10562("storage"));
        this.y = nbt.method_10550("y");
        this.setEnchantment(EnchantmentEfficiency.fromNbt(nbt.method_10562("enchantments")));
        this.finished = nbt.method_10577("finished");
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, TileAdvPump pump) {
        long fluidSum = pump.storage.getFluidMap().values().stream().mapToLong(Long::longValue).sum();
        if (pump.hasEnoughEnergy() && !pump.finished && fluidSum <= (long)pump.enchantmentEfficiency.fluidCapacity) {
            if (pump.target == null) {
                class_2338 initPos = pos.method_33096(pump.y);
                pump.target = Target.getTarget(world, initPos, pump.enchantmentEfficiency.rangePredicate(initPos));
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BlockAdvPump.WORKING, (Comparable)Boolean.valueOf(true)));
            }
            if (pump.target.hasNext()) {
                class_2338 target;
                BreakResult result;
                while (pump.target.hasNext() && (result = pump.pumpFluid(world, target = pump.target.next(), f -> f.method_15767(class_3486.field_15517) ? QuarryPlus.ModObjects.BLOCK_DUMMY.method_9564() : class_2246.field_10124.method_9564(), true)).isSuccess()) {
                    class_2350.class_2353.field_11062.method_29716().map(arg_0 -> ((class_2338)target).method_10093(arg_0)).filter(pump.target.getPredicate().negate()).forEach(p -> pump.pumpFluid(world, (class_2338)p, f -> QuarryPlus.ModObjects.BLOCK_FRAME.getDammingState(), false));
                }
            } else if (!pump.target.checkAllFluidsRemoved(world, pos.method_33096(pump.y))) {
                --pump.y;
                class_2338 nextPos = pos.method_33096(pump.y);
                if (TileAdvPump.shouldFinish(world, nextPos)) {
                    pump.finished = true;
                    pump.target = null;
                    world.method_8501(pos, (class_2680)state.method_11657((class_2769)BlockAdvPump.WORKING, (Comparable)Boolean.valueOf(false)));
                    pump.logUsage();
                    for (int i = pos.method_10264() - 1; i > pump.y; --i) {
                        class_2338 withY = pos.method_33096(i);
                        class_2680 blockState = world.method_8320(withY);
                        if (blockState.method_27852((class_2248)QuarryPlus.ModObjects.BLOCK_DUMMY)) {
                            world.method_8650(withY, false);
                        } else if (blockState.method_26215()) {
                            continue;
                        }
                        break;
                    }
                } else {
                    pump.target = Target.getTarget(world, nextPos, pump.enchantmentEfficiency.rangePredicate(nextPos));
                }
            }
        }
    }

    private static boolean shouldFinish(class_1937 world, class_2338 nextPos) {
        boolean blockCondition = world.method_22347(nextPos) || world.method_8320(nextPos).method_27852((class_2248)QuarryPlus.ModObjects.BLOCK_DUMMY);
        return world.method_8316(nextPos).method_15769() && !blockCondition;
    }

    private BreakResult pumpFluid(class_1937 world, class_2338 target, Function<class_3610, class_2680> replaceBlockGetter, boolean useEnergy) {
        class_2248 class_22482;
        class_3610 fluidState = world.method_8316(target);
        if (fluidState.method_15769()) {
            return BreakResult.SKIPPED;
        }
        if (!fluidState.method_15771()) {
            world.method_8652(target, replaceBlockGetter.apply(fluidState), 3);
            return BreakResult.SUCCESS;
        }
        if (useEnergy && !this.useEnergy(this.enchantmentEfficiency.baseEnergy, PowerTile.Reason.ADV_PUMP_FLUID, false)) {
            return BreakResult.NOT_ENOUGH_ENERGY;
        }
        class_2680 blockState = world.method_8320(target);
        if (!(blockState.method_26204() instanceof class_2404) && (class_22482 = blockState.method_26204()) instanceof class_2263) {
            class_2263 drain = (class_2263)class_22482;
            class_1799 drained = drain.method_9700((class_1936)world, target, blockState);
            this.storage.addFluid(drained);
        } else {
            this.storage.addFluid(fluidState.method_15772(), 1000L);
            world.method_8652(target, replaceBlockGetter.apply(fluidState), 3);
        }
        return BreakResult.SUCCESS;
    }

    public void setEnchantment(EnchantmentEfficiency enchantmentEfficiency) {
        this.enchantmentEfficiency = enchantmentEfficiency;
        this.maxEnergy = enchantmentEfficiency.energyCapacity;
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.sync();
        }
    }

    public void reset() {
        this.target = null;
        this.finished = false;
        this.y = this.field_11867.method_10264() - 1;
    }

    @Override
    public MachineStorage getStorage() {
        return this.storage;
    }

    @Override
    public List<EnchantmentLevel> getEnchantments() {
        return this.enchantmentEfficiency.getEnchantments();
    }

    @Override
    public List<? extends class_2561> getDebugLogs() {
        List<class_5250> fluidSummery = this.storage.getFluidMap().entrySet().stream().map(e -> "%s: %d mB".formatted(((FluidKey)e.getKey()).getId(), e.getValue())).map(class_2561::method_43470).toList();
        if (fluidSummery.isEmpty()) {
            return List.of(class_2561.method_43470((String)"No Fluid."));
        }
        return fluidSummery;
    }

    @Override
    public void fromClientTag(class_2487 tag) {
        this.method_11014(tag);
    }

    @Override
    public class_2487 toClientTag(class_2487 tag) {
        return this.method_38242();
    }
}

