/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advpump;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.EnchantmentLevel;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

class EnchantmentEfficiency {
    private final List<EnchantmentLevel> enchantments;
    final long energyCapacity;
    final int fluidCapacity;
    final long baseEnergy;
    static final float[] baseEnergyMap = new float[]{5.0f, 4.0f, 2.5f, 1.0f};
    final int range;

    EnchantmentEfficiency(List<EnchantmentLevel> enchantments) {
        this.enchantments = enchantments;
        int efficiency = EnchantmentEfficiency.getLevel(enchantments, class_1893.field_9131);
        int unbreaking = EnchantmentEfficiency.getLevel(enchantments, class_1893.field_9119);
        int rangeLevel = Math.max(EnchantmentEfficiency.getLevel(enchantments, class_1893.field_9130), 3 * Math.min(EnchantmentEfficiency.getLevel(enchantments, class_1893.field_9099), 1));
        this.range = (rangeLevel + 1) * 32;
        this.energyCapacity = (long)((int)Math.pow(2.0, 10 + efficiency)) * 1000000000L;
        this.fluidCapacity = 512000 * (efficiency + 1);
        this.baseEnergy = (long)((double)(baseEnergyMap[class_3532.method_15340((int)unbreaking, (int)0, (int)3)] * 1.0E9f) * QuarryPlus.config.adv_pump.advPumpEnergyRemoveFluid);
    }

    static int getLevel(List<EnchantmentLevel> enchantments, class_1887 enchantment) {
        return enchantments.stream().filter(e -> enchantment.equals(e.enchantment())).mapToInt(EnchantmentLevel::level).max().orElse(0);
    }

    class_2487 toNbt() {
        class_2487 tag = new class_2487();
        for (EnchantmentLevel enchantment : this.enchantments) {
            tag.method_10569(Objects.requireNonNull(enchantment.enchantmentID()).toString(), enchantment.level());
        }
        return tag;
    }

    public List<EnchantmentLevel> getEnchantments() {
        return this.enchantments;
    }

    public Predicate<class_2338> rangePredicate(class_2338 center) {
        return p -> {
            int zDiff;
            int xDiff = center.method_10263() - p.method_10263();
            return xDiff * xDiff + (zDiff = center.method_10260() - p.method_10260()) * zDiff < this.range * this.range;
        };
    }

    static EnchantmentEfficiency fromNbt(class_2487 tag) {
        List<EnchantmentLevel> enchantmentLevels = tag.method_10541().stream().flatMap(k -> class_7923.field_41176.method_17966(new class_2960(k)).map(e -> Map.entry(e, tag.method_10550(k))).stream()).map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList();
        return new EnchantmentEfficiency(enchantmentLevels);
    }

    static EnchantmentEfficiency fromMap(Map<class_1887, Integer> enchantmentMap) {
        return new EnchantmentEfficiency(enchantmentMap.entrySet().stream().map(EnchantmentLevel::new).sorted(EnchantmentLevel.QUARRY_ENCHANTMENT_COMPARATOR).toList());
    }
}

