/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.PickIterator;
import net.minecraft.class_2350;

public abstract class TargetIterator
extends PickIterator<XZPair> {
    protected final Area area;

    TargetIterator(Area area) {
        this.area = area;
        this.reset();
    }

    public static TargetIterator of(Area area) {
        return switch (area.direction()) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043, class_2350.field_11036, class_2350.field_11033 -> new North(area);
            case class_2350.field_11035 -> new South(area);
            case class_2350.field_11039 -> new West(area);
            case class_2350.field_11034 -> new East(area);
        };
    }

    @Override
    public final boolean hasNext() {
        return this.area.minX() < ((XZPair)this.current).x() && ((XZPair)this.current).x() < this.area.maxX() && this.area.minZ() < ((XZPair)this.current).z() && ((XZPair)this.current).z() < this.area.maxZ();
    }

    private static final class North
    extends TargetIterator {
        North(Area area) {
            super(area);
        }

        @Override
        protected XZPair update() {
            if (((XZPair)this.current).z() + 1 >= this.area.maxZ()) {
                return new XZPair(((XZPair)this.current).x() - 1, this.area.minZ() + 1);
            }
            return new XZPair(((XZPair)this.current).x(), ((XZPair)this.current).z() + 1);
        }

        @Override
        public XZPair head() {
            return new XZPair(this.area.maxX() - 1, this.area.minZ() + 1);
        }
    }

    private static final class South
    extends TargetIterator {
        South(Area area) {
            super(area);
        }

        @Override
        protected XZPair update() {
            if (((XZPair)this.current).z() - 1 <= this.area.minZ()) {
                return new XZPair(((XZPair)this.current).x() + 1, this.area.maxZ() - 1);
            }
            return new XZPair(((XZPair)this.current).x(), ((XZPair)this.current).z() - 1);
        }

        @Override
        public XZPair head() {
            return new XZPair(this.area.minX() + 1, this.area.maxZ() - 1);
        }
    }

    private static final class West
    extends TargetIterator {
        West(Area area) {
            super(area);
        }

        @Override
        protected XZPair update() {
            if (((XZPair)this.current).x() + 1 >= this.area.maxX()) {
                return new XZPair(this.area.minX() + 1, ((XZPair)this.current).z() + 1);
            }
            return new XZPair(((XZPair)this.current).x() + 1, ((XZPair)this.current).z());
        }

        @Override
        public XZPair head() {
            return new XZPair(this.area.minX() + 1, this.area.minZ() + 1);
        }
    }

    private static final class East
    extends TargetIterator {
        East(Area area) {
            super(area);
        }

        @Override
        protected XZPair update() {
            if (((XZPair)this.current).x() - 1 <= this.area.minX()) {
                return new XZPair(this.area.maxX() - 1, ((XZPair)this.current).z() - 1);
            }
            return new XZPair(((XZPair)this.current).x() - 1, ((XZPair)this.current).z());
        }

        @Override
        public XZPair head() {
            return new XZPair(this.area.maxX() - 1, this.area.maxZ() - 1);
        }
    }

    public record XZPair(int x, int z) {
    }
}

