/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.EnergyIntegration;
import com.yogpc.qp.machines.EnchantmentLevel;
import com.yogpc.qp.machines.EnergyCounter;
import com.yogpc.qp.utils.QuarryChunkLoadUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class PowerTile
extends class_2586 {
    public static final long ONE_FE = 1000000000L;
    private final EnergyCounter energyCounter;
    protected long energy;
    protected long maxEnergy;
    protected boolean chunkPreLoaded;

    public PowerTile(class_2591<?> type, class_2338 pos, class_2680 state) {
        this(type, pos, state, 1000000000000L);
    }

    public PowerTile(class_2591<?> type, class_2338 pos, class_2680 state, long maxEnergy) {
        super(type, pos, state);
        this.maxEnergy = maxEnergy;
        this.energyCounter = EnergyCounter.createInstance(QuarryPlus.config.common.debug, "%s(%d, %d, %d)".formatted(((Object)((Object)this)).getClass().getSimpleName(), pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public void method_11007(class_2487 nbt) {
        nbt.method_10544("energy", this.energy);
        nbt.method_10544("maxEnergy", this.maxEnergy);
        nbt.method_10556("chunkPreLoaded", this.chunkPreLoaded);
        super.method_11007(nbt);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.energy = nbt.method_10537("energy");
        if (nbt.method_10545("maxEnergy")) {
            this.maxEnergy = nbt.method_10537("maxEnergy");
        }
        this.chunkPreLoaded = nbt.method_10577("chunkPreLoaded");
    }

    public long getEnergy() {
        return this.energy;
    }

    public long getMaxEnergy() {
        return this.maxEnergy;
    }

    public void setMaxEnergy(long maxEnergy) {
        this.maxEnergy = maxEnergy;
    }

    protected boolean hasEnoughEnergy() {
        return this.getEnergy() > 0L;
    }

    public long addEnergy(long amount, boolean simulate) {
        assert (this.field_11863 != null);
        long accepted = Math.min(this.maxEnergy - this.energy, amount);
        if (!simulate) {
            this.energy += accepted;
            this.energyCounter.getEnergy(this.field_11863.method_8510(), accepted);
        }
        return accepted;
    }

    public boolean useEnergy(long amount, Reason reason, boolean force) {
        assert (this.field_11863 != null);
        if (this.energy >= amount || force) {
            this.energy -= amount;
            this.energyCounter.useEnergy(this.field_11863.method_8510(), amount, reason);
            return true;
        }
        return false;
    }

    protected void logUsage() {
        this.energyCounter.logUsageMap();
    }

    public void setChunkPreLoaded(boolean chunkPreLoaded) {
        this.chunkPreLoaded = chunkPreLoaded;
    }

    public void method_11012() {
        super.method_11012();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            QuarryChunkLoadUtil.makeChunkUnloaded(this.field_11863, this.field_11867, this.chunkPreLoaded);
        }
    }

    @Nullable
    public static class_5558<PowerTile> logTicker() {
        if (QuarryPlus.config.common.debug) {
            return (w, p, s, blockEntity) -> blockEntity.energyCounter.logOutput(w.method_8510());
        }
        return null;
    }

    @Nullable
    public static class_5558<PowerTile> getGenerator() {
        if (!PowerTile.isInfiniteEnergyEnabled(EnergyIntegration.hasAnyEnergyModule(), QuarryPlus.config.common.debug, QuarryPlus.config.common.noEnergy)) {
            return null;
        }
        return (w, p, s, tile) -> tile.addEnergy(tile.getMaxEnergy() - tile.getEnergy(), false);
    }

    @VisibleForTesting
    static boolean isInfiniteEnergyEnabled(boolean hasEnergyMod, boolean isDebug, boolean noEnergyConfig) {
        return !hasEnergyMod && !isDebug || noEnergyConfig;
    }

    public static enum Reason {
        MAKE_FRAME,
        BREAK_BLOCK,
        REMOVE_FLUID,
        MOVE_HEAD,
        ADV_PUMP_FLUID,
        ADV_SEARCH,
        FILLER;

    }

    public static class Constants {
        public static long getMakeFrameEnergy(EnchantmentLevel.HasEnchantments enchantments) {
            return (long)(enchantments.getAccessor().makeFrame() * 1.0E9 / (double)(1 + Math.max(0, enchantments.unbreakingLevel())));
        }

        public static long getAdvSearchEnergy(int blocks, EnchantmentLevel.HasEnchantments enchantments) {
            double FIFTH_ROOT_OF_2 = 1.148698354997035;
            double heightEnergy = (double)blocks * enchantments.getAccessor().moveHead() * 1.0E9;
            double efficiencyBalanced = Math.pow(1.148698354997035, enchantments.efficiencyLevel()) * heightEnergy;
            return (long)(efficiencyBalanced / (double)(1 + Math.max(0, enchantments.unbreakingLevel())));
        }

        public static long getBreakEnergy(float hardness, EnchantmentLevel.HasEnchantments enchantments) {
            if (hardness < 0.0f || Float.isInfinite(hardness)) {
                return (long)(200.0 * enchantments.getAccessor().breakBlock() * 1.0E9);
            }
            double modified = (double)hardness / (double)(1 + Math.max(0, enchantments.unbreakingLevel()));
            int fortune = enchantments.fortuneLevel();
            if (fortune != 0) {
                modified *= (double)(fortune + 1);
            }
            if (enchantments.silktouchLevel() != 0) {
                modified = Math.pow(modified, 1.4);
            }
            return (long)(modified * enchantments.getAccessor().breakBlock() * 1.0E9);
        }

        public static long getMoveEnergy(double distance, EnchantmentLevel.HasEnchantments enchantments) {
            return (long)(distance * enchantments.getAccessor().moveHead() * 1.0E9) / (long)(1 + Math.max(0, enchantments.unbreakingLevel()));
        }

        public static long getBreakBlockFluidEnergy(EnchantmentLevel.HasEnchantments enchantments) {
            return (long)(enchantments.getAccessor().removeFluid() * 1.0E9 / (double)(1 + Math.max(0, enchantments.unbreakingLevel())));
        }

        public static long getFillerEnergy(EnchantmentLevel.HasEnchantments enchantments) {
            return (long)(enchantments.getAccessor().breakBlock() * 1.0E9);
        }
    }
}

