/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.integration.QuarryFluidTransfer;
import com.yogpc.qp.integration.QuarryItemTransfer;
import com.yogpc.qp.machines.FluidKey;
import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.utils.MapMulti;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5558;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.VisibleForTesting;

public class MachineStorage {
    protected LinkedHashMap<ItemKey, Long> itemMap = new LinkedHashMap();
    protected LinkedHashMap<FluidKey, Long> fluidMap = new LinkedHashMap();
    public static final long ONE_BUCKET = 1000L;
    private static final int MAX_TRANSFER = 4;
    @VisibleForTesting
    static final List<class_2350> INSERT_ORDER = List.of(class_2350.field_11035, class_2350.field_11039, class_2350.field_11043, class_2350.field_11034, class_2350.field_11033, class_2350.field_11036);
    @VisibleForTesting
    final FabricItemStorageSnapshot fabricItemStorageSnapshot = new FabricItemStorageSnapshot();
    @VisibleForTesting
    final FabricFluidStorageSnapshot fabricFluidStorageSnapshot = new FabricFluidStorageSnapshot();

    public void addItem(class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        ItemKey key = new ItemKey(stack);
        this.itemMap.merge(key, Long.valueOf(stack.method_7947()), Long::sum);
    }

    public void addFluid(class_1799 bucketItem) {
        class_1792 class_17922 = bucketItem.method_7909();
        if (class_17922 instanceof class_1755) {
            class_1755 bucket = (class_1755)class_17922;
            FluidKey key = BucketFluidAccessor.getFluidInBucket(bucket);
            this.fluidMap.merge(key, 1000L, Long::sum);
        }
    }

    public void addFluid(class_3611 fluid, long amount) {
        FluidKey key = new FluidKey(fluid, null);
        this.fluidMap.merge(key, amount, (l1, l2) -> {
            long a = l1 + l2;
            if (a > 0L) {
                return a;
            }
            return null;
        });
    }

    public class_2487 toNbt() {
        class_2487 tag = new class_2487();
        class_2499 itemTag = new class_2499();
        this.itemMap.forEach((itemKey, count) -> itemTag.add((Object)itemKey.createNbt((long)count)));
        class_2499 fluidTag = new class_2499();
        this.fluidMap.forEach((fluidKey, amount) -> fluidTag.add((Object)fluidKey.createNbt((long)amount)));
        tag.method_10566("items", (class_2520)itemTag);
        tag.method_10566("fluids", (class_2520)fluidTag);
        return tag;
    }

    public void readNbt(class_2487 tag) {
        class_2499 itemTag = tag.method_10554("items", 10);
        this.itemMap = itemTag.stream().mapMulti(MapMulti.cast(class_2487.class)).map(n -> Pair.of((Object)ItemKey.fromNbt(n), (Object)n.method_10537("count"))).filter(p -> ((ItemKey)p.getLeft()).item() != class_1802.field_8162).collect(Collectors.toMap(Pair::getKey, Pair::getValue, Long::sum, LinkedHashMap::new));
        class_2499 fluidTag = tag.method_10554("fluids", 10);
        this.fluidMap = fluidTag.stream().mapMulti(MapMulti.cast(class_2487.class)).map(n -> Pair.of((Object)FluidKey.fromNbt(n), (Object)n.method_10537("amount"))).filter(p -> ((FluidKey)p.getLeft()).fluid() != class_3612.field_15906).collect(Collectors.toMap(Pair::getKey, Pair::getValue, Long::sum, LinkedHashMap::new));
    }

    public Map<FluidKey, Long> getFluidMap() {
        return Map.copyOf(this.fluidMap);
    }

    private void putFluid(class_3611 fluid, long amount) {
        FluidKey key = new FluidKey(fluid, null);
        if (amount <= 0L) {
            this.fluidMap.remove(key);
        } else {
            this.fluidMap.put(key, amount);
        }
    }

    public static <T extends class_2586> class_5558<T> passItems() {
        return (world, pos, state, blockEntity) -> {
            MachineStorage storage = ((HasStorage)blockEntity).getStorage();
            int count = 0;
            for (class_2350 direction : INSERT_ORDER) {
                if (!QuarryItemTransfer.destinationExists(world, pos.method_10093(direction), direction.method_10153())) continue;
                ArrayList<Map.Entry<ItemKey, Long>> itemMap = new ArrayList<Map.Entry<ItemKey, Long>>(storage.itemMap.entrySet());
                for (Map.Entry<ItemKey, Long> entry : itemMap) {
                    long beforeCount = entry.getValue();
                    boolean flag = true;
                    while (beforeCount > 0L && flag && count < 4) {
                        class_1799 rest;
                        int itemCount = (int)Math.min((long)entry.getKey().item().method_7882(), beforeCount);
                        if (itemCount != (rest = QuarryItemTransfer.transfer(world, pos.method_10093(direction), entry.getKey().toStack(itemCount), direction.method_10153())).method_7947()) {
                            long remain;
                            beforeCount = remain = beforeCount - (long)(itemCount - rest.method_7947());
                            if (remain > 0L) {
                                storage.itemMap.put(entry.getKey(), remain);
                            } else {
                                storage.itemMap.remove(entry.getKey());
                            }
                            ++count;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
        };
    }

    public static <T extends class_2586> class_5558<T> passFluid() {
        if (QuarryFluidTransfer.isRegistered()) {
            return (world, pos, state, blockEntity) -> {
                MachineStorage storage = ((HasStorage)blockEntity).getStorage();
                int count = 0;
                for (class_2350 direction : INSERT_ORDER) {
                    class_2338 destPos = pos.method_10093(direction);
                    class_2586 tile = world.method_8321(destPos);
                    if (tile == null) continue;
                    ArrayList<Map.Entry<FluidKey, Long>> fluidMap = new ArrayList<Map.Entry<FluidKey, Long>>(storage.getFluidMap().entrySet());
                    for (Map.Entry<FluidKey, Long> entry : fluidMap) {
                        Pair<class_3611, Long> excess = QuarryFluidTransfer.transfer(world, destPos, tile, entry.getKey().fluid(), entry.getValue(), direction.method_10153());
                        if (entry.getValue().equals(excess.getValue())) continue;
                        storage.putFluid(entry.getKey().fluid(), (Long)excess.getValue());
                        if (++count <= 4) continue;
                        return;
                    }
                }
            };
        }
        return null;
    }

    public static ExtractionOnlyStorage<ItemVariant> getItemStorage(class_2586 blockEntity, class_2350 context) {
        if (blockEntity instanceof HasStorage) {
            HasStorage hasStorage = (HasStorage)blockEntity;
            return hasStorage.getStorage().fabricItemStorageSnapshot;
        }
        return null;
    }

    public static ExtractionOnlyStorage<FluidVariant> getFluidStorage(class_2586 blockEntity, class_2350 context) {
        if (blockEntity instanceof HasStorage) {
            HasStorage hasStorage = (HasStorage)blockEntity;
            return hasStorage.getStorage().fabricFluidStorageSnapshot;
        }
        return null;
    }

    private class FabricItemStorageSnapshot
    extends SnapshotParticipant<LinkedHashMap<ItemKey, Long>>
    implements ExtractionOnlyStorage<ItemVariant> {
        private FabricItemStorageSnapshot() {
        }

        protected LinkedHashMap<ItemKey, Long> createSnapshot() {
            return new LinkedHashMap<ItemKey, Long>(MachineStorage.this.itemMap);
        }

        protected void readSnapshot(LinkedHashMap<ItemKey, Long> snapshot) {
            MachineStorage.this.itemMap = snapshot;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            ItemKey key = new ItemKey(resource.getItem(), resource.getNbt());
            if (MachineStorage.this.itemMap.containsKey(key)) {
                long amount = MachineStorage.this.itemMap.get(key);
                long extracted = Math.min(maxAmount, amount);
                long remain = amount - extracted;
                this.updateSnapshots(transaction);
                if (remain > 0L) {
                    MachineStorage.this.itemMap.put(key, remain);
                } else {
                    MachineStorage.this.itemMap.remove(key);
                }
                return extracted;
            }
            return 0L;
        }

        public Iterator<StorageView<ItemVariant>> iterator() {
            CombinedStorage combinedStorage = new CombinedStorage(MachineStorage.this.itemMap.keySet().stream().map(x$0 -> new Element((ItemKey)x$0)).toList());
            return combinedStorage.iterator();
        }

        private final class Element
        implements ExtractionOnlyStorage<ItemVariant>,
        SingleSlotStorage<ItemVariant> {
            private final ItemKey itemKey;

            private Element(ItemKey itemKey) {
                this.itemKey = itemKey;
            }

            public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
                return FabricItemStorageSnapshot.this.extract(resource, maxAmount, transaction);
            }

            public boolean isResourceBlank() {
                return this.getResource().isBlank();
            }

            public ItemVariant getResource() {
                return ItemVariant.of((class_1935)this.itemKey.item(), (class_2487)this.itemKey.nbt());
            }

            public long getAmount() {
                return MachineStorage.this.itemMap.getOrDefault(this.itemKey, 0L);
            }

            public long getCapacity() {
                return Integer.MAX_VALUE;
            }

            public String toString() {
                return "ItemElement[itemKey=" + this.itemKey + ", amount=" + this.getAmount() + "]";
            }
        }
    }

    private class FabricFluidStorageSnapshot
    extends SnapshotParticipant<LinkedHashMap<FluidKey, Long>>
    implements ExtractionOnlyStorage<FluidVariant> {
        private FabricFluidStorageSnapshot() {
        }

        protected LinkedHashMap<FluidKey, Long> createSnapshot() {
            return new LinkedHashMap<FluidKey, Long>(MachineStorage.this.fluidMap);
        }

        protected void readSnapshot(LinkedHashMap<FluidKey, Long> snapshot) {
            MachineStorage.this.fluidMap = snapshot;
        }

        public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            FluidKey key = new FluidKey(resource.getFluid(), resource.getNbt());
            if (MachineStorage.this.fluidMap.containsKey(key)) {
                long amount = MachineStorage.this.fluidMap.get(key);
                long amountFabric = amount * 81000L / 1000L;
                this.updateSnapshots(transaction);
                long extractedFabric = Math.min(maxAmount, amountFabric);
                long extracted = extractedFabric * 1000L / 81000L;
                MachineStorage.this.addFluid(key.fluid(), -extracted);
                return extractedFabric;
            }
            return 0L;
        }

        public Iterator<StorageView<FluidVariant>> iterator() {
            CombinedStorage combinedStorage = new CombinedStorage(MachineStorage.this.fluidMap.keySet().stream().map(x$0 -> new Element((FluidKey)x$0)).toList());
            return combinedStorage.iterator();
        }

        private final class Element
        implements ExtractionOnlyStorage<FluidVariant>,
        SingleSlotStorage<FluidVariant> {
            private final FluidKey fluidKey;

            private Element(FluidKey fluidKey) {
                this.fluidKey = fluidKey;
            }

            public long extract(FluidVariant resource, long maxAmount, TransactionContext transaction) {
                return FabricFluidStorageSnapshot.this.extract(resource, maxAmount, transaction);
            }

            public boolean isResourceBlank() {
                return this.getResource().isBlank();
            }

            public FluidVariant getResource() {
                return FluidVariant.of((class_3611)this.fluidKey.fluid(), (class_2487)this.fluidKey.nbt());
            }

            public long getAmount() {
                return MachineStorage.this.fluidMap.getOrDefault(this.fluidKey, 0L) * 81000L / 1000L;
            }

            public long getCapacity() {
                return Long.MAX_VALUE;
            }

            public String toString() {
                return "FluidElement{fluidKey=" + this.fluidKey + ", amount=" + this.getAmount() + "]";
            }
        }
    }

    private static class BucketFluidAccessor {
        private static final Map<class_1755, class_3611> BUCKET_ITEM_FLUID_MAP = new HashMap<class_1755, class_3611>();
        private static final Field BUCKET_FLUID_FIELD;

        private BucketFluidAccessor() {
        }

        private static FluidKey getFluidInBucket(class_1755 bucket) {
            class_3611 fluid = BUCKET_ITEM_FLUID_MAP.computeIfAbsent(bucket, t -> {
                try {
                    return (class_3611)BUCKET_FLUID_FIELD.get(t);
                }
                catch (ReflectiveOperationException ignore) {
                    return class_3612.field_15906;
                }
            });
            return new FluidKey(fluid, null);
        }

        static {
            try {
                String bucketItemClassName = FabricLoader.getInstance().getMappingResolver().unmapClassName("intermediary", class_1755.class.getName());
                String fluidClassName = FabricLoader.getInstance().getMappingResolver().unmapClassName("intermediary", class_3611.class.getName());
                String fluidFieldBucketItem = FabricLoader.getInstance().getMappingResolver().mapFieldName("intermediary", bucketItemClassName, "field_7905", "L%s;".formatted(fluidClassName.replace('.', '/')));
                BUCKET_FLUID_FIELD = class_1755.class.getDeclaredField(fluidFieldBucketItem);
                BUCKET_FLUID_FIELD.trySetAccessible();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface HasStorage {
        public MachineStorage getStorage();
    }
}

