/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.ItemKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;

public record ItemConverter(List<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>> conversionMap) {
    public ItemConverter(Map<ItemKey, ItemKey> map) {
        this(map.entrySet().stream().map((? super T e) -> {
            Predicate predicate = Predicate.isEqual(e.getKey());
            Function<ItemKey, ItemKey> converter = i -> (ItemKey)e.getValue();
            return Map.entry(predicate, converter);
        }).toList());
    }

    public class_1799 map(class_1799 before) {
        if (this.conversionMap().isEmpty()) {
            return before;
        }
        ItemKey key = new ItemKey(before);
        return this.conversionMap().stream().filter(e -> ((Predicate)e.getKey()).test(key)).findFirst().map(Map.Entry::getValue).map((? super T f) -> (ItemKey)f.apply(key)).map((? super T k) -> k.toStack(before.method_7947())).orElse(before);
    }

    public ItemConverter combined(ItemConverter other) {
        ArrayList<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>> newList = new ArrayList<Map.Entry<Predicate<ItemKey>, Function<ItemKey, ItemKey>>>(this.conversionMap());
        newList.addAll(other.conversionMap());
        return new ItemConverter(newList);
    }

    public static ItemConverter defaultConverter() {
        if (QuarryPlus.config.common.convertDeepslateOres) {
            return ItemConverter.deepslateConverter();
        }
        return new ItemConverter(List.of());
    }

    public static ItemConverter deepslateConverter() {
        Predicate<ItemKey> predicate = i -> {
            String path = i.getId().method_12832();
            return path.contains("deepslate") && path.contains("ore");
        };
        Function<ItemKey, ItemKey> function = i -> {
            String newPath = i.getId().method_12832().replace("deepslate_", "").replace("_deepslate", "");
            class_2960 id = new class_2960(i.getId().method_12836(), newPath);
            if (class_7923.field_41178.method_10250(id)) {
                return new ItemKey((class_1792)class_7923.field_41178.method_10223(id), i.nbt());
            }
            return null;
        };
        return new ItemConverter(List.of(Pair.of(predicate, function)));
    }

    public static ItemConverter advQuarryConverter() {
        if (QuarryPlus.config.common.removesCommonMaterialAdvQuarry) {
            Function<ItemKey, ItemKey> function = itemKey -> new ItemKey(class_1799.field_8037);
            return new ItemConverter(Stream.of(ItemConverter.itemPredicate(class_1802.field_20391), ItemConverter.itemPredicate(class_1802.field_20394), ItemConverter.itemPredicate(class_1802.field_20401), ItemConverter.itemPredicate(class_1802.field_20407), ItemConverter.tagPredicate((class_6862<class_1792>)class_3489.field_23802), ItemConverter.itemPredicate(class_1802.field_8831), ItemConverter.itemPredicate(class_1802.field_8270), ItemConverter.itemPredicate(class_1802.field_8328), ItemConverter.itemPredicate(class_1802.field_28866), ItemConverter.itemPredicate(class_1802.field_27021), ItemConverter.itemPredicate(class_1802.field_23843), ItemConverter.itemPredicate(class_1802.field_20384)).map((? super T p) -> Map.entry(p, function)).toList());
        }
        return new ItemConverter(List.of());
    }

    static Predicate<ItemKey> tagPredicate(class_6862<class_1792> tag) {
        return itemKey -> itemKey.toStack(1).method_31573(tag);
    }

    static Predicate<ItemKey> itemPredicate(class_1792 item) {
        return itemKey -> itemKey.item() == item;
    }
}

