/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.machines.PowerTile;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class EnergyCounter {
    private static final Logger LOGGER = LogManager.getLogger(EnergyCounter.class);
    final String name;
    final long logInterval;

    public EnergyCounter(String name) {
        this.name = name;
        this.logInterval = 100L;
    }

    public static EnergyCounter createInstance(boolean isDebug, String name) {
        if (isDebug) {
            return new Debug(name);
        }
        return new Production();
    }

    public abstract void logOutput(long var1);

    public abstract void logUsageMap();

    public abstract void useEnergy(long var1, long var3, PowerTile.Reason var5);

    public abstract void getEnergy(long var1, long var3);

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + "', logInterval=" + this.logInterval + "}";
    }

    private static class Debug
    extends EnergyCounter {
        private long lastLogTick;
        private final Map<Long, Long> useCounter = new HashMap<Long, Long>();
        private final Map<Long, Long> getCounter = new HashMap<Long, Long>();
        private final Map<PowerTile.Reason, Long> usageMap = new EnumMap<PowerTile.Reason, Long>(PowerTile.Reason.class);

        public Debug(String name) {
            super(name);
        }

        @Override
        public void logOutput(long time) {
            if (time - this.lastLogTick >= this.logInterval) {
                this.lastLogTick = time;
                LongSummaryStatistics use = this.useCounter.values().stream().collect(Collectors.summarizingLong(Long::longValue));
                LongSummaryStatistics get = this.getCounter.values().stream().collect(Collectors.summarizingLong(Long::longValue));
                if (use.getSum() != 0L && get.getSum() != 0L) {
                    String useAverage = String.format("%.2f", use.getAverage() / 1.0E9);
                    String getAverage = String.format("%.2f", get.getAverage() / 1.0E9);
                    LOGGER.info("{}: Used {} FE in {} ticks({} FE/t). Got {} FE in {} ticks({} FE/t).", (Object)this.name, (Object)(use.getSum() / 1000000000L), (Object)use.getCount(), (Object)useAverage, (Object)(get.getSum() / 1000000000L), (Object)get.getCount(), (Object)getAverage);
                }
                this.useCounter.clear();
                this.getCounter.clear();
            }
        }

        @Override
        public void logUsageMap() {
            this.usageMap.entrySet().stream().map(e -> "%s -> %d".formatted(e.getKey(), e.getValue())).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        }

        private void checkTime(long time, String name) {
            if (this.lastLogTick == 0L) {
                this.lastLogTick = time;
            } else if (time - this.lastLogTick > this.logInterval) {
                LOGGER.warn("The last log time reset? Last: {}, Now({}): {}", (Object)this.lastLogTick, (Object)name, (Object)time);
            }
        }

        @Override
        public void useEnergy(long time, long amount, PowerTile.Reason reason) {
            this.checkTime(time, "USE");
            this.useCounter.merge(time, amount, Long::sum);
            this.usageMap.merge(reason, amount, Long::sum);
        }

        @Override
        public void getEnergy(long time, long amount) {
            this.checkTime(time, "GET");
            this.getCounter.merge(time, amount, Long::sum);
        }
    }

    private static class Production
    extends EnergyCounter {
        public Production() {
            super("Production");
        }

        @Override
        public void logOutput(long time) {
        }

        @Override
        public void logUsageMap() {
        }

        @Override
        public void useEnergy(long time, long amount, PowerTile.Reason reason) {
        }

        @Override
        public void getEnergy(long time, long amount) {
        }
    }
}

