/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.EnergyConfigAccessor;
import com.yogpc.qp.utils.ManualOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public record EnchantmentLevel(class_1887 enchantment, int level) {
    public static final Comparator<EnchantmentLevel> COMPARATOR = Comparator.comparingInt(e -> class_7923.field_41176.method_10206((Object)e.enchantment())).thenComparingInt(EnchantmentLevel::level);
    public static final Comparator<EnchantmentLevel> QUARRY_ENCHANTMENT_COMPARATOR = Comparator.comparing(EnchantmentLevel::enchantment, ManualOrder.builder(Comparator.comparingInt(arg_0 -> ((class_2378)class_7923.field_41176).method_10206(arg_0))).add(class_1893.field_9131).add(class_1893.field_9119).add(class_1893.field_9130).add(class_1893.field_9099).build()).thenComparingInt(EnchantmentLevel::level);

    public EnchantmentLevel(Map.Entry<class_1887, Integer> entry) {
        this(entry.getKey(), (int)entry.getValue());
    }

    public EnchantmentLevel(class_2960 enchantmentID, int level) {
        this((class_1887)class_7923.field_41176.method_10223(enchantmentID), level);
    }

    @Nullable
    public class_2960 enchantmentID() {
        return class_7923.field_41176.method_10221((Object)this.enchantment());
    }

    public static List<EnchantmentLevel> fromItem(class_1799 stack) {
        class_2499 enchantmentList = stack.method_7921();
        if (enchantmentList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EnchantmentLevel> list = new ArrayList<EnchantmentLevel>(enchantmentList.size());
        for (int i = 0; i < enchantmentList.size(); ++i) {
            class_2487 tag = enchantmentList.method_10602(i);
            class_2960 name = class_1890.method_37427((class_2487)tag);
            int level = class_1890.method_37424((class_2487)tag);
            if (name == null || !class_7923.field_41176.method_10250(name)) continue;
            list.add(new EnchantmentLevel(name, level));
        }
        return list;
    }

    @Override
    public String toString() {
        return "EnchantmentLevel[enchantment=" + this.enchantment.getClass().getSimpleName().replace("Enchantment", "") + ", level=" + this.level + "]";
    }

    public static interface HasEnchantments {
        public List<EnchantmentLevel> getEnchantments();

        default public int getLevel(class_1887 enchantment) {
            return this.getEnchantments().stream().filter(e -> e.enchantment() == enchantment).mapToInt(EnchantmentLevel::level).findFirst().orElse(0);
        }

        default public int efficiencyLevel() {
            return this.getLevel(class_1893.field_9131);
        }

        default public int unbreakingLevel() {
            return this.getLevel(class_1893.field_9119);
        }

        default public int fortuneLevel() {
            return this.getLevel(class_1893.field_9130);
        }

        default public int silktouchLevel() {
            return this.getLevel(class_1893.field_9099);
        }

        default public class_1799 getPickaxe() {
            class_1799 stack = new class_1799((class_1935)class_1802.field_22024);
            this.getEnchantments().forEach(e -> stack.method_7978(e.enchantment(), e.level()));
            return stack;
        }

        default public EnergyConfigAccessor getAccessor() {
            QuarryPlus.LOGGER.warn("Default implementation of HasEnchantments#getAccessor is called. {}", this.getClass());
            return EnergyConfigAccessor.ONES;
        }
    }
}

