/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Area(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, class_2350 direction) implements Serializable
{
    private static final long serialVersionUID = 1L;

    public Area(class_2382 pos1, class_2382 pos2, class_2350 direction) {
        this(Math.min(pos1.method_10263(), pos2.method_10263()), Math.min(pos1.method_10264(), pos2.method_10264()), Math.min(pos1.method_10260(), pos2.method_10260()), Math.max(pos1.method_10263(), pos2.method_10263()), Math.max(pos1.method_10264(), pos2.method_10264()), Math.max(pos1.method_10260(), pos2.method_10260()), direction);
    }

    public Area assureY(int minSpaceY) {
        int space = this.maxY - this.minY;
        if (space >= minSpaceY) {
            return this;
        }
        return new Area(this.minX, this.minY, this.minZ, this.maxX, this.minY + minSpaceY, this.maxZ, this.direction);
    }

    public Area aboveY(int minY) {
        if (this.minY < minY && minY <= this.maxY) {
            return new Area(this.minX, minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.direction);
        }
        return this;
    }

    public boolean isInAreaIgnoreY(class_2382 vec3i) {
        return this.minX < vec3i.method_10263() && vec3i.method_10263() < this.maxX && this.minZ < vec3i.method_10260() && vec3i.method_10260() < this.maxZ;
    }

    public int sizeOfEachY() {
        return (this.maxX() - this.minX()) * (this.maxZ() - this.minZ());
    }

    public class_2487 toNBT() {
        class_2487 tag = new class_2487();
        tag.method_10569("minX", this.minX);
        tag.method_10569("minY", this.minY);
        tag.method_10569("minZ", this.minZ);
        tag.method_10569("maxX", this.maxX);
        tag.method_10569("maxY", this.maxY);
        tag.method_10569("maxZ", this.maxZ);
        tag.method_10582("direction", this.direction.method_10151());
        return tag;
    }

    public static Optional<Area> fromNBT(@Nullable class_2487 tag) {
        if (tag == null || tag.method_33133()) {
            return Optional.empty();
        }
        return Optional.of(new Area(tag.method_10550("minX"), tag.method_10550("minY"), tag.method_10550("minZ"), tag.method_10550("maxX"), tag.method_10550("maxY"), tag.method_10550("maxZ"), class_2350.method_10168((String)tag.method_10558("direction"))));
    }

    @NotNull
    public static Stream<class_2338> getFramePosStream(@NotNull Area area) {
        return Stream.of(Area.makeSquare(area, area.minY()), Area.makePole(area, area.minY() + 1, area.maxY()), Area.makeSquare(area, area.maxY())).flatMap(Function.identity());
    }

    static IntStream to(int first, int endInclusive) {
        if (first < endInclusive) {
            return IntStream.rangeClosed(first, endInclusive);
        }
        if (first > endInclusive) {
            return IntStream.iterate(first, i -> i >= endInclusive, i -> i - 1);
        }
        return IntStream.of(first);
    }

    static Stream<class_2338> makeSquare(Area area, int y) {
        return Stream.of(Area.to(area.minX(), area.maxX()).mapToObj(x -> new class_2338(x, y, area.minZ())), Area.to(area.minZ(), area.maxZ()).mapToObj(z -> new class_2338(area.maxX(), y, z)), Area.to(area.maxX(), area.minX()).mapToObj(x -> new class_2338(x, y, area.maxZ())), Area.to(area.maxZ(), area.minZ()).mapToObj(z -> new class_2338(area.minX(), y, z))).flatMap(Function.identity());
    }

    static Stream<class_2338> makePole(Area area, int yMin, int yMax) {
        return Area.to(yMin, yMax).boxed().flatMap(y -> Stream.of(new class_2338(area.minX(), y.intValue(), area.minZ()), new class_2338(area.maxX(), y.intValue(), area.minZ()), new class_2338(area.maxX(), y.intValue(), area.maxZ()), new class_2338(area.minX(), y.intValue(), area.maxZ())));
    }
}

