/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.PowerTile;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

class RebornEnergyStorage
extends SnapshotParticipant<Long>
implements EnergyStorage {
    public static final long CONVERSION_RATE = (long)(1.0E9 * QuarryPlus.config.power.rebornEnergyConversionCoefficient);
    private final PowerTile powerTile;

    public RebornEnergyStorage(PowerTile powerTile) {
        this.powerTile = powerTile;
    }

    public long getAmount() {
        return this.powerTile.getEnergy() / CONVERSION_RATE;
    }

    protected void readSnapshot(Long snapshot) {
        long current = this.powerTile.getEnergy();
        long updated = snapshot;
        this.powerTile.addEnergy(updated - current, false);
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        long insertSimulate = Math.min(maxAmount, this.getCapacity() - this.getAmount());
        if (insertSimulate > 0L) {
            this.updateSnapshots(transaction);
            long inserted = this.powerTile.addEnergy(insertSimulate * CONVERSION_RATE, false);
            return inserted / CONVERSION_RATE;
        }
        return 0L;
    }

    public long getCapacity() {
        return this.powerTile.getMaxEnergy() / CONVERSION_RATE;
    }

    public boolean supportsExtraction() {
        return false;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        return 0L;
    }

    protected Long createSnapshot() {
        return this.powerTile.getEnergy();
    }
}

