/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.misc.CreativeGeneratorTile;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import team.reborn.energy.api.EnergyStorage;

final class RebornEnergyGenerator
extends SnapshotParticipant<Long>
implements EnergyStorage {
    public static final long CONVERSION_RATE = (long)(1.0E9 * QuarryPlus.config.power.rebornEnergyConversionCoefficient);
    private final CreativeGeneratorTile generator;

    RebornEnergyGenerator(CreativeGeneratorTile generator) {
        this.generator = generator;
    }

    protected Long createSnapshot() {
        return this.generator.getSendEnergy();
    }

    protected void readSnapshot(Long snapshot) {
        this.generator.setSendEnergy(snapshot);
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        return 0L;
    }

    public boolean supportsInsertion() {
        return false;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        return Math.min(maxAmount, this.generator.getSendEnergy() / CONVERSION_RATE);
    }

    public long getAmount() {
        return this.generator.getEnergy() / CONVERSION_RATE;
    }

    public long getCapacity() {
        return this.generator.getMaxEnergy() / CONVERSION_RATE;
    }
}

