/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.FabricFluidTransfer;
import com.yogpc.qp.integration.FluidTransfer;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3611;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class QuarryFluidTransfer {
    private static boolean registered;
    private static final List<FluidTransfer> transfers;

    public static boolean isRegistered() {
        return registered;
    }

    public static void register() {
        if (FabricLoader.getInstance().isModLoaded("fabric-transfer-api-v1")) {
            QuarryPlus.LOGGER.debug("Trying to register fabric fluid transfer api.");
            FabricFluidTransfer.register();
            transfers.add(new FabricFluidTransfer());
            registered = true;
        }
    }

    public static Pair<class_3611, Long> transfer(class_1937 world, class_2338 pos, @NotNull class_2586 destination, class_3611 fluid, long amount, class_2350 direction) {
        if (!registered) {
            return Pair.of((Object)fluid, (Object)amount);
        }
        for (FluidTransfer transfer : transfers) {
            if (!transfer.acceptable(world, pos, direction, destination)) continue;
            Pair<class_3611, Long> excess = transfer.transfer(world, pos, destination, direction, amount, fluid);
            if ((Long)excess.getRight() == 0L) {
                return excess;
            }
            fluid = (class_3611)excess.getLeft();
            amount = (Long)excess.getRight();
        }
        return Pair.of((Object)fluid, (Object)amount);
    }

    static {
        transfers = new ArrayList<FluidTransfer>();
    }
}

