/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.ItemTransfer;
import com.yogpc.qp.machines.MachineStorage;
import com.yogpc.qp.machines.filler.FillerEntity;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FabricItemTransfer
implements ItemTransfer<Storage<ItemVariant>> {
    FabricItemTransfer() {
    }

    static void register() {
        ItemStorage.SIDED.registerForBlockEntities(MachineStorage::getItemStorage, new class_2591[]{QuarryPlus.ModObjects.ADV_QUARRY_TYPE, QuarryPlus.ModObjects.QUARRY_TYPE});
        ItemStorage.SIDED.registerForBlockEntities(FillerEntity::getFillerStorage, new class_2591[]{QuarryPlus.ModObjects.FILLER_TYPE});
    }

    static ItemTransfer<?> fabricTransfer() {
        return new FabricItemTransfer();
    }

    @Override
    @Nullable
    public Storage<ItemVariant> getDestination(class_1937 world, class_2338 pos, class_2350 direction) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215()) {
            return null;
        }
        return (Storage)ItemStorage.SIDED.find(world, pos, state, null, (Object)direction);
    }

    @Override
    public boolean isValidDestination(Storage<ItemVariant> itemVariantStorage) {
        return itemVariantStorage != null && itemVariantStorage.supportsInsertion();
    }

    @Override
    @NotNull
    public class_1799 transfer(Storage<ItemVariant> destination, class_1799 send, class_2350 direction) {
        long insertAmount;
        Objects.requireNonNull(destination, "The destination must be checked with a method `isValidDestination`.");
        try (Transaction simulationTransaction = Transaction.openOuter();){
            insertAmount = destination.insert((Object)ItemVariant.of((class_1799)send), (long)send.method_7947(), (TransactionContext)simulationTransaction);
            simulationTransaction.abort();
        }
        if (insertAmount > 0L) {
            long inserted;
            class_1799 copy = send.method_7972();
            try (Transaction executionTransaction = Transaction.openOuter();){
                inserted = destination.insert((Object)ItemVariant.of((class_1799)send), insertAmount, (TransactionContext)executionTransaction);
                executionTransaction.commit();
            }
            copy.method_7934((int)inserted);
            return copy;
        }
        return send;
    }
}

