/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.integration.FluidTransfer;
import com.yogpc.qp.machines.MachineStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_3611;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

class FabricFluidTransfer
implements FluidTransfer {
    FabricFluidTransfer() {
    }

    static void register() {
        FluidStorage.SIDED.registerForBlockEntities(MachineStorage::getFluidStorage, new class_2591[]{QuarryPlus.ModObjects.ADV_QUARRY_TYPE, QuarryPlus.ModObjects.QUARRY_TYPE, QuarryPlus.ModObjects.ADV_PUMP_TYPE});
    }

    @Override
    public boolean acceptable(class_1937 world, class_2338 pos, class_2350 direction, class_2586 entity) {
        return FluidStorage.SIDED.find(world, pos, null, entity, (Object)direction) != null;
    }

    @Override
    @NotNull
    public Pair<class_3611, Long> transfer(class_1937 world, class_2338 pos, @NotNull class_2586 destination, class_2350 direction, long amount, class_3611 fluid) {
        long insertAmount;
        Storage storage = (Storage)FluidStorage.SIDED.find(world, pos, null, destination, (Object)direction);
        if (storage == null) {
            return Pair.of((Object)fluid, (Object)amount);
        }
        try (Transaction simulationTransaction = Transaction.openOuter();){
            insertAmount = storage.insert((Object)FluidVariant.of((class_3611)fluid), amount / 1000L * 81000L, (TransactionContext)simulationTransaction);
            simulationTransaction.abort();
        }
        if (insertAmount > 0L) {
            long inserted;
            try (Transaction executionTransaction = Transaction.openOuter();){
                inserted = storage.insert((Object)FluidVariant.of((class_3611)fluid), insertAmount, (TransactionContext)executionTransaction) / 81000L * 1000L;
                executionTransaction.commit();
            }
            return Pair.of((Object)fluid, (Object)(amount - inserted));
        }
        return Pair.of((Object)fluid, (Object)amount);
    }
}

