/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.loader.api.FabricLoader;

@Config(name="quarryplus")
public class QuarryConfig
implements ConfigData {
    @ConfigEntry.Gui.CollapsibleObject
    public Common common = new Common();
    @ConfigEntry.Gui.CollapsibleObject
    public Power power = new Power();
    @ConfigEntry.Gui.CollapsibleObject
    public Quarry quarry = new Quarry();
    @ConfigEntry.Gui.CollapsibleObject
    public AdvPump adv_pump = new AdvPump();
    @ConfigEntry.Gui.CollapsibleObject
    public AdvQuarry adv_quarry = new AdvQuarry();
    @ConfigEntry.Gui.CollapsibleObject
    public Filler filler = new Filler();

    public static class Common {
        @ConfigEntry.Category(value="default")
        public boolean debug;
        @ConfigEntry.Category(value="default")
        @ConfigEntry.BoundedDiscrete(min=-128L, max=512L)
        public int netherTop;
        @ConfigEntry.Category(value="default")
        @ConfigEntry.Gui.RequiresRestart
        public boolean noEnergy = false;
        @ConfigEntry.Category(value="default")
        @ConfigEntry.Gui.RequiresRestart
        public boolean convertDeepslateOres = false;
        @ConfigEntry.Category(value="default")
        @ConfigEntry.Gui.RequiresRestart
        public boolean removesCommonMaterialAdvQuarry = true;
        @ConfigEntry.Category(value="default")
        public boolean removeFrameAfterQuarryIsRemoved = false;

        public Common() {
            try {
                this.debug = FabricLoader.getInstance().isDevelopmentEnvironment();
                this.netherTop = FabricLoader.getInstance().isDevelopmentEnvironment() ? 128 : 127;
            }
            catch (Throwable ignore) {
                this.debug = true;
                this.netherTop = 128;
            }
        }
    }

    public static class Power {
        @ConfigEntry.Category(value="common.power")
        @ConfigEntry.Gui.RequiresRestart
        public double rebornEnergyConversionCoefficient = 0.0625;
        @ConfigEntry.Category(value="common.power")
        public int creativeGeneratorGeneration = 1000;
    }

    public static class Quarry {
        @ConfigEntry.Category(value="common.power")
        @ConfigEntry.Gui.RequiresRestart
        public double quarryEnergyCapacity = 10000.0;
        @ConfigEntry.Category(value="common.power")
        public double quarryEnergyMakeFrame = 15.0;
        @ConfigEntry.Category(value="common.power")
        public double quarryEnergyBreakBlock = 10.0;
        @ConfigEntry.Category(value="common.power")
        public double quarryEnergyRemoveFluid = this.quarryEnergyBreakBlock * 5.0;
        @ConfigEntry.Category(value="common.power")
        public double quarryEnergyMoveHead = 0.5;
    }

    public static class AdvPump {
        @ConfigEntry.Category(value="common.power")
        @ConfigEntry.Gui.RequiresRestart
        public double advPumpEnergyCapacity = 1000.0;
        @ConfigEntry.Category(value="common.power")
        public double advPumpEnergyRemoveFluid = 20.0;
    }

    public static class AdvQuarry {
        @ConfigEntry.Category(value="common.power")
        @ConfigEntry.Gui.RequiresRestart
        public double advQuarryEnergyCapacity = 50000.0;
        @ConfigEntry.Category(value="common.power")
        public double advQuarryEnergyMakeFrame = 15.0;
        @ConfigEntry.Category(value="common.power")
        public double advQuarryEnergyBreakBlock = 10.0;
        @ConfigEntry.Category(value="common.power")
        public double advQuarryEnergyRemoveFluid = this.advQuarryEnergyBreakBlock * 5.0;
        @ConfigEntry.Category(value="common.power")
        public double advQuarryEnergyMoveHead = 25.0;
    }

    public static class Filler {
        @ConfigEntry.Category(value="common.power")
        @ConfigEntry.Gui.RequiresRestart
        public double fillerEnergyCapacity = 1000.0;
        @ConfigEntry.Category(value="common.power")
        public double fillerEnergyBreakBlock = 10.0;
    }

    private static class Constant {
        @ConfigEntry.Gui.Excluded
        private static final String COMMON_CATEGORY = "default";
        @ConfigEntry.Gui.Excluded
        private static final String COMMON_POWER_CATEGORY = "common.power";

        private Constant() {
        }
    }
}

