/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.coderbot.iris.gl.shader.StandardMacros;
import net.coderbot.iris.parsing.BiomeCategories;
import net.coderbot.iris.shaderpack.StringPair;
import net.coderbot.iris.uniforms.BiomeParameters;

public class IrisDefines {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)\\.*(?<bugfix>\\d*)(.*)");

    private static void define(List<StringPair> list, String string) {
        list.add(new StringPair(string, ""));
    }

    private static void define(List<StringPair> list, String string, String string2) {
        list.add(new StringPair(string, string2));
    }

    public static ImmutableList<StringPair> createIrisReplacements() {
        ArrayList<StringPair> arrayList = new ArrayList<StringPair>((Collection<StringPair>)StandardMacros.createStandardEnvironmentDefines());
        IrisDefines.define(arrayList, "PPT_NONE", "0");
        IrisDefines.define(arrayList, "PPT_RAIN", "1");
        IrisDefines.define(arrayList, "PPT_SNOW", "2");
        IrisDefines.define(arrayList, "BIOME_SWAMP_HILLS", "-1");
        BiomeParameters.getBiomeMap().forEach((class_53212, n) -> IrisDefines.define(arrayList, "BIOME_" + class_53212.method_29177().method_12832().toUpperCase(Locale.ROOT), String.valueOf(n)));
        BiomeCategories[] biomeCategoriesArray = BiomeCategories.values();
        for (int i = 0; i < biomeCategoriesArray.length; ++i) {
            IrisDefines.define(arrayList, "CAT_" + biomeCategoriesArray[i].name().toUpperCase(Locale.ROOT), String.valueOf(i));
        }
        return ImmutableList.copyOf(arrayList);
    }
}

